/*
 * Decompiled with CFR 0.152.
 */
package tern.server.protocol.outline;

import tern.server.protocol.outline.BaseJSNode;
import tern.server.protocol.outline.IJSNode;

public class JSNode
extends BaseJSNode {
    private static final String FN_TYPE = "fn(";
    private static final String ARRAY_TYPE = "[";
    private static final String IMPORT_KIND = "import";
    private static final String SPECIFIER_KIND = "specifier";
    private static final String CLASS_KIND = "class";
    private static final String PROPERTY_KIND = "property";
    private final String type;
    private final boolean isFunction;
    private final boolean isArray;
    private final boolean isProperty;
    private final boolean isClass;
    private final boolean isImport;
    private final boolean isSpecifier;

    public JSNode(String name, String type, String kind, String value, Long start, Long end, String file, IJSNode parent) {
        super(name, kind, value, start, end, file, parent);
        this.type = type;
        if (type != null) {
            this.isFunction = type.startsWith(FN_TYPE);
            this.isArray = type.startsWith(ARRAY_TYPE);
        } else {
            this.isFunction = false;
            this.isArray = false;
        }
        if (kind != null) {
            this.isClass = CLASS_KIND.equals(kind);
            this.isProperty = PROPERTY_KIND.equals(kind);
            this.isImport = IMPORT_KIND.equals(kind);
            this.isSpecifier = SPECIFIER_KIND.equals(kind);
        } else {
            this.isClass = false;
            this.isProperty = false;
            this.isImport = false;
            this.isSpecifier = false;
        }
    }

    public String getType() {
        return this.type;
    }

    public boolean isFunction() {
        return this.isFunction;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isClass() {
        return this.isClass;
    }

    public boolean isImport() {
        return this.isImport;
    }

    public boolean isSpecifier() {
        return this.isSpecifier;
    }

    public boolean isProperty() {
        return this.isProperty;
    }

    @Override
    public boolean isContainer() {
        return this.isFunction;
    }
}

