/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.core.preferences;

import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class PreferencesSupport {
    private HashMap projectToScope;
    private String nodeQualifier;
    private Preferences preferenceStore;

    public PreferencesSupport(String nodeQualifier, Preferences preferenceStore) {
        this.nodeQualifier = nodeQualifier;
        this.preferenceStore = preferenceStore;
        this.projectToScope = new HashMap();
    }

    public String getProjectSpecificPreferencesValue(String key, String def, IProject project) {
        assert (project != null);
        IEclipsePreferences node = this.getEclipsePreferences(project);
        if (node != null) {
            return node.get(key, def);
        }
        return null;
    }

    public IEclipsePreferences getEclipsePreferences(IProject project) {
        ProjectScope scope = (ProjectScope)this.projectToScope.get(project);
        if (scope == null) {
            scope = new ProjectScope(project);
            this.projectToScope.put(project, scope);
        }
        IEclipsePreferences node = scope.getNode(this.nodeQualifier);
        return node;
    }

    public String getPreferencesValue(String key, String def, IProject project) {
        if (project == null) {
            return this.getWorkspacePreferencesValue(key);
        }
        String projectSpecificPreferencesValue = this.getProjectSpecificPreferencesValue(key, def, project);
        if (projectSpecificPreferencesValue == null) {
            return this.getWorkspacePreferencesValue(key);
        }
        return projectSpecificPreferencesValue;
    }

    public String getWorkspacePreferencesValue(String key) {
        return this.preferenceStore == null ? null : this.preferenceStore.getString(key);
    }

    public static String getWorkspacePreferencesValue(String key, Preferences preferenceStore) {
        return preferenceStore.getString(key);
    }

    public boolean setProjectSpecificPreferencesValue(String key, String value, IProject project) {
        assert (project != null);
        if (!project.exists()) {
            return false;
        }
        IEclipsePreferences node = this.getEclipsePreferences(project);
        if (node != null) {
            node.put(key, value);
            try {
                node.flush();
            }
            catch (Exception exception) {}
            return true;
        }
        return false;
    }
}

