/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.core.scriptpath;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import tern.ITernFile;
import tern.ITernProject;
import tern.TernResourcesManager;
import tern.eclipse.ide.core.IIDETernScriptPathReporter;
import tern.eclipse.ide.internal.core.scriptpath.FolderScriptPath;
import tern.eclipse.ide.internal.core.scriptpath.IIDETernScriptPath;
import tern.scriptpath.ITernScriptPath;
import tern.scriptpath.ITernScriptResource;
import tern.scriptpath.impl.JSFileScriptResource;

public class ScriptResourceProxyVisitor
implements IResourceProxyVisitor {
    private final IIDETernScriptPath scriptPath;
    private final IIDETernScriptPathReporter reporter;
    private final List<ITernScriptResource> resources;
    private final boolean isAlsoProject;

    public ScriptResourceProxyVisitor(IIDETernScriptPath scriptPath, List<ITernScriptResource> resources, IIDETernScriptPathReporter reporter) {
        this.scriptPath = scriptPath;
        this.resources = resources;
        this.reporter = reporter;
        this.isAlsoProject = scriptPath.getType() == ITernScriptPath.ScriptPathsType.PROJECT;
    }

    public boolean visit(IResourceProxy proxy) throws CoreException {
        if (proxy.isDerived()) {
            return false;
        }
        int resourceType = proxy.getType();
        switch (resourceType) {
            case 4: {
                return true;
            }
            case 2: {
                IPath folderPath = proxy.requestFullPath();
                if (this.isAlsoProject && this.isExcludedFromProject(folderPath, this.scriptPath.getOwnerProject())) {
                    if (this.reporter != null) {
                        this.reporter.report(folderPath, this.scriptPath, "Exclude folder (from project) because a tern script folder path already include it.", false);
                    }
                    return false;
                }
                return this.isInScope(folderPath, resourceType);
            }
            case 1: {
                IPath path;
                String filename = proxy.getName();
                if (!TernResourcesManager.isJSFile((Object)filename) || !this.isInScope(path = proxy.requestFullPath(), resourceType)) break;
                IResource resource = proxy.requestResource();
                ITernFile file = TernResourcesManager.getTernFile((Object)resource);
                this.resources.add((ITernScriptResource)new JSFileScriptResource(this.scriptPath.getOwnerProject(), file));
            }
        }
        return false;
    }

    protected boolean isInScope(IPath path, int resourceType) {
        boolean include = this.scriptPath.isInScope(path, resourceType);
        if (this.reporter != null) {
            if (include) {
                this.reporter.report(path, this.scriptPath, null, true);
            } else {
                this.reporter.report(path, this.scriptPath, null, false);
            }
        }
        return include;
    }

    private boolean isExcludedFromProject(IPath folderPath, ITernProject ownerProject) {
        for (ITernScriptPath scriptPath : ownerProject.getScriptPaths()) {
            if (scriptPath.getType() != ITernScriptPath.ScriptPathsType.FOLDER || !folderPath.equals((Object)((FolderScriptPath)scriptPath).getFullPath())) continue;
            return true;
        }
        return false;
    }
}

