/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.server.nodejs.ui.debugger.launchConfigurations;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;
import tern.eclipse.ide.server.nodejs.core.IDENodejsProcessHelper;
import tern.eclipse.ide.server.nodejs.core.INodejsInstall;
import tern.eclipse.ide.server.nodejs.core.INodejsInstallManager;
import tern.eclipse.ide.server.nodejs.core.TernNodejsCorePlugin;
import tern.eclipse.ide.server.nodejs.core.debugger.launchConfigurations.NodejsCliFileHelper;
import tern.eclipse.ide.server.nodejs.internal.ui.TernNodejsUIMessages;
import tern.eclipse.ide.server.nodejs.internal.ui.TernNodejsUIPlugin;
import tern.eclipse.ide.server.nodejs.internal.ui.preferences.DebuggerFieldEditor;
import tern.eclipse.ide.server.nodejs.internal.ui.preferences.NodeJSConfigEditor;
import tern.utils.StringUtils;

public abstract class AbstractNodejsCliFileLaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    private Text cliFileField;
    private Button workspaceLocationButton;
    private Button variablesLocationButton;
    protected boolean fInitializing = false;
    private boolean userEdited = false;
    protected WidgetListener fListener = new WidgetListener();
    private Combo debuggerField;
    private String[][] debuggers;
    private Label nodePathTitle;
    private Text nodePathInfo;
    private Combo nodeInstallField;
    private String[][] nodeInstalls;
    private Combo nodePathField;
    private Button nodePathButton;

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        this.setControl((Control)mainComposite);
        mainComposite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData gridData = new GridData(768);
        mainComposite.setLayout((Layout)layout);
        mainComposite.setLayoutData((Object)gridData);
        this.createCliFileComponent(mainComposite);
        this.createDebuggerComponent(mainComposite);
        this.createNodeInstallComponent(mainComposite);
    }

    private void createCliFileComponent(Composite parent) {
        Group group = new Group(parent, 0);
        String cliFileLabel = this.getCliFileLabel();
        group.setText(cliFileLabel);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        this.cliFileField = new Text((Composite)group, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 200;
        this.cliFileField.setLayoutData((Object)gridData);
        this.cliFileField.addModifyListener((ModifyListener)this.fListener);
        this.addControlAccessibleListener((Control)this.cliFileField, group.getText());
        Composite buttonComposite = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        gridData = new GridData(128);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)gridData);
        buttonComposite.setFont(parent.getFont());
        this.workspaceLocationButton = this.createPushButton(buttonComposite, TernNodejsUIMessages.Button_browse_workspace, null);
        this.workspaceLocationButton.addSelectionListener((SelectionListener)this.fListener);
        this.addControlAccessibleListener((Control)this.workspaceLocationButton, String.valueOf(group.getText()) + " " + this.workspaceLocationButton.getText());
        this.variablesLocationButton = this.createPushButton(buttonComposite, TernNodejsUIMessages.Button_variables, null);
        this.variablesLocationButton.addSelectionListener((SelectionListener)this.fListener);
        this.addControlAccessibleListener((Control)this.variablesLocationButton, String.valueOf(group.getText()) + " " + this.variablesLocationButton.getText());
    }

    private void createDebuggerComponent(Composite parent) {
        Group group = new Group(parent, 0);
        String debuggerLabel = TernNodejsUIMessages.TernNodejsPreferencesPage_debugger_label;
        group.setText(debuggerLabel);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        this.debuggers = DebuggerFieldEditor.createDebuggers();
        this.debuggerField = new Combo((Composite)group, 8);
        this.debuggerField.setFont(group.getFont());
        int i = 0;
        while (i < this.debuggers.length) {
            this.debuggerField.add(this.debuggers[i][0], i);
            ++i;
        }
        this.debuggerField.setLayoutData((Object)new GridData(768));
        this.debuggerField.addSelectionListener((SelectionListener)this.fListener);
        this.addControlAccessibleListener((Control)this.debuggerField, group.getText());
        Link debuggerWikiLink = DebuggerFieldEditor.newWikiLink((Composite)group, 0);
        GridData gd = new GridData(768);
        debuggerWikiLink.setLayoutData((Object)gd);
    }

    private void createNodeInstallComponent(Composite parent) {
        Group group = new Group(parent, 0);
        String nodeInstallLabel = TernNodejsUIMessages.TernNodejsPreferencesPage_nodeJSInstall;
        group.setText(nodeInstallLabel);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)layout);
        this.nodeInstalls = NodeJSConfigEditor.createNodeInstalls();
        this.nodeInstallField = new Combo((Composite)group, 8);
        this.nodeInstallField.setFont(group.getFont());
        int i = 0;
        while (i < this.nodeInstalls.length) {
            this.nodeInstallField.add(this.nodeInstalls[i][0], i);
            ++i;
        }
        this.nodeInstallField.setLayoutData((Object)new GridData(768));
        this.nodeInstallField.addSelectionListener((SelectionListener)this.fListener);
        this.nodeInstallField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int nodeInstallSelectionIndex = AbstractNodejsCliFileLaunchConfigurationTab.this.nodeInstallField.getSelectionIndex();
                String nodeInstallId = AbstractNodejsCliFileLaunchConfigurationTab.this.nodeInstalls[nodeInstallSelectionIndex][1];
                INodejsInstall install = TernNodejsCorePlugin.getNodejsInstallManager().findNodejsInstall(nodeInstallId);
                if (install == null || install.isNative()) {
                    AbstractNodejsCliFileLaunchConfigurationTab.this.nodePathField.setEnabled(true);
                    String defaultPath = IDENodejsProcessHelper.getNodejsPath();
                    AbstractNodejsCliFileLaunchConfigurationTab.this.nodePathField.setText(defaultPath);
                    AbstractNodejsCliFileLaunchConfigurationTab.this.nodePathInfo.setText(defaultPath);
                } else {
                    AbstractNodejsCliFileLaunchConfigurationTab.this.nodePathField.setEnabled(false);
                    AbstractNodejsCliFileLaunchConfigurationTab.this.nodePathInfo.setText(install.getPath().getAbsolutePath());
                }
            }
        });
        this.addControlAccessibleListener((Control)this.nodeInstallField, group.getText());
        Composite pathComponent = new Composite((Composite)group, 0);
        pathComponent.setLayout((Layout)new GridLayout(2, false));
        pathComponent.setLayoutData((Object)new GridData(768));
        this.nodePathField = new Combo(pathComponent, 0);
        this.nodePathField.setFont(pathComponent.getFont());
        this.nodePathField.setItems(IDENodejsProcessHelper.getDefaultNodejsPaths());
        this.nodePathField.addSelectionListener((SelectionListener)this.fListener);
        this.nodePathField.addModifyListener((ModifyListener)this.fListener);
        this.nodePathField.setLayoutData((Object)new GridData(768));
        this.addControlAccessibleListener((Control)this.nodePathField, group.getText());
        this.nodePathButton = this.createPushButton(pathComponent, TernNodejsUIMessages.Button_browse, null);
        this.nodePathButton.addSelectionListener((SelectionListener)this.fListener);
        this.addControlAccessibleListener((Control)this.nodePathButton, String.valueOf(group.getText()) + " " + this.nodePathButton.getText());
        group.setLayoutData((Object)gridData);
        this.createNodePathInfo((Composite)group);
    }

    private void createNodePathInfo(Composite parent) {
        this.nodePathTitle = new Label(parent, 0);
        this.nodePathTitle.setText(TernNodejsUIMessages.TernNodejsPreferencesPage_nodeJSPath);
        GridData gridData = new GridData(2);
        this.nodePathTitle.setLayoutData((Object)gridData);
        this.nodePathInfo = new Text(parent, 72);
        this.nodePathInfo.setText("");
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 200;
        this.nodePathInfo.setLayoutData((Object)gridData);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.fInitializing = true;
        this.updateCliFile(configuration);
        this.updateDebugger(configuration);
        this.updateNodeInstallPath(configuration);
        this.fInitializing = false;
        this.setDirty(false);
    }

    private void updateCliFile(ILaunchConfiguration configuration) {
        String cliFile = "";
        try {
            cliFile = configuration.getAttribute(this.getCliFileLaunchAttrId(), "");
        }
        catch (CoreException ce) {
            TernNodejsUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "tern.eclipse.ide.server.nodejs.ui", TernNodejsUIMessages.AbstractNodejsCliFileLaunchConfigurationTab_Error_reading_configuration, (Throwable)ce));
        }
        this.cliFileField.setText(cliFile);
    }

    private void updateDebugger(ILaunchConfiguration configuration) {
        try {
            String debuggerId = configuration.getAttribute(this.getDebuggerLaunchAttrId(), "");
            int i = 0;
            while (i < this.debuggers.length) {
                if (this.debuggers[i][1].equals(debuggerId)) {
                    this.debuggerField.setText(this.debuggers[i][0]);
                    break;
                }
                ++i;
            }
        }
        catch (CoreException ce) {
            TernNodejsUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "tern.eclipse.ide.server.nodejs.ui", TernNodejsUIMessages.AbstractNodejsCliFileLaunchConfigurationTab_Error_reading_configuration, (Throwable)ce));
        }
    }

    private void updateNodeInstallPath(ILaunchConfiguration configuration) {
        try {
            String nodeInstall = configuration.getAttribute(this.getNodeInstallLaunchAttrId(), "");
            int i = 0;
            while (i < this.nodeInstalls.length) {
                if (this.nodeInstalls[i][1].equals(nodeInstall)) {
                    this.nodeInstallField.setText(this.nodeInstalls[i][0]);
                    break;
                }
                ++i;
            }
            String nodePath = configuration.getAttribute(this.getNodePathLaunchAttrId(), "");
            this.nodePathField.setText(nodePath);
            INodejsInstallManager installManager = TernNodejsCorePlugin.getNodejsInstallManager();
            INodejsInstall nodejsInstall = installManager.findNodejsInstall(nodeInstall);
            this.nodePathField.setEnabled(nodejsInstall != null && nodejsInstall.isNative());
        }
        catch (CoreException ce) {
            TernNodejsUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "tern.eclipse.ide.server.nodejs.ui", TernNodejsUIMessages.AbstractNodejsCliFileLaunchConfigurationTab_Error_reading_configuration, (Throwable)ce));
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String nodePath;
        int nodeInstallSelectionIndex;
        String cliFile = this.cliFileField.getText().trim();
        if (cliFile.length() == 0) {
            configuration.setAttribute(this.getCliFileLaunchAttrId(), null);
        } else {
            configuration.setAttribute(this.getCliFileLaunchAttrId(), cliFile);
        }
        int debuggerSelectionIndex = this.debuggerField.getSelectionIndex();
        if (debuggerSelectionIndex >= 0) {
            configuration.setAttribute(this.getDebuggerLaunchAttrId(), this.debuggers[debuggerSelectionIndex][1]);
        }
        if ((nodeInstallSelectionIndex = this.nodeInstallField.getSelectionIndex()) >= 0) {
            configuration.setAttribute(this.getNodeInstallLaunchAttrId(), this.nodeInstalls[nodeInstallSelectionIndex][1]);
        }
        if ((nodePath = this.nodePathField.getText()).length() == 0) {
            configuration.setAttribute(this.getNodePathLaunchAttrId(), null);
        } else {
            configuration.setAttribute(this.getNodePathLaunchAttrId(), nodePath);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        IFile cliFile = this.getDefaultCliFile();
        if (cliFile == null) {
            configuration.setAttribute(this.getCliFileLaunchAttrId(), null);
        } else {
            configuration.setAttribute(this.getCliFileLaunchAttrId(), NodejsCliFileHelper.getWorkspaceLoc((IResource)cliFile));
        }
        String debugger = this.getDefaultDebugger();
        if (StringUtils.isEmpty((String)debugger)) {
            configuration.setAttribute(this.getDebuggerLaunchAttrId(), null);
        } else {
            configuration.setAttribute(this.getDebuggerLaunchAttrId(), debugger);
        }
        String nodeInstall = this.getDefaultNodeInstall();
        if (StringUtils.isEmpty((String)nodeInstall)) {
            configuration.setAttribute(this.getNodeInstallLaunchAttrId(), null);
        } else {
            configuration.setAttribute(this.getNodeInstallLaunchAttrId(), nodeInstall);
        }
        String nodePath = this.getDefaultNodePath();
        if (StringUtils.isEmpty((String)nodePath)) {
            configuration.setAttribute(this.getNodePathLaunchAttrId(), null);
        } else {
            configuration.setAttribute(this.getNodePathLaunchAttrId(), nodePath);
        }
    }

    protected void handleWorkspaceLocationButtonSelected() {
        ResourceSelectionDialog dialog = new ResourceSelectionDialog(this.getShell(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot(), TernNodejsUIMessages.AbstractNodejsCliFileLaunchConfigurationTab_Select_a_client_file);
        dialog.open();
        Object[] results = dialog.getResult();
        if (results == null || results.length < 1) {
            return;
        }
        IResource resource = (IResource)results[0];
        this.cliFileField.setText(NodejsCliFileHelper.getWorkspaceLoc((IResource)resource));
    }

    protected void handleNodePathButtonSelected() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 0);
        fileDialog.setFileName(this.nodePathField.getText());
        String text = fileDialog.open();
        if (text != null) {
            this.nodePathField.setText(text);
        }
    }

    public void addControlAccessibleListener(Control control, String controlName) {
        String[] strs = controlName.split("&");
        StringBuffer stripped = new StringBuffer();
        int i = 0;
        while (i < strs.length) {
            stripped.append(strs[i]);
            ++i;
        }
        control.getAccessible().addAccessibleListener((AccessibleListener)new ControlAccessibleListener(stripped.toString()));
    }

    private String getCliFileLaunchAttrId() {
        return "cli_file";
    }

    private String getDebuggerLaunchAttrId() {
        return "debugger";
    }

    private String getNodeInstallLaunchAttrId() {
        return "nodeinstall";
    }

    private String getNodePathLaunchAttrId() {
        return "nodepath";
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        return this.validateCliFile() && this.validateDebugger() && this.validateNodeInstallPath();
    }

    private boolean validateCliFile() {
        String cliFile = this.cliFileField.getText().trim();
        if (StringUtils.isEmpty((String)cliFile)) {
            return true;
        }
        String expandedLocation = null;
        try {
            expandedLocation = this.resolveValue(cliFile);
            if (expandedLocation == null) {
                return true;
            }
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getStatus().getMessage());
            return false;
        }
        File file = new File(expandedLocation);
        if (!file.exists()) {
            this.setErrorMessage(TernNodejsUIMessages.AbstractNodejsCliFileLaunchConfigurationTab_client_file_does_not_exist);
            return false;
        }
        if (!file.isFile()) {
            this.setErrorMessage(TernNodejsUIMessages.ExternalToolsMainTab_client_file_specified_is_not_a_file);
            return false;
        }
        return true;
    }

    private String resolveValue(String expression) throws CoreException {
        String expanded = null;
        try {
            expanded = this.getValue(expression);
        }
        catch (CoreException localCoreException) {
            this.validateVariables(expression);
            throw localCoreException;
        }
        return expanded;
    }

    private String getValue(String expression) throws CoreException {
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        return manager.performStringSubstitution(expression);
    }

    private void validateVariables(String expression) throws CoreException {
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        manager.validateStringVariables(expression);
    }

    private boolean validateDebugger() {
        int debuggerSelectionIndex = this.debuggerField.getSelectionIndex();
        if (debuggerSelectionIndex <= 0) {
            this.setErrorMessage(TernNodejsUIMessages.AbstractNodejsCliFileLaunchConfigurationTab_debugger_required);
            return false;
        }
        String debuggerId = this.debuggers[debuggerSelectionIndex][1];
        if (StringUtils.isEmpty((String)debuggerId)) {
            this.setErrorMessage(TernNodejsUIMessages.AbstractNodejsCliFileLaunchConfigurationTab_debugger_not_installed);
            return false;
        }
        return true;
    }

    private boolean validateNodeInstallPath() {
        String nodeInstallId;
        int nodeInstallSelectionIndex = this.nodeInstallField.getSelectionIndex();
        if (nodeInstallSelectionIndex <= 0) {
            this.setErrorMessage(TernNodejsUIMessages.AbstractNodejsCliFileLaunchConfigurationTab_nodeInstall_required);
            return false;
        }
        INodejsInstallManager installManager = TernNodejsCorePlugin.getNodejsInstallManager();
        INodejsInstall nodejsInstall = installManager.findNodejsInstall(nodeInstallId = this.nodeInstalls[nodeInstallSelectionIndex][1]);
        if (nodejsInstall == null) {
            this.setErrorMessage(NLS.bind((String)TernNodejsUIMessages.AbstractNodejsCliFileLaunchConfigurationTab_nodeInstall_not_found, (Object)nodeInstallId));
            return false;
        }
        if (nodejsInstall.isNative()) {
            String nodePath = this.nodePathField.getText();
            if (StringUtils.isEmpty((String)nodePath)) {
                this.setErrorMessage(TernNodejsUIMessages.AbstractNodejsCliFileLaunchConfigurationTab_nodePath_required);
                return false;
            }
            if (!new File(nodePath).exists() && !nodePath.equals("node")) {
                this.setErrorMessage(NLS.bind((String)TernNodejsUIMessages.AbstractNodejsCliFileLaunchConfigurationTab_nodePath_not_found, (Object)nodePath));
                return false;
            }
        }
        return true;
    }

    protected abstract String getCliFileLabel();

    protected abstract IFile getDefaultCliFile();

    protected abstract String getDefaultDebugger();

    protected abstract String getDefaultNodeInstall();

    protected abstract String getDefaultNodePath();

    private class ControlAccessibleListener
    extends AccessibleAdapter {
        private String controlName;

        ControlAccessibleListener(String name) {
            this.controlName = name;
        }

        public void getName(AccessibleEvent e) {
            e.result = this.controlName;
        }
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        protected WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            this.updateLaunchConfiguration();
        }

        protected void updateLaunchConfiguration() {
            if (!AbstractNodejsCliFileLaunchConfigurationTab.this.fInitializing) {
                AbstractNodejsCliFileLaunchConfigurationTab.this.setDirty(true);
                AbstractNodejsCliFileLaunchConfigurationTab.this.userEdited = true;
                AbstractNodejsCliFileLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        }

        public void widgetSelected(SelectionEvent e) {
            AbstractNodejsCliFileLaunchConfigurationTab.this.setDirty(true);
            Object source = e.getSource();
            if (source == AbstractNodejsCliFileLaunchConfigurationTab.this.workspaceLocationButton) {
                AbstractNodejsCliFileLaunchConfigurationTab.this.handleWorkspaceLocationButtonSelected();
            } else if (source == AbstractNodejsCliFileLaunchConfigurationTab.this.debuggerField || source == AbstractNodejsCliFileLaunchConfigurationTab.this.nodeInstallField || source == AbstractNodejsCliFileLaunchConfigurationTab.this.nodePathField) {
                this.updateLaunchConfiguration();
            } else if (source == AbstractNodejsCliFileLaunchConfigurationTab.this.nodePathButton) {
                AbstractNodejsCliFileLaunchConfigurationTab.this.handleNodePathButtonSelected();
            }
        }
    }
}

