/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.ui.views;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import tern.ITernFile;
import tern.TernResourcesManager;
import tern.eclipse.ide.core.IIDETernProject;
import tern.eclipse.ide.core.TernCorePlugin;
import tern.eclipse.ide.core.resources.TernDocumentFile;
import tern.eclipse.ide.internal.ui.Trace;
import tern.eclipse.ide.internal.ui.views.TernContentOutlinePage;
import tern.eclipse.ide.internal.ui.views.TernOutline;
import tern.eclipse.ide.ui.views.AbstractTernOutlineView;
import tern.server.ITernPlugin;
import tern.server.TernPlugin;
import tern.server.protocol.ITernResultsCollector;
import tern.server.protocol.TernQuery;
import tern.server.protocol.outline.TernOutlineCollector;
import tern.server.protocol.outline.TernOutlineQuery;

public class TernOutlineView
extends AbstractTernOutlineView {
    @Override
    protected boolean isAdaptFor(IFile file) {
        return TernResourcesManager.isJSFile((Object)file) && TernCorePlugin.hasTernNature((IProject)file.getProject());
    }

    @Override
    protected IContentOutlinePage createOutlinePage(IProject project) {
        return new TernContentOutlinePage(project, this);
    }

    @Override
    public TernOutlineCollector loadOutline(IFile file, IDocument document) throws Exception {
        IIDETernProject ternProject = TernCorePlugin.getTernProject((IProject)file.getProject());
        if (ternProject == null || !ternProject.hasPlugin((ITernPlugin)TernPlugin.outline)) {
            return null;
        }
        TernDocumentFile ternFile = new TernDocumentFile(file, document);
        TernOutlineQuery query = new TernOutlineQuery(ternFile.getFileName());
        TernOutline outline = new TernOutline(ternFile, ternProject);
        ternProject.request((TernQuery)query, (ITernFile)ternFile, (ITernResultsCollector)outline);
        return outline;
    }

    @Override
    public boolean isOutlineAvailable(IFile file) {
        try {
            IIDETernProject ternProject = TernCorePlugin.getTernProject((IProject)file.getProject());
            return ternProject != null && ternProject.hasPlugin((ITernPlugin)TernPlugin.outline);
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Error while getting tern project", e);
            return false;
        }
    }
}

