/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.ui.preferences;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.StringButtonFieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Composite;
import tern.eclipse.ide.ui.dialogs.WorkspaceResourceSelectionDialog;
import tern.utils.StringUtils;

public class WorkspaceFileFieldEditor
extends StringButtonFieldEditor {
    private String[] extensions = null;
    private File filterPath = null;
    private boolean enforceAbsolute = false;

    protected WorkspaceFileFieldEditor() {
    }

    public WorkspaceFileFieldEditor(String name, String labelText, Composite parent) {
        this(name, labelText, false, parent);
    }

    public WorkspaceFileFieldEditor(String name, String labelText, boolean enforceAbsolute, Composite parent) {
        this(name, labelText, enforceAbsolute, 1, parent);
    }

    public WorkspaceFileFieldEditor(String name, String labelText, boolean enforceAbsolute, int validationStrategy, Composite parent) {
        this.init(name, labelText);
        this.enforceAbsolute = enforceAbsolute;
        this.setErrorMessage(JFaceResources.getString((String)"FileFieldEditor.errorMessage"));
        this.setChangeButtonText(JFaceResources.getString((String)"openBrowse"));
        this.setValidateStrategy(validationStrategy);
        this.createControl(parent);
    }

    protected String changePressed() {
        IResource d;
        String path = this.getTextControl().getText();
        path = path != null ? path.trim() : "";
        IFile f = this.getFile(path);
        if (f != null && !f.exists()) {
            f = null;
        }
        if ((d = this.getFile((IResource)f)) == null) {
            return null;
        }
        return d.getFullPath().toString();
    }

    protected boolean checkState() {
        String msg = null;
        String path = this.getTextControl().getText();
        path = path != null ? path.trim() : "";
        if (path.length() == 0) {
            if (!this.isEmptyStringAllowed()) {
                msg = this.getErrorMessage();
            }
        } else {
            IFile f = this.getFile(path);
            if (f == null || !f.exists()) {
                msg = this.getErrorMessage();
            }
        }
        if (msg != null) {
            this.showErrorMessage(msg);
            return false;
        }
        if (this.doCheckState()) {
            this.clearErrorMessage();
            return true;
        }
        msg = this.getErrorMessage();
        if (msg != null) {
            this.showErrorMessage(msg);
        }
        return false;
    }

    protected IFile getFile(String path) {
        if (StringUtils.isEmpty((String)path)) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
    }

    private IResource getFile(IResource startingDirectory) {
        WorkspaceResourceSelectionDialog dialog = new WorkspaceResourceSelectionDialog(this.getShell(), WorkspaceResourceSelectionDialog.Mode.FILE);
        if (startingDirectory != null) {
            ArrayList<IResource> selectedElements = new ArrayList<IResource>();
            selectedElements.add(startingDirectory);
            dialog.setInitialElementSelections(selectedElements);
        }
        if (dialog.open() == 0) {
            IResource resource = (IResource)dialog.getFirstResult();
            return resource;
        }
        return null;
    }

    public void setFileExtensions(String[] extensions) {
        this.extensions = extensions;
    }

    public void setFilterPath(File path) {
        this.filterPath = path;
    }
}

