/*
 * Decompiled with CFR 0.152.
 */
package org.dadacoalition.yedit.editor.scanner;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dadacoalition.yedit.Activator;
import org.dadacoalition.yedit.YEditLog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class ScalarRule
implements IRule {
    private IToken token;
    private String firstCharRegex = "\\w + - / \\. \\ \\( \\) \\? \\@ \\$ < = > \\|";
    private String otherCharRegex = "\\[ \\] ' \\w \\s + - / \\. \\\\ \\( \\) \\? \\@ \\$ < = > \\| \\{ \\}";
    private String endCharRegex = "\\w + - / \\. \\\\ \\( \\) \\? \\@ \\$ < = > \\| '";

    public ScalarRule(IToken token) {
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        if (prefs.getBoolean("symfonyCompatibilityMode")) {
            this.firstCharRegex = String.valueOf(this.firstCharRegex) + " %";
            this.otherCharRegex = String.valueOf(this.otherCharRegex) + " %";
            this.endCharRegex = String.valueOf(this.endCharRegex) + " %";
        }
        this.token = token;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        YEditLog.logger.info("Evaluating ScalarRule");
        int c = scanner.read();
        String firstChar = "" + (char)c;
        if (!Pattern.matches("[" + this.firstCharRegex + "]", firstChar)) {
            scanner.unread();
            return Token.UNDEFINED;
        }
        Pattern p = Pattern.compile("[" + this.otherCharRegex + "&&[^,]]", 4);
        String previousChar = "";
        String totalString = "";
        while (c != -1) {
            String character = "" + (char)c;
            Matcher m = p.matcher(character);
            if ('\n' == (char)c || '\r' == (char)c || !m.matches()) {
                if (!Pattern.matches("[" + this.endCharRegex + "]", previousChar)) {
                    YEditLog.logger.info("Character '" + previousChar + "' is not valid end char");
                    scanner.unread();
                }
                scanner.unread();
                break;
            }
            totalString = String.valueOf(totalString) + character;
            previousChar = character;
            c = scanner.read();
        }
        YEditLog.logger.info("Matched string " + totalString);
        return this.token;
    }
}

