/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.task;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import com.gradleware.tooling.toolingmodel.repository.FetchStrategy;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniEclipseProject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.configuration.GradleProjectNature;
import org.eclipse.buildship.core.util.progress.ToolingApiJob;
import org.eclipse.buildship.core.workspace.GradleBuild;
import org.eclipse.buildship.core.workspace.ModelProvider;
import org.eclipse.buildship.ui.view.task.TaskView;
import org.eclipse.buildship.ui.view.task.TaskViewContent;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.PlatformUI;
import org.gradle.tooling.model.eclipse.EclipseProject;

final class ReloadTaskViewJob
extends ToolingApiJob {
    private final TaskView taskView;
    private final FetchStrategy modelFetchStrategy;

    public ReloadTaskViewJob(TaskView taskView, FetchStrategy modelFetchStrategy) {
        super("Loading tasks of all Gradle projects");
        this.taskView = (TaskView)Preconditions.checkNotNull((Object)taskView);
        this.modelFetchStrategy = (FetchStrategy)Preconditions.checkNotNull((Object)modelFetchStrategy);
    }

    protected void runToolingApiJob(IProgressMonitor monitor) throws Exception {
        TaskViewContent content = this.loadContent(monitor);
        this.refreshTaskView(content);
    }

    private TaskViewContent loadContent(IProgressMonitor monitor) {
        ArrayList projects = Lists.newArrayList();
        Map<String, IProject> faultyProjects = this.allGradleWorkspaceProjects();
        for (GradleBuild gradleBuild : CorePlugin.gradleWorkspaceManager().getGradleBuilds()) {
            try {
                Set<OmniEclipseProject> eclipseProjects = this.fetchEclipseGradleProjects(gradleBuild.getModelProvider(), monitor);
                for (OmniEclipseProject eclipseProject : eclipseProjects) {
                    faultyProjects.remove(eclipseProject.getName());
                }
                projects.addAll(eclipseProjects);
            }
            catch (RuntimeException e) {
                CorePlugin.logger().warn("Tasks can't be loaded for project located at " + gradleBuild.getBuildConfig().getRootProjectDirectory().getAbsolutePath(), (Throwable)e);
            }
        }
        return new TaskViewContent(projects, Lists.newArrayList(faultyProjects.values()));
    }

    private Map<String, IProject> allGradleWorkspaceProjects() {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (IProject project : CorePlugin.workspaceOperations().getAllProjects()) {
            if (!GradleProjectNature.isPresentOn((IProject)project)) continue;
            result.put(project.getName(), project);
        }
        return result;
    }

    private Set<OmniEclipseProject> fetchEclipseGradleProjects(ModelProvider modelProvider, IProgressMonitor monitor) {
        Collection models = modelProvider.fetchModels(EclipseProject.class, this.modelFetchStrategy, this.getToken(), monitor);
        LinkedHashSet projects = Sets.newLinkedHashSet();
        for (EclipseProject model : models) {
            projects.addAll(DefaultOmniEclipseProject.from((EclipseProject)model).getAll());
        }
        return projects;
    }

    private void refreshTaskView(final TaskViewContent content) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ReloadTaskViewJob.this.taskView.setContent(content);
            }
        });
    }

    public boolean shouldSchedule() {
        Job[] jobs;
        for (Job job : jobs = Job.getJobManager().find((Object)"org.eclipse.buildship.core.jobs")) {
            if (!(job instanceof ReloadTaskViewJob)) continue;
            return false;
        }
        return true;
    }
}

