/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.ui.internal.validation;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.Namespace;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IDOMContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.designtime.internal.view.model.ITagRegistry;
import org.eclipse.jst.jsf.facelet.core.internal.util.ViewUtil;
import org.eclipse.jst.jsf.facelet.ui.internal.validation.AbstractFaceletValidationStrategy;
import org.eclipse.jst.jsf.validation.internal.IJSFViewValidator;
import org.eclipse.jst.jsf.validation.internal.JSFValidatorFactory;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class DefaultFaceletValidationStrategy
extends AbstractFaceletValidationStrategy {
    protected void doValidate(IFile file, IJSFViewValidator.IValidationReporter jsfReporter) {
        IJSFViewValidator validator = JSFValidatorFactory.createDefaultXMLValidator();
        validator.validateView(file, jsfReporter);
        this.validateFaceletHtml(file, jsfReporter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateFaceletHtml(IFile file, IJSFViewValidator.IValidationReporter reporter) {
        IStructuredModel model = null;
        try {
            try {
                model = StructuredModelManager.getModelManager().getModelForRead(file);
                IStructuredDocument structuredDoc = model.getStructuredDocument();
                this.validateDocument(structuredDoc, reporter, file.getProject());
                return;
            }
            catch (CoreException e) {
                JSFCorePlugin.log((String)"Error validating JSF", (Throwable)e);
                if (model == null) return;
                model.releaseFromRead();
                return;
            }
            catch (IOException e) {
                JSFCorePlugin.log((String)"Error validating JSF", (Throwable)e);
                if (model == null) return;
                model.releaseFromRead();
                return;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    protected void validateDocument(IStructuredDocument structuredDoc, IJSFViewValidator.IValidationReporter reporter, IProject project) {
        this.validateRoot(structuredDoc, reporter, project);
    }

    protected void validateRoot(IStructuredDocument structuredDoc, IJSFViewValidator.IValidationReporter reporter, IProject project) {
        IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)structuredDoc, -1);
        IDOMContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getDOMContextResolver(context);
        Document document = resolver.getDOMDocument();
        Element rootElement = document.getDocumentElement();
        if ("html".equals(rootElement.getNodeName())) {
            Collection namespaces;
            Set declaredNamespaces = ViewUtil.getDeclaredNamespaces((NamedNodeMap)rootElement.getAttributes());
            ITagRegistry tagRegistry = ViewUtil.getHtmlTagRegistry((IProject)project);
            if (tagRegistry != null) {
                namespaces = tagRegistry.getAllTagLibraries();
            } else {
                namespaces = Collections.EMPTY_SET;
                JSFCorePlugin.log((int)4, (String)"Program Error: HTML tag registry not found");
            }
            for (Attr attr : declaredNamespaces) {
                if (attr.getPrefix() == null || !(attr instanceof IDOMAttr)) continue;
                String declaredUri = attr.getValue();
                String findUri = null;
                for (Namespace ns : namespaces) {
                    if (!ns.getNSUri().equals(declaredUri)) continue;
                    findUri = ns.getNSUri();
                    break;
                }
                if (findUri != null) continue;
                Diagnostic diag = this._diagnosticFactory.create_CANNOT_FIND_FACELET_TAGLIB(declaredUri);
                IDOMAttr domAttr = (IDOMAttr)attr;
                reporter.report(diag, domAttr.getValueRegionStartOffset(), domAttr.getValue().length());
            }
        }
    }
}

