/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.taginfo;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.ui.internal.taginfo.JSPJavaJavadocHoverProcessor;
import org.eclipse.jst.jsp.ui.internal.taginfo.JavaWordFinder;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.utils.StringUtils;

public class XMLJavadocHoverProcessor
extends JSPJavaJavadocHoverProcessor {
    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        block17: {
            IJavaProject javaProject;
            String baseLocation;
            IStructuredModel model;
            String elementName;
            block18: {
                elementName = null;
                try {
                    elementName = textViewer.getDocument().get(hoverRegion.getOffset(), hoverRegion.getLength());
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
                model = null;
                model = StructuredModelManager.getModelManager().getExistingModelForRead(textViewer.getDocument());
                if (model == null) break block17;
                baseLocation = model.getBaseLocation();
                if (baseLocation.startsWith("jar:/file:")) {
                    baseLocation = StringUtils.replace((String)baseLocation, (String)"jar:/", (String)"jar:");
                }
                if (!baseLocation.startsWith("jar:file:") || baseLocation.indexOf(33) <= 9) break block18;
                String baseFile = baseLocation.substring(9, baseLocation.indexOf(33));
                Path basePath = new Path(baseFile);
                IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int i = 0;
                while (i < projects.length) {
                    try {
                        IType type;
                        IPackageFragmentRoot root;
                        IJavaProject javaProject2;
                        if (projects[i].isAccessible() && projects[i].hasNature("org.eclipse.jdt.core.javanature") && (javaProject2 = JavaCore.create((IProject)projects[i])).exists() && (root = javaProject2.findPackageFragmentRoot((IPath)basePath)) != null && (type = javaProject2.findType(elementName)) != null) {
                            String string = this.getHoverInfo(new IJavaElement[]{type});
                            return string;
                        }
                    }
                    catch (CoreException e) {
                        Logger.logException((Throwable)e);
                    }
                    ++i;
                }
                break block17;
            }
            Path basePath = new Path(baseLocation);
            if (basePath.segmentCount() > 1 && (javaProject = JavaCore.create((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(basePath.segment(0)))).exists()) {
                try {
                    IType type = javaProject.findType(elementName);
                    if (type != null) {
                        String string = this.getHoverInfo(new IJavaElement[]{type});
                        return string;
                    }
                    break block17;
                }
                catch (JavaModelException e) {
                    Logger.logException((Throwable)e);
                    break block17;
                }
            }
            break block17;
            finally {
                if (model != null) {
                    model.releaseFromRead();
                }
            }
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return JavaWordFinder.findWord(textViewer.getDocument(), offset, true);
    }
}

