/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import org.eclipse.sapphire.EnablementService;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.MasterVersionCompatibilityService;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyContentEvent;

public final class VersionCompatibilityEnablementService
extends EnablementService {
    private MasterVersionCompatibilityService versionCompatibilityService;
    private Listener versionCompatibilityServiceListener;
    private Listener propertyListener;

    @Override
    protected void initEnablementService() {
        Property property = this.context(Property.class);
        this.versionCompatibilityService = property.service(MasterVersionCompatibilityService.class);
        this.versionCompatibilityServiceListener = new Listener(){

            @Override
            public void handle(Event event) {
                VersionCompatibilityEnablementService.this.refresh();
            }
        };
        this.versionCompatibilityService.attach(this.versionCompatibilityServiceListener);
        this.propertyListener = new FilteredListener<PropertyContentEvent>(){

            @Override
            protected void handleTypedEvent(PropertyContentEvent event) {
                VersionCompatibilityEnablementService.this.refresh();
            }
        };
        if (property.definition() instanceof ImpliedElementProperty) {
            property.element().attach(this.propertyListener, String.valueOf(property.name()) + "/*");
        } else {
            property.element().attach(this.propertyListener, property.name());
        }
    }

    @Override
    protected Boolean compute() {
        if (!this.versionCompatibilityService.compatible() && this.context(Property.class).empty()) {
            return false;
        }
        return true;
    }

    @Override
    public void dispose() {
        super.dispose();
        Property property = this.context(Property.class);
        this.versionCompatibilityService.detach(this.versionCompatibilityServiceListener);
        if (property.definition() instanceof ImpliedElementProperty) {
            property.element().detach(this.propertyListener, String.valueOf(property.name()) + "/*");
        } else {
            property.element().detach(this.propertyListener, property.name());
        }
    }
}

