/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el;

import java.util.List;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.ImageService;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;

public final class ImageFunction
extends Function {
    public static ImageFunction create() {
        ImageFunction function = new ImageFunction();
        function.init(new Function[0]);
        return function;
    }

    @Override
    public String name() {
        return "Image";
    }

    @Override
    public FunctionResult evaluate(final FunctionContext context) {
        return new FunctionResult(this, context){
            private ImageService imageService;
            private Listener imageServiceListener;

            @Override
            protected void init() {
                List<FunctionResult> operands = this.operands();
                Element element = operands.isEmpty() ? ((ModelElementFunctionContext)context).element() : this.cast(this.operand(0), Element.class);
                this.imageService = element.service(ImageService.class);
                if (this.imageService != null) {
                    this.imageServiceListener = new Listener(){

                        @Override
                        public void handle(Event event) {
                            this.refresh();
                        }
                    };
                    this.imageService.attach(this.imageServiceListener);
                }
            }

            @Override
            protected Object evaluate() {
                if (this.imageService == null) {
                    return null;
                }
                return this.imageService.image();
            }

            @Override
            public void dispose() {
                super.dispose();
                if (this.imageService != null) {
                    this.imageService.detach(this.imageServiceListener);
                    this.imageService = null;
                    this.imageServiceListener = null;
                }
            }
        };
    }
}

