/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.assist.internal;

import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.services.FactsAggregationService;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContext;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContribution;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContributor;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistSection;
import org.eclipse.sapphire.ui.forms.PropertyEditorPart;
import org.eclipse.sapphire.ui.forms.WithPart;

public final class FactsAssistContributor
extends PropertyEditorAssistContributor {
    public FactsAssistContributor() {
        this.setId("System.FactsContributor");
        this.setPriority(110);
    }

    @Override
    public void contribute(PropertyEditorAssistContext context) {
        SapphirePart part = context.getPart();
        Element element = part.getLocalModelElement();
        ElementHandle<?> property = null;
        if (part instanceof PropertyEditorPart) {
            property = ((PropertyEditorPart)part).property();
        } else if (part instanceof WithPart) {
            property = ((WithPart)part).property();
        }
        boolean contribute = false;
        if (property == null) {
            contribute = !element.validation().ok();
        } else if (!property.validation().ok()) {
            contribute = true;
        } else {
            boolean bl = contribute = !property.empty();
        }
        if (contribute) {
            FactsAggregationService service;
            SortedSet facts = property != null ? ((FactsAggregationService)property.service(FactsAggregationService.class)).facts() : ((service = (FactsAggregationService)element.service(FactsAggregationService.class)) != null ? service.facts() : new TreeSet());
            for (String fact : facts) {
                PropertyEditorAssistContribution.Factory contribution = PropertyEditorAssistContribution.factory();
                contribution.text("<p>" + FactsAssistContributor.escapeForXml(fact) + "</p>");
                PropertyEditorAssistSection section = context.getSection("info");
                section.addContribution(contribution.create());
            }
        }
    }
}

