/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms;

import java.util.List;
import java.util.Set;
import org.eclipse.sapphire.DisposeEvent;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.el.AndFunction;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.ListSelectionService;
import org.eclipse.sapphire.ui.PartVisibilityEvent;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.forms.ContainerPart;
import org.eclipse.sapphire.ui.forms.DetailSectionDef;
import org.eclipse.sapphire.ui.forms.PageBookPart;
import org.eclipse.sapphire.ui.forms.PropertyEditorPart;
import org.eclipse.sapphire.util.IdentityHashSet;
import org.eclipse.sapphire.util.MutableReference;
import org.eclipse.swt.widgets.Display;

public final class DetailSectionPart
extends PageBookPart {
    @Text(value="Page book's property reference path \"{0}\" is invalid.")
    private static LocalizableText invalidPath;
    private Element element;
    private ListProperty property;
    private PropertyEditorPart listPropertyEditorPart;

    static {
        LocalizableText.init(DetailSectionPart.class);
    }

    @Override
    protected void init() {
        super.init();
        String pathString = (String)((DetailSectionDef)this.definition).getProperty().content();
        String pathStringSubstituted = DetailSectionPart.substituteParams(pathString, this.params);
        ModelPath path = new ModelPath(pathStringSubstituted);
        this.element = this.getLocalModelElement();
        int i = 0;
        int n = path.length();
        while (i < n) {
            ModelPath.Segment segment = path.segment(i);
            if (segment instanceof ModelPath.ModelRootSegment) {
                this.element = this.element.root();
            } else if (segment instanceof ModelPath.ParentElementSegment) {
                this.element = this.element.parent().element();
            } else if (segment instanceof ModelPath.PropertySegment) {
                this.property = (ListProperty)this.resolve(this.element, ((ModelPath.PropertySegment)segment).getPropertyName());
                if (i + 1 != n) {
                    throw new RuntimeException(invalidPath.format(new Object[]{pathString}));
                }
            } else {
                throw new RuntimeException(invalidPath.format(new Object[]{pathString}));
            }
            ++i;
        }
        ISapphirePart ancestor = this.parent();
        SapphirePart highestUninitializedAncestor = null;
        while (ancestor instanceof SapphirePart && !((SapphirePart)ancestor).initialized()) {
            highestUninitializedAncestor = (SapphirePart)ancestor;
            ancestor = ancestor.parent();
        }
        if (highestUninitializedAncestor == null) {
            this.initListSelectionServiceListener();
        } else {
            highestUninitializedAncestor.attach((Listener)new FilteredListener<SapphirePart.PartInitializationEvent>(){

                protected void handleTypedEvent(SapphirePart.PartInitializationEvent event) {
                    event.part().detach((Listener)this);
                    DetailSectionPart.this.initListSelectionServiceListener();
                }
            });
        }
    }

    @Override
    protected Function initVisibleWhenFunction() {
        Function function = new Function(){

            public String name() {
                return "VisibleIfListEditorVisible";
            }

            public FunctionResult evaluate(FunctionContext context) {
                return new FunctionResult(this, context){
                    private Listener listPropertyEditorListener;

                    protected void init() {
                        this.listPropertyEditorListener = new FilteredListener<PartVisibilityEvent>(){

                            protected void handleTypedEvent(PartVisibilityEvent event) {
                                this.refresh();
                            }
                        };
                        DetailSectionPart.this.listPropertyEditorPart.attach(this.listPropertyEditorListener);
                    }

                    protected Object evaluate() {
                        return DetailSectionPart.this.listPropertyEditorPart.visible();
                    }

                    public void dispose() {
                        DetailSectionPart.this.listPropertyEditorPart.detach(this.listPropertyEditorListener);
                        this.listPropertyEditorListener = null;
                        super.dispose();
                    }
                };
            }
        };
        function.init(new Function[0]);
        Function base = super.initVisibleWhenFunction();
        if (base == null) {
            return function;
        }
        return AndFunction.create((Function[])new Function[]{base, function});
    }

    private void initListSelectionServiceListener() {
        this.listPropertyEditorPart = this.findPropertyEditor(this, this.element, (PropertyDef)this.property);
        if (this.listPropertyEditorPart == null) {
            String msg = "DetailsSectionPart did not find " + this.property;
            throw new RuntimeException(msg);
        }
        final ListSelectionService listSelectionService = this.listPropertyEditorPart.service(ListSelectionService.class);
        final MutableReference selectedElementRef = new MutableReference();
        final Listener listSelectionServiceListener = new Listener(){

            public void handle(Event event) {
                Element selectedElement;
                List<Element> selectedElements = listSelectionService.selection();
                Element element = selectedElement = selectedElements.isEmpty() ? null : selectedElements.get(0);
                if (selectedElementRef.get() != selectedElement) {
                    selectedElementRef.set((Object)selectedElement);
                    Runnable inputChangeOperation = new Runnable(){

                        @Override
                        public void run() {
                            DetailSectionPart.this.changePage(selectedElement);
                        }
                    };
                    Display.getDefault().syncExec(inputChangeOperation);
                }
            }
        };
        listSelectionService.attach(listSelectionServiceListener);
        this.attach(new Listener(){

            public void handle(Event event) {
                if (event instanceof DisposeEvent) {
                    listSelectionService.detach(listSelectionServiceListener);
                }
            }
        });
        this.changePage(null);
    }

    private PropertyEditorPart findPropertyEditor(ISapphirePart part, Element element, PropertyDef property) {
        return this.findPropertyEditor(part, element, property, (Set<ISapphirePart>)new IdentityHashSet());
    }

    private PropertyEditorPart findPropertyEditor(ISapphirePart part, Element element, PropertyDef property, Set<ISapphirePart> searchedParts) {
        ISapphirePart parent;
        PropertyEditorPart propertyEditorPart;
        if (searchedParts.contains(part)) {
            return null;
        }
        if (part instanceof PropertyEditorPart && (propertyEditorPart = (PropertyEditorPart)part).getLocalModelElement() == element && propertyEditorPart.property().definition() == property) {
            return propertyEditorPart;
        }
        searchedParts.add(part);
        if (part instanceof ContainerPart) {
            ContainerPart container = (ContainerPart)part;
            for (SapphirePart child : container.children().all()) {
                PropertyEditorPart propertyEditorPart2 = this.findPropertyEditor(child, element, property, searchedParts);
                if (propertyEditorPart2 == null) continue;
                return propertyEditorPart2;
            }
        }
        if ((parent = part.parent()) != null) {
            return this.findPropertyEditor(parent, element, property, searchedParts);
        }
        return null;
    }
}

