/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.operation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.ActivityCancelledException;
import org.eclipse.team.svn.revision.graph.PathRevision;
import org.eclipse.team.svn.revision.graph.SVNRevisionGraphMessages;
import org.eclipse.team.svn.revision.graph.TopRightTraverseVisitor;
import org.eclipse.team.svn.revision.graph.cache.CacheChangedPath;
import org.eclipse.team.svn.revision.graph.cache.CacheRevision;
import org.eclipse.team.svn.revision.graph.cache.MergeInfoStorage;
import org.eclipse.team.svn.revision.graph.cache.RepositoryCache;
import org.eclipse.team.svn.revision.graph.operation.CreateRevisionGraphModelOperation;
import org.eclipse.team.svn.revision.graph.operation.RepositoryConnectionInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddMergeInfoOperation
extends AbstractActionOperation {
    protected static final boolean DEBUG = false;
    protected CreateRevisionGraphModelOperation createGraphOp;
    protected RepositoryConnectionInfo.IRepositoryConnectionInfoProvider repositoryConnectionInfoProvider;
    protected RepositoryCache repositoryCache;
    protected Set<Long> mergeTargetRevisions = new HashSet<Long>();
    protected Map<Long, Set<Long>> mergeSourceRevisions = new HashMap<Long, Set<Long>>();
    protected Map<Integer, CopyDataContainer> copyStructure = new HashMap<Integer, CopyDataContainer>();
    protected DetectedMerges mergedFromDetectedMerges;

    public AddMergeInfoOperation(CreateRevisionGraphModelOperation createGraphOp, RepositoryConnectionInfo.IRepositoryConnectionInfoProvider repositoryConnectionInfoProvider) {
        super("Operation_AddMergeInfo", SVNRevisionGraphMessages.class);
        this.createGraphOp = createGraphOp;
        this.repositoryConnectionInfoProvider = repositoryConnectionInfoProvider;
    }

    protected void runImpl(final IProgressMonitor monitor) throws Exception {
        if (!this.repositoryConnectionInfoProvider.getRepositoryConnectionInfo().isSupportMergeInfo) {
            return;
        }
        PathRevision model = this.createGraphOp.getModel();
        if (model == null) {
            return;
        }
        this.repositoryCache = this.createGraphOp.getRepositoryCache();
        this.mergedFromDetectedMerges = new DetectedMerges(this.repositoryCache);
        this.preprocess();
        PathRevision startNode = (PathRevision)model.getStartNodeInGraph();
        new TopRightTraverseVisitor<PathRevision>(){

            @Override
            protected void visit(PathRevision node) {
                if (monitor.isCanceled()) {
                    throw new ActivityCancelledException();
                }
                if (node.action != PathRevision.RevisionNodeAction.NONE && AddMergeInfoOperation.this.mergeTargetRevisions.contains(node.getRevision())) {
                    AddMergeInfoOperation.this.processIncomingMerges(node);
                }
            }
        }.traverse(startNode);
        new TopRightTraverseVisitor<PathRevision>(){

            @Override
            protected void visit(PathRevision node) {
                if (monitor.isCanceled()) {
                    throw new ActivityCancelledException();
                }
                if (node.action != PathRevision.RevisionNodeAction.NONE && AddMergeInfoOperation.this.mergeSourceRevisions.containsKey(node.getRevision())) {
                    AddMergeInfoOperation.this.processOutgoingMerges(node);
                }
            }
        }.traverse(startNode);
    }

    protected void processOutgoingMerges(PathRevision node) {
        List<CacheRevision> mergeTargetRevisions;
        if (this.hasMergeSource(node) && !(mergeTargetRevisions = this.getMergeTargetRevisions(node.getRevision())).isEmpty()) {
            MergeDataContainer detectedMerges = new MergeDataContainer();
            CopyFromHistoryContainer sourceHistory = new CopyFromHistoryContainer(node.getPathIndex(), node.getRevision());
            for (CacheRevision mergeTargetRevision : mergeTargetRevisions) {
                this.processRevision(mergeTargetRevision, detectedMerges, sourceHistory, false);
            }
            this.applyOutgoingMergeResults(node, detectedMerges);
        }
    }

    protected void processIncomingMerges(PathRevision node) {
        List<CacheRevision> mergeSourceRevisions;
        if (this.hasMergeTarget(node) && !(mergeSourceRevisions = this.getMergeSourceRevisions(node.getRevision())).isEmpty()) {
            MergeDataContainer detectedMerges = new MergeDataContainer();
            CopyFromHistoryContainer targetHistory = new CopyFromHistoryContainer(node.getPathIndex(), node.getRevision());
            for (CacheRevision mergeSourceRevision : mergeSourceRevisions) {
                this.processRevision(mergeSourceRevision, detectedMerges, targetHistory, true);
            }
            this.applyIncomingMergeResults(node, detectedMerges);
        }
    }

    protected void processRevision(CacheRevision mergeSourceRevision, MergeDataContainer detectedMerges, CopyFromHistoryContainer targetHistory, boolean isIncomingMerge) {
        CacheChangedPath[] changedPaths;
        long sourceRevision = mergeSourceRevision.getRevision();
        CacheChangedPath[] cacheChangedPathArray = changedPaths = mergeSourceRevision.getChangedPaths();
        int n = changedPaths.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                MergeData legacyMerge;
                CacheChangedPath changedPath = cacheChangedPathArray[n2];
                for (MergeData mergeData : detectedMerges.mergeDataCol) {
                    if (!this.isParentPath(mergeData.mergeSourcePath, changedPath.getPathIndex())) continue;
                    if (!mergeData.mergeSourceRevisions.contains(sourceRevision)) {
                        mergeData.mergeSourceRevisions.add(sourceRevision);
                    }
                    break block6;
                }
                if (!isIncomingMerge && (legacyMerge = this.mergedFromDetectedMerges.findMergeForTarget(targetHistory.getBasePath(), new PathWithRevision(changedPath.getPathIndex(), sourceRevision))) != null) {
                    MergeData md = new MergeData(legacyMerge.mergeTargetPath, legacyMerge.mergeTargetRevision, legacyMerge.mergeSourcePath, sourceRevision);
                    detectedMerges.addMergeData(md);
                } else {
                    CopyFromHistoryContainer sourceHistory = new CopyFromHistoryContainer(changedPath.getPathIndex(), sourceRevision);
                    MergeData mergeData = this.findMerge(sourceHistory, targetHistory);
                    if (mergeData != null) {
                        detectedMerges.addMergeData(mergeData);
                    }
                }
            }
            ++n2;
        }
    }

    protected void applyIncomingMergeResults(PathRevision node, MergeDataContainer detectedMerges) {
        int nodePath = node.getPathIndex();
        for (MergeData mergeData : detectedMerges.mergeDataCol) {
            int targetPath = mergeData.mergeTargetPath;
            int path = mergeData.mergeSourcePath;
            if (targetPath != nodePath) {
                int[] relativeParts = this.repositoryCache.getPathStorage().makeRelative(targetPath, nodePath);
                path = this.repositoryCache.getPathStorage().add(path, relativeParts);
            }
            node.addIncomingMerges(path, mergeData.mergeSourceRevisions);
        }
        this.mergedFromDetectedMerges.add(node.getRevision(), detectedMerges);
    }

    protected void applyOutgoingMergeResults(PathRevision node, MergeDataContainer detectedMerges) {
        int nodePath = node.getPathIndex();
        for (MergeData mergeData : detectedMerges.mergeDataCol) {
            int sourcePath = mergeData.mergeTargetPath;
            int targetPath = mergeData.mergeSourcePath;
            Set<Long> targetRevisions = mergeData.mergeSourceRevisions;
            if (targetPath != nodePath) {
                int[] relativeParts = this.repositoryCache.getPathStorage().makeRelative(sourcePath, nodePath);
                targetPath = this.repositoryCache.getPathStorage().add(targetPath, relativeParts);
            }
            for (long rev : targetRevisions) {
                node.addOutgoingMerge(targetPath, rev);
            }
        }
    }

    protected MergeData findMerge(CopyFromHistoryContainer sourceHistory, CopyFromHistoryContainer targetHistory) {
        int level = 1;
        while (true) {
            MergeData mergeData;
            int n;
            int i;
            boolean hasSource = sourceHistory.increaseHistory();
            boolean hasTarget = false;
            hasTarget = targetHistory.getHistoryLevel() >= level ? true : targetHistory.increaseHistory();
            if (!hasSource && !hasTarget) break;
            if (hasSource) {
                List<PathHistory> sourcePaths = sourceHistory.getHistoryPaths(level);
                i = 0;
                n = Math.min(level, targetHistory.getHistoryLevel());
                while (i <= n) {
                    List<PathHistory> targetPaths = targetHistory.getHistoryPaths(i);
                    mergeData = this.findMerge(sourcePaths, level, targetPaths, i);
                    if (mergeData != null) {
                        return mergeData;
                    }
                    ++i;
                }
            }
            if (hasTarget) {
                List<PathHistory> targetPaths = targetHistory.getHistoryPaths(level);
                i = 0;
                n = Math.min(level - 1, sourceHistory.getHistoryLevel());
                while (i <= n) {
                    List<PathHistory> sourcePaths = sourceHistory.getHistoryPaths(i);
                    mergeData = this.findMerge(sourcePaths, i, targetPaths, level);
                    if (mergeData != null) {
                        return mergeData;
                    }
                    ++i;
                }
            }
            ++level;
        }
        return null;
    }

    protected MergeData findMerge(List<PathHistory> sourceHistory, int sourceHistoryLevel, List<PathHistory> targetHistory, int targetHistoryLevel) {
        if (sourceHistory.isEmpty() || targetHistory.isEmpty()) {
            return null;
        }
        for (PathHistory sourcePathHistory : sourceHistory) {
            PathWithRevision sourcePath = sourcePathHistory.get(sourceHistoryLevel);
            for (PathHistory targetPathHistory : targetHistory) {
                PathWithRevision targetPath = targetPathHistory.get(targetHistoryLevel);
                if (sourcePath.path != targetPath.path) continue;
                PathWithRevision sPath = sourcePathHistory.getFirst();
                PathWithRevision tPath = targetPathHistory.getFirst();
                if (sPath.path == tPath.path) continue;
                MergeData res = new MergeData(sPath.path, sPath.revision, tPath.path, tPath.revision);
                return res;
            }
        }
        return null;
    }

    protected boolean hasMergeTarget(PathRevision node) {
        int nodePath = node.getPathIndex();
        CacheChangedPath[] cacheChangedPathArray = node.getChangedPaths();
        int n = cacheChangedPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            CacheChangedPath cacheChangedPath = cacheChangedPathArray[n2];
            if (this.isParentPath(cacheChangedPath.getPathIndex(), nodePath)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean hasMergeSource(PathRevision node) {
        int nodePath = node.getPathIndex();
        CacheChangedPath[] cacheChangedPathArray = node.getChangedPaths();
        int n = cacheChangedPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            CacheChangedPath cacheChangedPath = cacheChangedPathArray[n2];
            if (this.isParentPath(nodePath, cacheChangedPath.getPathIndex())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected List<CacheRevision> getMergeSourceRevisions(long revision) {
        long[] revisions = this.repositoryCache.getMergeInfoStorage().getMergeSourceRevisions(revision);
        ArrayList<CacheRevision> result = new ArrayList<CacheRevision>();
        int i = 0;
        while (i < revisions.length) {
            CacheRevision cacheRevision = this.repositoryCache.getRevision(revisions[i]);
            if (cacheRevision != null) {
                result.add(cacheRevision);
            }
            ++i;
        }
        return result;
    }

    protected List<CacheRevision> getMergeTargetRevisions(long revision) {
        ArrayList<CacheRevision> result = new ArrayList<CacheRevision>();
        Set<Long> revisions = this.mergeSourceRevisions.get(revision);
        if (revisions != null && !revisions.isEmpty()) {
            Iterator<Long> iter = revisions.iterator();
            while (iter.hasNext()) {
                CacheRevision cacheRevision = this.repositoryCache.getRevision(iter.next());
                if (cacheRevision == null) continue;
                result.add(cacheRevision);
            }
        }
        return result;
    }

    protected void preprocess() {
        long[] targetRevisions;
        MergeInfoStorage mergeStorage = this.repositoryCache.getMergeInfoStorage();
        long[] lArray = targetRevisions = mergeStorage.getMergeTargetRevisions();
        int n = targetRevisions.length;
        int n2 = 0;
        while (n2 < n) {
            long[] sourceRevisions;
            long targetRevision = lArray[n2];
            this.mergeTargetRevisions.add(targetRevision);
            long[] lArray2 = sourceRevisions = mergeStorage.getMergeSourceRevisions(targetRevision);
            int n3 = sourceRevisions.length;
            int n4 = 0;
            while (n4 < n3) {
                long sourceRevision = lArray2[n4];
                Set<Long> revs = this.mergeSourceRevisions.get(sourceRevision);
                if (revs == null) {
                    revs = new HashSet<Long>();
                    this.mergeSourceRevisions.put(sourceRevision, revs);
                }
                revs.add(targetRevision);
                ++n4;
            }
            ++n2;
        }
        long i = 0L;
        long n5 = this.repositoryCache.getLastProcessedRevision();
        while (i < n5) {
            CacheRevision cacheRevision = this.repositoryCache.getRevision(i);
            if (cacheRevision != null) {
                CacheChangedPath[] changedPaths = cacheRevision.getChangedPaths();
                int j = 0;
                while (j < changedPaths.length) {
                    CacheChangedPath changedPath = changedPaths[j];
                    if (changedPath.getCopiedFromPathIndex() != -1) {
                        CopyDataContainer dataContainer = this.copyStructure.get(changedPath.getPathIndex());
                        if (dataContainer == null) {
                            dataContainer = new CopyDataContainer();
                            this.copyStructure.put(changedPath.getPathIndex(), dataContainer);
                        }
                        dataContainer.addCopiedFrom(cacheRevision.getRevision(), changedPath.getCopiedFromRevision(), changedPath.getCopiedFromPathIndex());
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    protected boolean isParentPath(int parentPathIndex, int childPathIndex) {
        return this.repositoryCache.getPathStorage().isParentIndex(parentPathIndex, childPathIndex);
    }

    protected String getPath(int pathIndex) {
        return this.repositoryCache.getPathStorage().getPath(pathIndex);
    }

    protected static String getIndent(int count) {
        StringBuilder str = new StringBuilder();
        int i = 0;
        while (i < count) {
            str.append("\t");
            ++i;
        }
        return str.toString();
    }

    protected String getPathAsString(PathWithRevision path) {
        return this.getPathAsString(path.path, path.revision);
    }

    protected String getPathAsString(int path, long revision) {
        return String.valueOf(this.getPath(path)) + "@" + revision;
    }

    protected static class CopyData {
        final long pathRevision;
        final long copyRevision;
        final int copyPath;

        public CopyData(long pathRevision, long copyRevision, int copyPath) {
            this.pathRevision = pathRevision;
            this.copyRevision = copyRevision;
            this.copyPath = copyPath;
        }
    }

    protected static class CopyDataContainer {
        List<CopyData> copiedFrom = new ArrayList<CopyData>();

        protected CopyDataContainer() {
        }

        public void addCopiedFrom(long pathRevision, long copyRevision, int copyPath) {
            this.copiedFrom.add(new CopyData(pathRevision, copyRevision, copyPath));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CopyFromHistoryContainer {
        protected final PathWithRevision basePath;
        protected List<PathHistory> pathsHistory = new ArrayList<PathHistory>();
        protected int historyLevel = -1;
        protected boolean isFilledAllHistory;

        public CopyFromHistoryContainer(int path, long revision) {
            this.basePath = new PathWithRevision(path, revision);
            this.addPathWithParents(path, revision);
        }

        private void addPathWithParents(int path, long revision) {
            List<Integer> parents = AddMergeInfoOperation.this.repositoryCache.getPathStorage().getPathParents(path);
            ListIterator<Integer> iter = parents.listIterator(parents.size());
            while (iter.hasPrevious()) {
                this.pathsHistory.add(new PathHistory(new PathWithRevision(iter.previous(), revision)));
            }
            this.historyLevel = 0;
        }

        public int getHistoryLevel() {
            return this.historyLevel;
        }

        public PathWithRevision getBasePath() {
            return this.basePath;
        }

        public boolean increaseHistory() {
            if (this.historyLevel == -1) {
                throw new IllegalStateException("Paths were not set");
            }
            boolean isIncreased = false;
            if (!this.isFilledAllHistory) {
                for (PathHistory pathHistory : this.pathsHistory) {
                    PathWithRevision path;
                    PathWithRevision copyFromPath;
                    if (pathHistory.size() - 1 != this.historyLevel || (copyFromPath = this.getCopyFromPath(path = pathHistory.get(this.historyLevel))) == null) continue;
                    pathHistory.add(copyFromPath);
                    isIncreased = true;
                }
                if (!isIncreased) {
                    this.isFilledAllHistory = true;
                } else {
                    ++this.historyLevel;
                }
            }
            return isIncreased;
        }

        protected PathWithRevision getCopyFromPath(PathWithRevision path) {
            CopyData copyFrom = null;
            CopyDataContainer copyDataContainer = AddMergeInfoOperation.this.copyStructure.get(path.path);
            if (copyDataContainer != null) {
                for (CopyData copyData : copyDataContainer.copiedFrom) {
                    if (copyData.pathRevision > path.revision) continue;
                    if (copyFrom != null) {
                        if (copyData.pathRevision <= copyFrom.pathRevision) continue;
                        copyFrom = copyData;
                        continue;
                    }
                    copyFrom = copyData;
                }
            }
            return copyFrom != null ? new PathWithRevision(copyFrom.copyPath, copyFrom.copyRevision) : null;
        }

        public List<PathHistory> getHistoryPaths(int level) {
            ArrayList<PathHistory> res = new ArrayList<PathHistory>();
            for (PathHistory pathHistory : this.pathsHistory) {
                if (!pathHistory.hasPath(level)) continue;
                res.add(pathHistory);
            }
            return res;
        }
    }

    protected static class DetectedMerges {
        protected RepositoryCache cache;
        protected Map<Long, List<MergeDataContainer>> merges = new HashMap<Long, List<MergeDataContainer>>();

        public DetectedMerges(RepositoryCache cache) {
            this.cache = cache;
        }

        public void add(long revision, MergeDataContainer mergeDataContainer) {
            List<MergeDataContainer> mergeList = this.merges.get(revision);
            if (mergeList == null) {
                mergeList = new ArrayList<MergeDataContainer>();
                this.merges.put(revision, mergeList);
            }
            mergeList.add(mergeDataContainer);
        }

        public MergeData findMergeForTarget(PathWithRevision source, PathWithRevision target) {
            List<MergeDataContainer> mergeList = this.merges.get(target.revision);
            if (mergeList != null) {
                for (MergeDataContainer mdContainer : mergeList) {
                    for (MergeData md : mdContainer.mergeDataCol) {
                        if (!md.mergeSourceRevisions.contains(source.revision) || !this.cache.getPathStorage().isParentIndex(md.mergeTargetPath, target.path) || !this.cache.getPathStorage().isParentIndex(md.mergeSourcePath, source.path)) continue;
                        return md;
                    }
                }
            }
            return null;
        }
    }

    protected static class MergeData {
        final int mergeSourcePath;
        Set<Long> mergeSourceRevisions = new HashSet<Long>();
        final int mergeTargetPath;
        final long mergeTargetRevision;

        public MergeData(int mergeSourcePath, long mergeSourceRevision, int mergeTargetPath, long mergeTargetRevision) {
            this.mergeSourcePath = mergeSourcePath;
            this.mergeTargetPath = mergeTargetPath;
            this.mergeSourceRevisions.add(mergeSourceRevision);
            this.mergeTargetRevision = mergeTargetRevision;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MergeDataContainer {
        List<MergeData> mergeDataCol = new ArrayList<MergeData>();

        protected MergeDataContainer() {
        }

        public void addMergeData(MergeData md) {
            MergeData foundMd = this.findMergeData(md.mergeSourcePath, md.mergeTargetPath);
            if (foundMd == null) {
                this.mergeDataCol.add(md);
            } else {
                foundMd.mergeSourceRevisions.addAll(md.mergeSourceRevisions);
            }
        }

        public void addMergeData(List<MergeData> mdList) {
            for (MergeData md : mdList) {
                this.addMergeData(md);
            }
        }

        protected MergeData findMergeData(int sourcePath, int targetPath) {
            for (MergeData md : this.mergeDataCol) {
                if (md.mergeSourcePath != sourcePath || md.mergeTargetPath != targetPath) continue;
                return md;
            }
            return null;
        }
    }

    protected static class PathHistory {
        protected LinkedList<PathWithRevision> list = new LinkedList();

        public PathHistory(PathWithRevision path) {
            this.list.add(path);
        }

        public void add(PathWithRevision path) {
            this.list.add(path);
        }

        public PathWithRevision getFirst() {
            return this.list.getFirst();
        }

        public boolean hasPath(int index) {
            return index < this.list.size();
        }

        public PathWithRevision get(int index) {
            return this.list.get(index);
        }

        public int size() {
            return this.list.size();
        }

        public String toString(RepositoryCache cache) {
            StringBuilder str = new StringBuilder();
            Iterator iter = this.list.iterator();
            while (iter.hasNext()) {
                PathWithRevision path = (PathWithRevision)iter.next();
                str.append(cache.getPathStorage().getPath(path.path));
                if (!iter.hasNext()) continue;
                str.append(" <-- ");
            }
            return str.toString();
        }
    }

    protected static class PathWithRevision {
        final int path;
        final long revision;

        public PathWithRevision(int path, long revision) {
            this.path = path;
            this.revision = revision;
        }
    }
}

