/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.operation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.revision.graph.SVNRevisionGraphMessages;
import org.eclipse.team.svn.revision.graph.SVNRevisionGraphPlugin;
import org.eclipse.team.svn.revision.graph.ShowRevisionGraphPanel;
import org.eclipse.team.svn.revision.graph.cache.RepositoryCacheInfo;
import org.eclipse.team.svn.revision.graph.cache.RepositoryCachesManager;
import org.eclipse.team.svn.revision.graph.graphic.RevisionGraphEditorInput;
import org.eclipse.team.svn.revision.graph.graphic.RevisionRootNode;
import org.eclipse.team.svn.revision.graph.operation.AddMergeInfoOperation;
import org.eclipse.team.svn.revision.graph.operation.CheckRepositoryConnectionOperation;
import org.eclipse.team.svn.revision.graph.operation.CreateCacheDataOperation;
import org.eclipse.team.svn.revision.graph.operation.CreateRevisionGraphModelOperation;
import org.eclipse.team.svn.revision.graph.preferences.SVNRevisionGraphPreferences;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.panel.IDialogPanel;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.ui.IEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevisionGraphUtility {
    protected static final String EDITOR_ID = "org.eclipse.team.svn.revision.graph.graphic.RevisionGraphEditor";

    public static CompositeOperation getRevisionGraphOperation(IRepositoryResource[] resources) {
        CompositeOperation mainOp = new CompositeOperation("Operation_ShowRevisionGraph", SVNRevisionGraphMessages.class);
        Map<String, List<IRepositoryResource>> splittedResources = RevisionGraphUtility.splitResources(resources);
        RevisionGraphUtility.filterResources(splittedResources);
        if (splittedResources.isEmpty()) {
            return null;
        }
        final ShowRevisionGraphPanel panel = new ShowRevisionGraphPanel(resources.length == 1 ? resources[0] : null);
        DefaultDialog rDlg = new DefaultDialog(UIMonitorUtility.getShell(), (IDialogPanel)panel);
        if (rDlg.open() != 0) {
            return null;
        }
        boolean isSkipFetchErrors = SVNRevisionGraphPreferences.getGraphBoolean(SVNRevisionGraphPlugin.instance().getPreferenceStore(), "skip.errors");
        for (List<IRepositoryResource> reposResources : splittedResources.values()) {
            CompositeOperation reposOp = new CompositeOperation(mainOp.getId(), SVNRevisionGraphMessages.class);
            mainOp.add((IActionOperation)reposOp);
            IRepositoryResource anyResource = reposResources.get(0);
            final CheckRepositoryConnectionOperation checkConnectionOp = new CheckRepositoryConnectionOperation(anyResource, panel.canIncludeMergeInfo(), true);
            reposOp.add((IActionOperation)checkConnectionOp);
            CreateCacheDataOperation createCacheOp = new CreateCacheDataOperation(anyResource, false, checkConnectionOp, isSkipFetchErrors);
            reposOp.add((IActionOperation)createCacheOp, new IActionOperation[]{checkConnectionOp});
            CompositeOperation resourceOp = new CompositeOperation(mainOp.getId(), SVNRevisionGraphMessages.class);
            reposOp.add((IActionOperation)resourceOp, new IActionOperation[]{checkConnectionOp, createCacheOp});
            for (final IRepositoryResource resource : reposResources) {
                final CreateRevisionGraphModelOperation createModelOp = new CreateRevisionGraphModelOperation(resource, createCacheOp);
                resourceOp.add((IActionOperation)createModelOp, new IActionOperation[]{createCacheOp});
                AddMergeInfoOperation addMergeInfoOp = new AddMergeInfoOperation(createModelOp, checkConnectionOp);
                resourceOp.add((IActionOperation)addMergeInfoOp, new IActionOperation[]{createModelOp});
                AbstractActionOperation showRevisionGraphOp = new AbstractActionOperation("Operation_ShowRevisionGraph", SVNRevisionGraphMessages.class){

                    protected void runImpl(IProgressMonitor monitor) throws Exception {
                        UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                            public void run() {
                                try {
                                    Object modelObject;
                                    if (createModelOp.getModel() != null) {
                                        RevisionRootNode rootNode = new RevisionRootNode(resource, createModelOp.getModel(), createModelOp.getRepositoryCache());
                                        rootNode.simpleSetMode(!panel.isShowAllRevisions());
                                        rootNode.setIncludeMergeInfo(checkConnectionOp.getRepositoryConnectionInfo().isSupportMergeInfo);
                                        modelObject = rootNode;
                                    } else {
                                        modelObject = SVNRevisionGraphMessages.NoData;
                                    }
                                    RevisionGraphEditorInput input = new RevisionGraphEditorInput(createModelOp.getResource(), modelObject);
                                    UIMonitorUtility.getActivePage().openEditor((IEditorInput)input, RevisionGraphUtility.EDITOR_ID);
                                }
                                catch (Exception e) {
                                    LoggedOperation.reportError((String)this.getClass().getName(), (Throwable)e);
                                }
                            }
                        });
                    }
                };
                resourceOp.add((IActionOperation)showRevisionGraphOp, new IActionOperation[]{createModelOp, addMergeInfoOp});
            }
        }
        return mainOp;
    }

    protected static Map<String, List<IRepositoryResource>> splitResources(IRepositoryResource[] resources) {
        HashMap<String, List<IRepositoryResource>> splittedResources = new HashMap<String, List<IRepositoryResource>>();
        IRepositoryResource[] iRepositoryResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IRepositoryResource resource = iRepositoryResourceArray[n2];
            String reposRoot = RepositoryCachesManager.getRepositoryRoot(resource);
            ArrayList<IRepositoryResource> resourcesList = (ArrayList<IRepositoryResource>)splittedResources.get(reposRoot);
            if (resourcesList == null) {
                resourcesList = new ArrayList<IRepositoryResource>();
                splittedResources.put(reposRoot, resourcesList);
            }
            resourcesList.add(resource);
            ++n2;
        }
        return splittedResources;
    }

    protected static void filterResources(Map<String, List<IRepositoryResource>> resources) {
        final ArrayList<String> caclulatingCaches = new ArrayList<String>();
        Iterator<Map.Entry<String, List<IRepositoryResource>>> iter = resources.entrySet().iterator();
        RepositoryCachesManager cachesManager = SVNRevisionGraphPlugin.instance().getRepositoryCachesManager();
        while (iter.hasNext()) {
            Map.Entry<String, List<IRepositoryResource>> entry = iter.next();
            IRepositoryResource resource = entry.getValue().get(0);
            RepositoryCacheInfo cacheInfo = cachesManager.getCache(resource);
            if (cacheInfo == null || !cacheInfo.isCacheDataCalculating()) continue;
            caclulatingCaches.add(entry.getKey());
            iter.remove();
        }
        if (!caclulatingCaches.isEmpty()) {
            UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                public void run() {
                    MessageDialog dlg = RevisionGraphUtility.getCacheCalculatingDialog(caclulatingCaches.toArray(new String[0]));
                    dlg.open();
                }
            });
        }
    }

    public static MessageDialog getCacheCalculatingDialog(String reposRoot) {
        return RevisionGraphUtility.getCacheCalculatingDialog(new String[]{reposRoot});
    }

    public static MessageDialog getCacheCalculatingDialog(String[] reposRoots) {
        StringBuilder strRepos = new StringBuilder();
        int i = 0;
        int n = reposRoots.length;
        while (i < n) {
            String reposRoot = reposRoots[i];
            strRepos.append(reposRoot);
            if (i != n - 1) {
                strRepos.append(", ");
            }
            ++i;
        }
        MessageDialog dlg = new MessageDialog(UIMonitorUtility.getShell(), SVNRevisionGraphMessages.Dialog_GraphTitle, null, SVNRevisionGraphMessages.format((String)SVNRevisionGraphMessages.CreateCacheDataOperation_DialogMessage, (Object)strRepos.toString()), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
        return dlg;
    }
}

