/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.wizard;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.IResourcePropertyProvider;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.eclipse.team.svn.core.operation.file.CheckoutAsOperation;
import org.eclipse.team.svn.core.operation.local.AddToSVNOperation;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.operation.local.RestoreProjectMetaOperation;
import org.eclipse.team.svn.core.operation.local.SaveProjectMetaOperation;
import org.eclipse.team.svn.core.operation.local.property.ConcatenateProperyDataOperation;
import org.eclipse.team.svn.core.operation.local.property.SetPropertiesOperation;
import org.eclipse.team.svn.core.operation.remote.GetRemoteFolderChildrenOperation;
import org.eclipse.team.svn.core.operation.remote.LocateProjectsOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryContainer;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryResourceProvider;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.action.remote.CheckoutAction;
import org.eclipse.team.svn.ui.extension.ExtensionsManager;
import org.eclipse.team.svn.ui.operation.MoveProjectsToWorkingSetOperation;
import org.eclipse.team.svn.ui.operation.ObtainProjectNameOperation;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.utility.DefaultOperationWrapperFactory;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.team.svn.ui.wizard.AbstractSVNWizard;
import org.eclipse.team.svn.ui.wizard.CheckoutProjectsWizard;
import org.eclipse.team.svn.ui.wizard.checkoutas.CheckoutAsFolderPage;
import org.eclipse.team.svn.ui.wizard.checkoutas.CheckoutMethodSelectionPage;
import org.eclipse.team.svn.ui.wizard.checkoutas.MultipleCheckoutMethodSelectionPage;
import org.eclipse.team.svn.ui.wizard.checkoutas.ProjectLocationSelectionPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.NewProjectAction;

public class CheckoutAsWizard
extends AbstractSVNWizard {
    public static final int SIZING_WIZARD_WIDTH = 570;
    public static final int SIZING_WIZARD_HEIGHT = 500;
    protected HashMap names2resources;
    protected IRepositoryResource[] resources;
    protected MultipleCheckoutMethodSelectionPage multipleMethodPage;
    protected CheckoutMethodSelectionPage methodSelectionPage;
    protected ProjectLocationSelectionPage locationSelectionPage;
    protected CheckoutAsFolderPage selectFolderPage;
    protected String projectName;
    protected boolean singleMode;
    protected IActionOperation priorOp;

    public CheckoutAsWizard(IRepositoryResource[] resources) {
        this(resources, null);
    }

    public CheckoutAsWizard(IRepositoryResource[] resources, IActionOperation priorOp) {
        this.setWindowTitle(SVNUIMessages.CheckoutAsWizard_Title);
        this.setForcePreviousAndNextButtons(true);
        this.resources = resources;
        this.singleMode = this.resources.length == 1;
        this.priorOp = priorOp;
    }

    public boolean isUseNewProjectWizard() {
        return this.methodSelectionPage == null ? false : this.methodSelectionPage.isUseNewProjectWizard();
    }

    public boolean isFindProjectsSelected() {
        return this.singleMode ? (this.methodSelectionPage == null ? false : this.methodSelectionPage.isFindProjectsSelected()) : (this.multipleMethodPage == null ? false : this.multipleMethodPage.isFindProjectsSelected());
    }

    public boolean isCheckoutAsFolderSelected() {
        return this.singleMode ? (this.methodSelectionPage == null ? false : this.methodSelectionPage.isCheckoutAsFolderSelected()) : (this.multipleMethodPage == null ? false : this.multipleMethodPage.isCheckoutAsFolderSelected());
    }

    public IContainer getTargetFolder() {
        return this.selectFolderPage.getTargetFolder();
    }

    public SVNDepth getCheckoutDepth() {
        return this.singleMode ? (this.methodSelectionPage == null ? SVNDepth.INFINITY : this.methodSelectionPage.getdepth()) : (this.multipleMethodPage == null ? SVNDepth.INFINITY : this.multipleMethodPage.getdepth());
    }

    public String getProjectName() {
        return this.methodSelectionPage == null ? this.resources[0].getName() : this.methodSelectionPage.getProjectName();
    }

    public SVNRevision getRevisionToCheckoutFrom() {
        return this.methodSelectionPage != null ? this.methodSelectionPage.getSelectedRevision() : this.multipleMethodPage.getSelectedRevision();
    }

    public String getLocation() {
        return this.isCheckoutAsFolderSelected() ? FileUtility.getWorkingCopyPath((IResource)this.getTargetFolder()) : this.locationSelectionPage.getLocation();
    }

    public String getWorkingSetName() {
        return this.locationSelectionPage.getWorkingSetName();
    }

    public void addPages() {
        if (this.resources.length == 1) {
            this.projectName = this.fetchProjectName();
            GetRemoteFolderChildrenOperation op = new GetRemoteFolderChildrenOperation((IRepositoryContainer)this.resources[0], false);
            UIMonitorUtility.doTaskBusy((IActionOperation)op, new DefaultOperationWrapperFactory(){

                public IActionOperation getLogged(IActionOperation operation) {
                    return new LoggedOperation(operation);
                }
            });
            boolean isEclipseProject = false;
            if (op.getExecutionState() == 0) {
                IRepositoryResource[] children = op.getChildren();
                int i = 0;
                while (i < children.length) {
                    if (children[i].getName().equals(".project")) {
                        isEclipseProject = true;
                        break;
                    }
                    ++i;
                }
            }
            this.methodSelectionPage = new CheckoutMethodSelectionPage(this.projectName, !isEclipseProject, this.resources[0]);
            this.addPage((IWizardPage)this.methodSelectionPage);
        } else {
            this.multipleMethodPage = new MultipleCheckoutMethodSelectionPage(this.resources);
            this.addPage((IWizardPage)this.multipleMethodPage);
        }
        this.selectFolderPage = new CheckoutAsFolderPage(this.resources);
        this.addPage((IWizardPage)this.selectFolderPage);
        this.locationSelectionPage = new ProjectLocationSelectionPage(this.resources.length > 1, null);
        this.addPage((IWizardPage)this.locationSelectionPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.selectFolderPage) {
            return null;
        }
        if (page instanceof CheckoutMethodSelectionPage ? this.methodSelectionPage.isUseNewProjectWizard() || this.methodSelectionPage.isFindProjectsSelected() : page instanceof MultipleCheckoutMethodSelectionPage && this.multipleMethodPage.isFindProjectsSelected()) {
            return null;
        }
        if (!(page != this.methodSelectionPage && page != this.multipleMethodPage || this.isCheckoutAsFolderSelected())) {
            return super.getNextPage(super.getNextPage(page));
        }
        return super.getNextPage(page);
    }

    public boolean performFinish() {
        if (this.isFindProjectsSelected()) {
            CompositeOperation op = this.getLocateProjectsOperation(this.resources, this.getCheckoutDepth(), this.getRevisionToCheckoutFrom());
            UIMonitorUtility.doTaskScheduledActive((IActionOperation)op);
        } else if (this.obtainNames()) {
            this.doCheckout(this.getLocation(), this.getProjectName(), this.isUseNewProjectWizard(), this.getCheckoutDepth(), this.getWorkingSetName(), this.getRevisionToCheckoutFrom());
        }
        return true;
    }

    protected String fetchProjectName() {
        ObtainProjectNameOperation obtainOperation = new ObtainProjectNameOperation(this.resources);
        UIMonitorUtility.doTaskNowDefault((IActionOperation)obtainOperation, true);
        if (obtainOperation.getExecutionState() != 0) {
            return this.resources[0].getName();
        }
        this.names2resources = ExtensionsManager.getInstance().getCurrentCheckoutFactory().prepareName2resources(obtainOperation.getNames2Resources());
        return (String)this.names2resources.keySet().iterator().next();
    }

    protected boolean obtainNames() {
        if (this.names2resources == null) {
            ObtainProjectNameOperation obtainOperation = new ObtainProjectNameOperation(this.resources);
            UIMonitorUtility.doTaskNowDefault((IActionOperation)obtainOperation, true);
            if (obtainOperation.getExecutionState() != 0) {
                return false;
            }
            this.names2resources = ExtensionsManager.getInstance().getCurrentCheckoutFactory().prepareName2resources(obtainOperation.getNames2Resources());
        }
        return true;
    }

    protected void doCheckout(String location, String projectName, boolean useNewProjectWizard, SVNDepth depth, String workingSetName, SVNRevision revisionToCheckoutFrom) {
        if (!useNewProjectWizard && this.names2resources.keySet().size() == 1) {
            Object resource = this.names2resources.get(this.names2resources.keySet().iterator().next());
            this.names2resources.clear();
            this.names2resources.put(projectName, resource);
        }
        ArrayList operateResources = new ArrayList();
        if (useNewProjectWizard) {
            operateResources.add(this.names2resources.get(this.names2resources.keySet().iterator().next()));
        } else {
            operateResources = CheckoutAction.getOperateResources(this.names2resources, CheckoutAction.getResources2Names(this.names2resources), this.getShell(), location, !this.isCheckoutAsFolderSelected());
        }
        if (operateResources.size() > 0) {
            CompositeOperation op = null;
            if (useNewProjectWizard) {
                ProjectAdditionListener listener = new ProjectAdditionListener();
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener, 1);
                new NewProjectAction(PlatformUI.getWorkbench().getActiveWorkbenchWindow()).run();
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
                IProject selectedProject = listener.getProject();
                if (selectedProject != null) {
                    op = this.prepareForOne((IRepositoryResource)operateResources.get(0), selectedProject.getName(), FileUtility.getResourcePath((IResource)selectedProject).removeLastSegments(1).toString(), true, depth, workingSetName, revisionToCheckoutFrom);
                }
            } else if (this.isCheckoutAsFolderSelected()) {
                HashMap resources2Names = new HashMap();
                if (this.names2resources != null) {
                    for (Map.Entry entry : this.names2resources.entrySet()) {
                        resources2Names.put(entry.getValue(), entry.getKey());
                    }
                }
                Map mappings = this.getExternalsFolderNames(this.resources, resources2Names);
                IResource destinationRoot = ResourcesPlugin.getWorkspace().getRoot().findMember(this.selectFolderPage.getTargetFolder().getFullPath());
                ILocalResource localDest = SVNRemoteStorage.instance().asLocalResource(destinationRoot);
                op = IStateFilter.SF_INTERNAL_INVALID.accept(localDest) ? this.getCheckoutAsFolderOperationUnshared(this.getTargetFolder(), this.resources, mappings) : this.getCheckoutAsFolderOperation(this.getTargetFolder(), this.resources, mappings);
            } else if (this.singleMode) {
                op = this.prepareForOne((IRepositoryResource)operateResources.get(0), projectName, location, false, depth, workingSetName, revisionToCheckoutFrom);
            } else {
                HashMap operateMap = new HashMap();
                for (IRepositoryResource resource : operateResources) {
                    HashMap resources2names = CheckoutAction.getResources2Names(this.names2resources);
                    operateMap.put(resources2names.get(resource), resource);
                }
                op = this.prepareForMultiple(operateMap, location, depth, workingSetName, revisionToCheckoutFrom);
            }
            if (op != null) {
                if (this.priorOp != null) {
                    CompositeOperation tmp = new CompositeOperation(op.getId(), op.getMessagesClass());
                    tmp.add(this.priorOp);
                    tmp.add((IActionOperation)op, new IActionOperation[]{this.priorOp});
                    op = tmp;
                }
                UIMonitorUtility.doTaskScheduledActive((IActionOperation)op);
            }
        }
    }

    protected IActionOperation getCheckoutAsFolderOperationUnshared(IContainer targetFolder, IRepositoryResource[] resources, Map mappings) {
        CompositeOperation op = new CompositeOperation(SVNUIMessages.Operation_CheckoutAsFolder, SVNUIMessages.class);
        int i = 0;
        while (i < resources.length) {
            IPath location = FileUtility.getResourcePath((IResource)targetFolder);
            File target = location.append((String)mappings.get(resources[i])).toFile();
            IRepositoryResource modifiedResource = SVNUtility.copyOf((IRepositoryResource)resources[i]);
            modifiedResource.setSelectedRevision(this.getRevisionToCheckoutFrom());
            op.add((IActionOperation)new CheckoutAsOperation(target, modifiedResource, this.getCheckoutDepth(), SVNTeamPreferences.getBehaviourBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "externals.ignore"), false));
            ++i;
        }
        IResource[] localResources = new IResource[]{targetFolder};
        op.add((IActionOperation)new RefreshResourcesOperation(localResources), null);
        return op;
    }

    protected IActionOperation getCheckoutAsFolderOperation(IContainer targetFolder, IRepositoryResource[] resources, Map mappings) {
        String externalsData = "";
        int i = 0;
        while (i < resources.length) {
            String line = String.valueOf((String)mappings.get(resources[i])) + "\t" + SVNUtility.encodeURL((String)resources[i].getUrl()) + "\n";
            externalsData = String.valueOf(externalsData) + line;
            ++i;
        }
        CompositeOperation op = new CompositeOperation(SVNUIMessages.Operation_CheckoutAsFolder, SVNMessages.class);
        IActionOperation[] dependency = null;
        IResource[] localResources = new IResource[]{targetFolder};
        ILocalResource localResource = SVNRemoteStorage.instance().asLocalResourceAccessible((IResource)targetFolder);
        IResource[] newResources = null;
        if (IStateFilter.SF_UNVERSIONED.accept(localResource)) {
            newResources = FileUtility.addOperableParents((IResource[])localResources, (IStateFilter)IStateFilter.SF_UNVERSIONED);
        }
        if (newResources != null && newResources.length > 0) {
            AddToSVNOperation addToSVN = new AddToSVNOperation(newResources);
            op.add((IActionOperation)addToSVN);
            dependency = new IActionOperation[]{addToSVN};
        }
        ConcatenateProperyDataOperation concatenateProps = new ConcatenateProperyDataOperation((IResource)targetFolder, "svn:externals", externalsData.getBytes());
        op.add((IActionOperation)concatenateProps, dependency);
        dependency = new IActionOperation[]{concatenateProps};
        SetPropertiesOperation setProps = new SetPropertiesOperation(localResources, (IResourcePropertyProvider)concatenateProps, false);
        op.add((IActionOperation)setProps, dependency);
        dependency = new IActionOperation[]{setProps};
        int i2 = 0;
        while (i2 < resources.length) {
            IPath location = targetFolder.getLocation();
            if (location != null) {
                File target = location.append((String)mappings.get(resources[i2])).toFile();
                IRepositoryResource modifiedResource = SVNUtility.copyOf((IRepositoryResource)resources[i2]);
                modifiedResource.setSelectedRevision(this.getRevisionToCheckoutFrom());
                op.add((IActionOperation)new CheckoutAsOperation(target, modifiedResource, this.getCheckoutDepth(), SVNTeamPreferences.getBehaviourBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "externals.ignore"), false), dependency);
            }
            ++i2;
        }
        op.add((IActionOperation)new RefreshResourcesOperation(localResources), dependency);
        return op;
    }

    protected Map getExternalsFolderNames(IRepositoryResource[] resources, Map resource2Name) {
        HashMap<IRepositoryResource, String> retVal = new HashMap<IRepositoryResource, String>();
        HashSet<String> allNames = new HashSet<String>();
        int i = 0;
        while (i < resources.length) {
            String name = (String)resource2Name.get(resources[i]);
            if (name == null) {
                name = resources[i].getName();
            }
            name = this.getName(this.getTargetFolder(), name, allNames);
            retVal.put(resources[i], name);
            allNames.add(name);
            ++i;
        }
        return retVal;
    }

    protected String getName(IContainer targetFolder, String baseName, Set allNames) {
        String name;
        baseName = baseName.replace(' ', '_');
        if (targetFolder == null || !targetFolder.exists((IPath)new Path(baseName))) {
            return baseName;
        }
        int i = 1;
        while (targetFolder.exists((IPath)new Path(name = String.valueOf(baseName) + "_(" + i + ")")) || allNames.contains(name)) {
            ++i;
        }
        return name;
    }

    protected CompositeOperation prepareForOne(IRepositoryResource resource, String projectName, String location, boolean isUseNewProjectWizard, SVNDepth depth, String workingSetName, SVNRevision revisionToCheckoutFrom) {
        IRepositoryResource modifiedResource = SVNUtility.copyOf((IRepositoryResource)resource);
        modifiedResource.setSelectedRevision(revisionToCheckoutFrom);
        org.eclipse.team.svn.core.operation.remote.CheckoutAsOperation mainOp = new org.eclipse.team.svn.core.operation.remote.CheckoutAsOperation(projectName, modifiedResource, location, depth, SVNTeamPreferences.getBehaviourBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "externals.ignore"));
        CompositeOperation op = new CompositeOperation(mainOp.getId(), mainOp.getMessagesClass());
        if (isUseNewProjectWizard) {
            SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(new IResource[]{mainOp.getProject()}, "");
            op.add((IActionOperation)saveOp);
            op.add((IActionOperation)mainOp);
            mainOp.setRestoreOperation(new RestoreProjectMetaOperation(saveOp, true));
        } else {
            op.add((IActionOperation)mainOp);
        }
        if (workingSetName != null) {
            op.add((IActionOperation)new MoveProjectsToWorkingSetOperation((IResource[])new IProject[]{mainOp.getProject()}, workingSetName));
        }
        return op;
    }

    protected CompositeOperation prepareForMultiple(HashMap name2resources, String location, SVNDepth depth, String workingSetName, SVNRevision revisionToCheckoutFrom) {
        CompositeOperation op = new CompositeOperation("", SVNUIMessages.class);
        IResource[] locals = new IResource[name2resources.keySet().size()];
        int i = 0;
        for (String name : name2resources.keySet()) {
            boolean ignoreExternals = SVNTeamPreferences.getBehaviourBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "externals.ignore");
            IRepositoryResource modifiedResource = SVNUtility.copyOf((IRepositoryResource)((IRepositoryResource)name2resources.get(name)));
            modifiedResource.setSelectedRevision(revisionToCheckoutFrom);
            org.eclipse.team.svn.core.operation.remote.CheckoutAsOperation mainOp = new org.eclipse.team.svn.core.operation.remote.CheckoutAsOperation(name, modifiedResource, false, location, depth, ignoreExternals);
            locals[i] = mainOp.getProject();
            op.add((IActionOperation)mainOp);
            op.setOperationName(mainOp.getId());
            ++i;
        }
        if (workingSetName != null) {
            op.add((IActionOperation)new MoveProjectsToWorkingSetOperation(locals, workingSetName));
        }
        return op;
    }

    protected CompositeOperation getLocateProjectsOperation(IRepositoryResource[] resources, SVNDepth depth, SVNRevision revisionToCheckoutFrom) {
        int i = 0;
        while (i < resources.length) {
            IRepositoryResource tmpResource = SVNUtility.copyOf((IRepositoryResource)resources[i]);
            tmpResource.setSelectedRevision(revisionToCheckoutFrom);
            resources[i] = tmpResource;
            ++i;
        }
        LocateProjectsOperation mainOp = new LocateProjectsOperation(resources, ExtensionsManager.getInstance().getCurrentCheckoutFactory().getLocateFilter(), 5);
        CompositeOperation op = new CompositeOperation(mainOp.getId(), mainOp.getMessagesClass());
        op.add((IActionOperation)mainOp);
        IRepositoryResourceProvider provider = ExtensionsManager.getInstance().getCurrentCheckoutFactory().additionalProcessing(op, (IRepositoryResourceProvider)mainOp);
        ObtainProjectNameOperation obtainOperation = new ObtainProjectNameOperation(provider);
        op.add((IActionOperation)obtainOperation, new IActionOperation[]{mainOp});
        op.add((IActionOperation)this.getCheckoutProjectOperation(resources, obtainOperation, depth, revisionToCheckoutFrom), new IActionOperation[]{obtainOperation});
        return op;
    }

    protected AbstractActionOperation getCheckoutProjectOperation(final IRepositoryResource[] resources, final ObtainProjectNameOperation obtainOperation, final SVNDepth depth, SVNRevision revisionToCheckoutFrom) {
        return new AbstractActionOperation("Operation_CheckoutProjects", SVNUIMessages.class){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        HashMap<String, IRepositoryResource> name2resources = obtainOperation.getNames2Resources();
                        if (name2resources.isEmpty()) {
                            new MessageDialog(UIMonitorUtility.getShell(), this.getOperationResource("Title"), null, this.getOperationResource("Message"), 2, new String[]{IDialogConstants.OK_LABEL}, 0).open();
                            return;
                        }
                        CheckoutProjectsWizard wizard = new CheckoutProjectsWizard(resources, name2resources);
                        WizardDialog dialog = new WizardDialog(UIMonitorUtility.getShell(), (IWizard)wizard);
                        dialog.create();
                        wizard.postInit();
                        dialog.getShell().setSize(Math.max(570, dialog.getShell().getSize().x), 500);
                        if (dialog.open() == 0) {
                            IActionOperation op;
                            Set<String> projectNames;
                            List selection = wizard.getResultSelections();
                            if (wizard.isCheckoutAsFoldersSelected()) {
                                projectNames = null;
                                HashMap resources2Names = new HashMap();
                                if ((this).CheckoutAsWizard.this.names2resources != null) {
                                    for (Map.Entry entry : (this).CheckoutAsWizard.this.names2resources.entrySet()) {
                                        resources2Names.put(entry.getValue(), entry.getKey());
                                    }
                                }
                                Map mappings = CheckoutAsWizard.this.getExternalsFolderNames(resources, resources2Names);
                                op = CheckoutAsWizard.this.getCheckoutAsFolderOperation(wizard.getTargetFolder(), selection.toArray(new IRepositoryResource[selection.size()]), mappings);
                            } else {
                                HashMap<String, IRepositoryResource> selectedMap = new HashMap<String, IRepositoryResource>();
                                ArrayList<IRepositoryResource> projects = new ArrayList<IRepositoryResource>();
                                projectNames = name2resources.keySet();
                                for (String projName : projectNames) {
                                    if (!wizard.getResultSelections().contains(name2resources.get(projName))) continue;
                                    selectedMap.put(projName, name2resources.get(projName));
                                    projects.add(name2resources.get(projName));
                                }
                                boolean ignoreExternals = SVNTeamPreferences.getBehaviourBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "externals.ignore");
                                op = ExtensionsManager.getInstance().getCurrentCheckoutFactory().getCheckoutOperation(CheckoutAsWizard.this.getShell(), projects.toArray(new IRepositoryResource[projects.size()]), selectedMap, wizard.isRespectHierarchy(), wizard.getLocation(), depth, ignoreExternals);
                            }
                            if (op != null) {
                                String wsName = wizard.getWorkingSetName();
                                if ((this).CheckoutAsWizard.this.priorOp != null || wsName != null) {
                                    CompositeOperation tmp = new CompositeOperation(op.getId(), op.getMessagesClass());
                                    if ((this).CheckoutAsWizard.this.priorOp != null) {
                                        tmp.add((this).CheckoutAsWizard.this.priorOp);
                                        tmp.add(op, new IActionOperation[]{(this).CheckoutAsWizard.this.priorOp});
                                    } else {
                                        tmp.add(op);
                                    }
                                    if (wsName != null) {
                                        tmp.add((IActionOperation)new MoveProjectsToWorkingSetOperation(new IResourceProvider(){

                                            public IResource[] getResources() {
                                                ArrayList<IProject> projects = new ArrayList<IProject>();
                                                for (String name : projectNames) {
                                                    IProject prj = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                                                    if (prj == null) continue;
                                                    projects.add(prj);
                                                }
                                                return projects.toArray(new IProject[projects.size()]);
                                            }
                                        }, wsName));
                                    }
                                    op = tmp;
                                }
                                UIMonitorUtility.doTaskScheduledActive(op);
                            }
                        }
                    }
                });
            }
        };
    }

    public boolean canFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if ((currentPage instanceof CheckoutMethodSelectionPage || currentPage instanceof MultipleCheckoutMethodSelectionPage) && this.isCheckoutAsFolderSelected()) {
            return false;
        }
        return super.canFinish();
    }

    protected class ProjectAdditionListener
    implements IResourceChangeListener {
        protected IProject project = null;

        protected ProjectAdditionListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta[] deltas = event.getDelta().getAffectedChildren();
            int i = 0;
            while (i < deltas.length) {
                IResource resource = deltas[i].getResource();
                if (resource instanceof IProject) {
                    if (deltas[i].getKind() == 1) {
                        this.project = (IProject)resource;
                    } else if (deltas[i].getKind() == 2 && this.project == resource) {
                        this.project = null;
                    }
                }
                ++i;
            }
        }

        public IProject getProject() {
            return this.project;
        }
    }
}

