/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.common.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.TreeMap;
import org.eclipse.wst.wsi.internal.core.common.AddStyleSheet;

public class AddStyleSheetImpl
implements AddStyleSheet {
    protected TreeMap attributeValueList = new TreeMap();
    protected String[] attributeNameList = new String[]{"href", "type", "title", "media", "charset", "alternate"};
    protected boolean comment = false;

    public String getHref() {
        return (String)this.attributeValueList.get("href");
    }

    public void setHref(String href) {
        this.attributeValueList.put("href", href);
    }

    public String getType() {
        return (String)this.attributeValueList.get("type");
    }

    public void setType(String type) {
        this.attributeValueList.put("type", type);
    }

    public String getTitle() {
        return (String)this.attributeValueList.get("title");
    }

    public void setTitle(String title) {
        this.attributeValueList.put("title", title);
    }

    public String getMedia() {
        return (String)this.attributeValueList.get("media");
    }

    public void setMedia(String media) {
        this.attributeValueList.put("media", media);
    }

    public String getCharset() {
        return (String)this.attributeValueList.get("charset");
    }

    public void setCharset(String charset) {
        this.attributeValueList.put("charset", charset);
    }

    public String getAlternate() {
        return (String)this.attributeValueList.get("alternate");
    }

    public void setAlternate(String alternate) {
        this.attributeValueList.put("alternate", alternate);
    }

    public void setComment(boolean comment) {
        this.comment = comment;
    }

    public String getStyleSheetString() {
        StringBuffer styleSheet = new StringBuffer();
        if (this.comment) {
            styleSheet.append("<!-- ");
        }
        styleSheet.append("<?xml-stylesheet");
        int i = 0;
        while (i < this.attributeNameList.length) {
            String value = (String)this.attributeValueList.get(this.attributeNameList[i]);
            if (value != null) {
                styleSheet.append(" " + this.attributeNameList[i] + "=\"" + value + "\"");
            }
            ++i;
        }
        styleSheet.append(" ?>");
        if (this.comment) {
            styleSheet.append(" -->");
        }
        return styleSheet.toString();
    }

    public String toString() {
        return this.getStyleSheetString();
    }

    public String toXMLString(String namespaceName) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        String nsName = namespaceName;
        if (!nsName.equals("") && !nsName.endsWith(":")) {
            nsName = String.valueOf(nsName) + ":";
        }
        pw.print("      <" + nsName + "addStyleSheet" + " ");
        pw.print("href=\"" + this.getHref() + "\" ");
        pw.print("type=\"" + this.getType() + "\" ");
        if (this.getTitle() != null) {
            pw.print("title=\"" + this.getTitle() + "\" ");
        }
        if (this.getMedia() != null) {
            pw.print("media=\"" + this.getMedia() + "\" ");
        }
        if (this.getCharset() != null) {
            pw.print("charset=\"" + this.getCharset() + "\" ");
        }
        if (this.getAlternate() != null) {
            pw.print("alternate=\"" + this.getAlternate() + "\" ");
        }
        pw.println("/>");
        return sw.toString();
    }
}

