/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import org.eclipse.wst.xml.xpath2.api.DynamicContext;
import org.eclipse.wst.xml.xpath2.api.Item;
import org.eclipse.wst.xml.xpath2.api.ResultBuffer;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeDefinition;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpEq;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpGt;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpLt;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.CalendarType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.CtrType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSAnyURI;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSBase64Binary;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDuration;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSHexBinary;
import org.eclipse.wst.xml.xpath2.processor.internal.types.builtin.BuiltinTypeLibrary;

public class XSBoolean
extends CtrType
implements CmpEq,
CmpGt,
CmpLt {
    private static final String XS_BOOLEAN = "xs:boolean";
    public static final XSBoolean TRUE = new XSBoolean(true);
    public static final XSBoolean FALSE = new XSBoolean(false);
    private boolean _value;
    static /* synthetic */ Class class$0;

    public XSBoolean(boolean x) {
        this._value = x;
    }

    public XSBoolean() {
        this(false);
    }

    public String string_type() {
        return XS_BOOLEAN;
    }

    public Object getNativeValue() {
        return this._value;
    }

    public String type_name() {
        return "boolean";
    }

    public String getStringValue() {
        return "" + this._value;
    }

    public boolean value() {
        return this._value;
    }

    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        if (arg.empty()) {
            return ResultBuffer.EMPTY;
        }
        Item anyType = arg.first();
        if (anyType instanceof XSDuration || anyType instanceof CalendarType || anyType instanceof XSBase64Binary || anyType instanceof XSHexBinary || anyType instanceof XSAnyURI) {
            throw DynamicError.invalidType();
        }
        String str_value = anyType.getStringValue();
        if (!this.isCastable(anyType, str_value)) {
            throw DynamicError.cant_cast(null);
        }
        return XSBoolean.valueOf(!this.isFalse(str_value));
    }

    private boolean isFalse(String str_value) {
        return str_value.equals("0") || str_value.equals("false") || str_value.equals("+0") || str_value.equals("-0") || str_value.equals("0.0E0") || str_value.equals("NaN");
    }

    private boolean isCastable(Item anyType, String str_value) {
        return str_value.equals("0") || str_value.equals("1") || str_value.equals("true") || str_value.equals("false") || anyType instanceof NumericType;
    }

    public boolean eq(AnyType arg, DynamicContext dynamicContext) throws DynamicError {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xml.xpath2.processor.internal.types.XSBoolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XSBoolean barg = (XSBoolean)NumericType.get_single_type((Item)arg, (Class)clazz);
        return this.value() == barg.value();
    }

    public boolean gt(AnyType arg, DynamicContext context) throws DynamicError {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xml.xpath2.processor.internal.types.XSBoolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XSBoolean barg = (XSBoolean)NumericType.get_single_type((Item)arg, (Class)clazz);
        boolean result = false;
        if (this.value() && !barg.value()) {
            result = true;
        }
        return result;
    }

    public boolean lt(AnyType arg, DynamicContext context) throws DynamicError {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xml.xpath2.processor.internal.types.XSBoolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XSBoolean barg = (XSBoolean)NumericType.get_single_type((Item)arg, (Class)clazz);
        boolean result = false;
        if (!this.value() && barg.value()) {
            result = true;
        }
        return result;
    }

    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_BOOLEAN;
    }

    public static ResultSequence valueOf(boolean answer) {
        return answer ? TRUE : FALSE;
    }
}

