/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.behaviours;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteSeparator;
import org.eclipse.gef.palette.PaletteStack;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.palette.IConnectionCreationToolEntry;
import org.eclipse.graphiti.palette.ICreationToolEntry;
import org.eclipse.graphiti.palette.IObjectCreationToolEntry;
import org.eclipse.graphiti.palette.IPaletteCompartmentEntry;
import org.eclipse.graphiti.palette.IPaletteSeparatorEntry;
import org.eclipse.graphiti.palette.IStackToolEntry;
import org.eclipse.graphiti.palette.IToolEntry;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.editor.IEclipseImageDescriptor;
import org.eclipse.graphiti.ui.internal.Messages;
import org.eclipse.graphiti.ui.internal.editor.GFConnectionCreationTool;
import org.eclipse.graphiti.ui.internal.editor.GFCreationTool;
import org.eclipse.graphiti.ui.internal.editor.GFPanningSelectionToolEntry;
import org.eclipse.graphiti.ui.internal.util.gef.MultiCreationFactory;
import org.eclipse.graphiti.ui.platform.IConfigurationProvider;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.jface.resource.ImageDescriptor;

public class CamelPaletteRoot
extends PaletteRoot {
    private static boolean DND_FROM_PALETTE = true;
    private IConfigurationProvider cfgProvider;
    private String filter;

    public CamelPaletteRoot(IConfigurationProvider configurationProvider, String filter) {
        this.cfgProvider = configurationProvider;
        this.setFilter(filter);
        this.updatePaletteEntries();
    }

    public void updatePaletteEntries() {
        this.setDefaultEntry(null);
        ArrayList allEntries = new ArrayList(this.getChildren());
        for (PaletteEntry entry : allEntries) {
            this.remove(entry);
        }
        this.add((PaletteEntry)this.createModelIndependentTools());
        if (this.cfgProvider != null && this.cfgProvider.getDiagramTypeProvider() != null) {
            IPaletteCompartmentEntry[] paletteCompartments;
            IToolBehaviorProvider currentToolBehaviorProvider = this.cfgProvider.getDiagramTypeProvider().getCurrentToolBehaviorProvider();
            IPaletteCompartmentEntry[] iPaletteCompartmentEntryArray = paletteCompartments = currentToolBehaviorProvider.getPalette();
            int n = paletteCompartments.length;
            int n2 = 0;
            while (n2 < n) {
                IPaletteCompartmentEntry compartmentEntry = iPaletteCompartmentEntryArray[n2];
                PaletteDrawer drawer = new PaletteDrawer(compartmentEntry.getLabel(), this.getImageDescriptor(compartmentEntry));
                if (this.isFiltered()) {
                    drawer.setInitialState(2);
                } else if (!compartmentEntry.isInitiallyOpen()) {
                    drawer.setInitialState(1);
                }
                List toolEntries = compartmentEntry.getToolEntries();
                for (IToolEntry toolEntry : toolEntries) {
                    if (toolEntry instanceof ICreationToolEntry) {
                        ICreationToolEntry creationToolEntry = (ICreationToolEntry)toolEntry;
                        PaletteEntry createTool = this.createTool(creationToolEntry);
                        if (createTool == null || !this.filter(createTool)) continue;
                        drawer.add(createTool);
                        continue;
                    }
                    if (toolEntry instanceof IStackToolEntry) {
                        IStackToolEntry stackToolEntry = (IStackToolEntry)toolEntry;
                        PaletteStack stack = new PaletteStack(stackToolEntry.getLabel(), stackToolEntry.getDescription(), GraphitiUi.getImageService().getImageDescriptorForId(this.cfgProvider.getDiagramTypeProvider().getProviderId(), stackToolEntry.getIconId()));
                        drawer.add((PaletteEntry)stack);
                        List creationToolEntries = stackToolEntry.getCreationToolEntries();
                        for (ICreationToolEntry creationToolEntry : creationToolEntries) {
                            PaletteEntry createTool = this.createTool(creationToolEntry);
                            if (createTool == null || !this.filter(createTool)) continue;
                            stack.add(createTool);
                        }
                        continue;
                    }
                    if (!(toolEntry instanceof IPaletteSeparatorEntry)) continue;
                    drawer.add((PaletteEntry)new PaletteSeparator());
                }
                if (!drawer.getChildren().isEmpty()) {
                    this.add((PaletteEntry)drawer);
                }
                ++n2;
            }
        }
    }

    public boolean isFiltered() {
        return this.filter != null && this.filter.length() > 0;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter == null ? null : filter.toLowerCase().trim();
    }

    protected boolean filter(PaletteEntry paletteEntry) {
        if (this.filter == null || this.filter.length() == 0) {
            return true;
        }
        return paletteEntry.getLabel() != null && paletteEntry.getLabel().toLowerCase().contains(this.filter);
    }

    protected PaletteContainer createModelIndependentTools() {
        PaletteGroup controlGroup = new PaletteGroup(Messages.GraphicsPaletteRoot_0_xmen);
        ArrayList<GFPanningSelectionToolEntry> entries = new ArrayList<GFPanningSelectionToolEntry>();
        GFPanningSelectionToolEntry tool = new GFPanningSelectionToolEntry();
        entries.add(tool);
        this.setDefaultEntry((ToolEntry)tool);
        controlGroup.addAll(entries);
        return controlGroup;
    }

    private PaletteEntry createTool(ICreationToolEntry creationToolEntry) {
        if (creationToolEntry instanceof IObjectCreationToolEntry) {
            IObjectCreationToolEntry objectCreationToolEntry = (IObjectCreationToolEntry)creationToolEntry;
            ICreateFeature feat = objectCreationToolEntry.getCreateFeature();
            DefaultCreationFactory cf = new DefaultCreationFactory(feat, ICreateFeature.class);
            DefaultCreationFactory template = DND_FROM_PALETTE ? cf : null;
            CombinedTemplateCreationEntry pe = new CombinedTemplateCreationEntry(feat.getCreateName(), feat.getCreateDescription(), (Object)template, (CreationFactory)cf, this.getImageDescriptor(creationToolEntry, true), this.getImageDescriptor(creationToolEntry, false));
            pe.setToolClass(GFCreationTool.class);
            return pe;
        }
        if (creationToolEntry instanceof IConnectionCreationToolEntry) {
            IConnectionCreationToolEntry connectionCreationToolEntry = (IConnectionCreationToolEntry)creationToolEntry;
            MultiCreationFactory multiCreationFactory = new MultiCreationFactory(connectionCreationToolEntry.getCreateConnectionFeatures());
            ConnectionCreationToolEntry pe = new ConnectionCreationToolEntry(creationToolEntry.getLabel(), creationToolEntry.getDescription(), (CreationFactory)multiCreationFactory, this.getImageDescriptor(creationToolEntry, true), this.getImageDescriptor(creationToolEntry, false));
            pe.setToolClass(GFConnectionCreationTool.class);
            return pe;
        }
        return null;
    }

    private ImageDescriptor getImageDescriptor(ICreationToolEntry creationToolEntry, boolean smallImage) {
        ImageDescriptor imageDescriptor;
        if (creationToolEntry instanceof IEclipseImageDescriptor) {
            imageDescriptor = ((IEclipseImageDescriptor)creationToolEntry).getImageDescriptor();
        } else {
            String iconId = smallImage ? creationToolEntry.getIconId() : creationToolEntry.getLargeIconId();
            imageDescriptor = GraphitiUi.getImageService().getImageDescriptorForId(this.cfgProvider.getDiagramTypeProvider().getProviderId(), iconId);
        }
        return imageDescriptor;
    }

    private ImageDescriptor getImageDescriptor(IPaletteCompartmentEntry compartmentEntry) {
        ImageDescriptor imageDescriptor = compartmentEntry instanceof IEclipseImageDescriptor ? ((IEclipseImageDescriptor)compartmentEntry).getImageDescriptor() : GraphitiUi.getImageService().getImageDescriptorForId(this.cfgProvider.getDiagramTypeProvider().getProviderId(), compartmentEntry.getIconId());
        return imageDescriptor;
    }

    private class DefaultCreationFactory
    implements CreationFactory {
        private Object obj;
        private Object objType;

        public DefaultCreationFactory(Object obj, Object objType) {
            this.obj = obj;
            this.objType = objType;
        }

        public Object getNewObject() {
            return this.obj;
        }

        public Object getObjectType() {
            return this.objType;
        }
    }
}

