/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.features.misc;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.impl.DefaultResizeShapeFeature;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Image;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.fusesource.ide.camel.model.service.core.catalog.eips.Eip;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;

public class ResizeNodeFeature
extends DefaultResizeShapeFeature {
    public ResizeNodeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canResizeShape(IResizeShapeContext context) {
        Eip underlyingMetaModelObject;
        Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        return bo instanceof AbstractCamelModelElement && (underlyingMetaModelObject = ((AbstractCamelModelElement)bo).getUnderlyingMetaModelObject()) != null && underlyingMetaModelObject.canHaveChildren();
    }

    public void resizeShape(IResizeShapeContext context) {
        Shape shape = context.getShape();
        int x = context.getX();
        int y = context.getY();
        int w = context.getWidth();
        int h = context.getHeight();
        if (w == 0) {
            int n = w = Graphiti.getPeService().getPropertyValue((PropertyContainer)shape, "collapsedWidth") != null ? Integer.parseInt(Graphiti.getPeService().getPropertyValue((PropertyContainer)shape, "collapsedWidth")) : shape.getGraphicsAlgorithm().getWidth();
        }
        if (h == 0) {
            h = Graphiti.getPeService().getPropertyValue((PropertyContainer)shape, "collapsedHeight") != null ? Integer.parseInt(Graphiti.getPeService().getPropertyValue((PropertyContainer)shape, "collapsedHeight")) : shape.getGraphicsAlgorithm().getHeight();
        }
        for (GraphicsAlgorithm ga : shape.getGraphicsAlgorithm().getGraphicsAlgorithmChildren()) {
            if (ga instanceof Image) continue;
            if (this.isTitleKind(ga)) {
                if (Graphiti.getPeService().getPropertyValue((PropertyContainer)ga, "imgWidth") == null) continue;
                int imgWidth = Integer.parseInt(Graphiti.getPeService().getPropertyValue((PropertyContainer)ga, "imgWidth"));
                ga.setWidth(w - imgWidth - 30);
                continue;
            }
            if (this.isExpandableKind(ga)) {
                ga.setWidth(w - 3);
                if (Graphiti.getPeService().getPropertyValue((PropertyContainer)ga, "originalSectionHeight") == null) continue;
                int origHeight = Integer.parseInt(Graphiti.getPeService().getPropertyValue((PropertyContainer)ga, "originalSectionHeight"));
                ga.setHeight(h - origHeight);
                continue;
            }
            ga.setWidth(w);
        }
        if (shape.getGraphicsAlgorithm() != null) {
            Graphiti.getGaService().setLocationAndSize(shape.getGraphicsAlgorithm(), x, y, w, h);
        }
        this.layoutPictogramElement((PictogramElement)shape);
    }

    private boolean isExpandableKind(GraphicsAlgorithm ga) {
        return this.getShapeKind(ga) != null && this.getShapeKind(ga).equalsIgnoreCase("expandable");
    }

    private boolean isTitleKind(GraphicsAlgorithm ga) {
        return this.getShapeKind(ga) != null && this.getShapeKind(ga).equalsIgnoreCase("title");
    }

    private String getShapeKind(GraphicsAlgorithm ga) {
        return Graphiti.getPeService().getPropertyValue((PropertyContainer)ga, "shapeKind");
    }
}

