/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.globalconfiguration.beans;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeColumn;
import org.fusesource.ide.camel.editor.globalconfiguration.beans.BeanConfigUtil;
import org.fusesource.ide.camel.editor.internal.UIMessages;

public abstract class ArgumentStyleBaseTableControl
extends Composite {
    protected static final String[] TREE_COLUMNS = new String[]{"type", "value"};
    protected Button addButton;
    protected Button removeButton;
    protected Button editButton;
    protected boolean isReadOnly = false;
    protected String warningMsg = null;
    protected ListenerList<ChangeListener> changeListeners;
    protected TreeViewer propertyTreeTable;
    protected BeanConfigUtil beanConfigUtil = new BeanConfigUtil();

    public ArgumentStyleBaseTableControl(Composite parent, int style) {
        this(parent, style, false);
    }

    public ArgumentStyleBaseTableControl(Composite parent, int style, boolean isReadOnly) {
        super(parent, style);
        this.isReadOnly = isReadOnly;
        this.changeListeners = new ListenerList();
        int additionalStyles = isReadOnly ? 8 : 0;
        this.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(2).create());
        this.propertyTreeTable = new TreeViewer((Composite)this, 0x10A40 | style | additionalStyles);
        this.propertyTreeTable.setAutoExpandLevel(-1);
        this.propertyTreeTable.getTree().setLayoutData((Object)GridDataFactory.fillDefaults().span(1, 5).grab(true, true).hint(-1, 100).create());
        this.propertyTreeTable.getTree().setHeaderVisible(true);
        this.propertyTreeTable.getTree().setLinesVisible(true);
        TreeColumn typeColumn = new TreeColumn(this.propertyTreeTable.getTree(), 16384);
        typeColumn.setText(UIMessages.argumentStyleChildTableControlTypeColumnLabel);
        typeColumn.setWidth(200);
        TreeColumn valueColumn = new TreeColumn(this.propertyTreeTable.getTree(), 16384);
        valueColumn.setText(UIMessages.argumentStyleChildTableControlValueColumnLabel);
        valueColumn.setWidth(200);
        this.propertyTreeTable.setColumnProperties(TREE_COLUMNS);
        this.propertyTreeTable.setLabelProvider((IBaseLabelProvider)this.getTableLabelProvider());
        this.propertyTreeTable.setContentProvider((IContentProvider)this.getTableContentProvider());
        CellEditor[] cellEditorArray = new CellEditor[3];
        cellEditorArray[0] = new TextCellEditor((Composite)this.propertyTreeTable.getTree());
        cellEditorArray[1] = new TextCellEditor((Composite)this.propertyTreeTable.getTree());
        this.propertyTreeTable.setCellEditors(cellEditorArray);
        this.addButton = new Button((Composite)this, 0);
        this.addButton.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.addButton.setText(UIMessages.argumentStyleChildTableControlAddButtonLabel);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArgumentStyleBaseTableControl.this.addArgumentTypeToList();
                ArgumentStyleBaseTableControl.this.propertyTreeTable.refresh();
                ArgumentStyleBaseTableControl.this.updateArgumentTypeButtons();
                ArgumentStyleBaseTableControl.this.fireChangedEvent(e.getSource());
            }
        });
        this.addButton.setEnabled(false);
        this.editButton = new Button((Composite)this, 0);
        this.editButton.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.editButton.setText(UIMessages.argumentStyleChildTableControlEditButtonLabel);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArgumentStyleBaseTableControl.this.editArgumentType();
                ArgumentStyleBaseTableControl.this.propertyTreeTable.refresh();
                ArgumentStyleBaseTableControl.this.updateArgumentTypeButtons();
                ArgumentStyleBaseTableControl.this.fireChangedEvent(e.getSource());
            }
        });
        this.editButton.setEnabled(false);
        this.propertyTreeTable.addDoubleClickListener(e -> {
            this.editArgumentType();
            this.propertyTreeTable.refresh();
            this.updateArgumentTypeButtons();
            this.fireChangedEvent(e.getSource());
        });
        this.propertyTreeTable.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArgumentStyleBaseTableControl.this.updateArgumentTypeButtons();
            }
        });
        this.removeButton = new Button((Composite)this, 0);
        this.removeButton.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.removeButton.setText(UIMessages.argumentStyleChildTableControlRemoveButtonLabel);
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArgumentStyleBaseTableControl.this.removeArgumentFromList();
                ArgumentStyleBaseTableControl.this.propertyTreeTable.refresh();
                ArgumentStyleBaseTableControl.this.updateArgumentTypeButtons();
                ArgumentStyleBaseTableControl.this.fireChangedEvent(e.getSource());
            }
        });
    }

    protected void fireChangedEvent(Object source) {
        ChangeEvent e = new ChangeEvent(source);
        Object[] listeners = this.changeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ChangeListener)listeners[i]).stateChanged(e);
            ++i;
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add((Object)listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.remove((Object)listener);
    }

    public void updateArgumentTypeButtons() {
        if (this.isReadOnly) {
            this.addButton.setEnabled(false);
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        } else {
            this.addButton.setEnabled(true);
            boolean enable = this.getStructuredSelection() != null && !this.getStructuredSelection().isEmpty();
            this.editButton.setEnabled(enable);
            this.removeButton.setEnabled(enable);
        }
    }

    public IStructuredSelection getStructuredSelection() {
        if (this.propertyTreeTable != null && !this.propertyTreeTable.getSelection().isEmpty()) {
            return (IStructuredSelection)this.propertyTreeTable.getSelection();
        }
        return null;
    }

    public String getWarning() {
        return this.warningMsg;
    }

    protected abstract void removeArgumentFromList();

    protected abstract void addArgumentTypeToList();

    protected abstract void editArgumentType();

    protected abstract void addBeanArgument(String var1, String var2);

    protected abstract ITableLabelProvider getTableLabelProvider();

    protected abstract ITreeContentProvider getTableContentProvider();
}

