/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.globalconfiguration.beans;

import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.fusesource.ide.camel.editor.globalconfiguration.beans.ArgumentInputDialog;
import org.fusesource.ide.camel.editor.globalconfiguration.beans.ArgumentStyleBaseTableControl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ArgumentXMLStyleChildTableControl
extends ArgumentStyleBaseTableControl {
    private Element inputElement;

    public ArgumentXMLStyleChildTableControl(Composite parent, int style) {
        this(parent, style, false);
    }

    public ArgumentXMLStyleChildTableControl(Composite parent, int style, boolean isReadOnly) {
        super(parent, style, isReadOnly);
        this.propertyTreeTable.setInput((Object)this.inputElement);
        this.updateArgumentTypeButtons();
    }

    @Override
    protected void removeArgumentFromList() {
        if (!this.getStructuredSelection().isEmpty()) {
            Element selectedProperty = (Element)this.getStructuredSelection().getFirstElement();
            this.inputElement.removeChild(selectedProperty);
        }
    }

    @Override
    protected void addArgumentTypeToList() {
        ArgumentInputDialog dialog = new ArgumentInputDialog(Display.getCurrent().getActiveShell());
        int rtnValue = dialog.open();
        if (rtnValue == 0) {
            String type = dialog.getArgumentType();
            String value = dialog.getArgumentValue();
            this.addBeanArgument(type, value);
        }
    }

    @Override
    protected void editArgumentType() {
        if (!this.getStructuredSelection().isEmpty()) {
            int rtnValue;
            Element selectedProperty = (Element)this.getStructuredSelection().getFirstElement();
            ArgumentInputDialog dialog = new ArgumentInputDialog(Display.getCurrent().getActiveShell());
            Element xmlElement = selectedProperty;
            if (xmlElement.getAttribute("type") != null) {
                dialog.setArgumentType(xmlElement.getAttribute("type"));
            }
            if (xmlElement.getAttribute("value") != null) {
                dialog.setArgumentValue(xmlElement.getAttribute("value"));
            }
            if ((rtnValue = dialog.open()) == 0) {
                String type = dialog.getArgumentType();
                String value = dialog.getArgumentValue();
                this.beanConfigUtil.editBeanArgument(xmlElement, type, value);
            }
        }
    }

    public void setInput(Element input) {
        this.inputElement = input;
        if (this.propertyTreeTable != null && !this.propertyTreeTable.getControl().isDisposed()) {
            this.propertyTreeTable.setInput((Object)this.inputElement);
        }
    }

    @Override
    protected void addBeanArgument(String type, String value) {
        Element propertyNode = this.beanConfigUtil.createBeanArgument(this.inputElement, type, value);
        this.inputElement.appendChild(propertyNode);
    }

    @Override
    protected ITableLabelProvider getTableLabelProvider() {
        return new ArgumentTypeTreeLabelProvider();
    }

    @Override
    protected ITreeContentProvider getTableContentProvider() {
        return new ArgumentTypeTreeContentProvider();
    }

    private class ArgumentTypeTreeContentProvider
    implements ITreeContentProvider {
        private ArgumentTypeTreeContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Element) {
                Element parent = (Element)inputElement;
                String tagName = ArgumentXMLStyleChildTableControl.this.beanConfigUtil.getArgumentTag(parent);
                return this.convertToArray(parent.getElementsByTagName(tagName));
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            return this.getElements(parentElement);
        }

        public Object getParent(Object element) {
            if (element instanceof Element) {
                return ((Element)element).getParentNode();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof Element) {
                return ((Element)element).hasChildNodes();
            }
            return false;
        }

        private Object[] convertToArray(NodeList list) {
            int length = list.getLength();
            Object[] copy = new Node[length];
            int n = 0;
            while (n < length) {
                copy[n] = list.item(n);
                ++n;
            }
            return copy;
        }
    }

    private class ArgumentTypeTreeLabelProvider
    implements ITableLabelProvider {
        private ArgumentTypeTreeLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return element instanceof Element && (property.equalsIgnoreCase("type") || property.equalsIgnoreCase("value"));
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Element && columnIndex == 0) {
                Element xmlElement = (Element)element;
                return xmlElement.getAttribute("type");
            }
            if (element instanceof Element && columnIndex == 1) {
                Element xmlElement = (Element)element;
                return xmlElement.getAttribute("value");
            }
            return null;
        }
    }
}

