/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.globalconfiguration.beans;

import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.fusesource.ide.camel.editor.internal.UIMessages;
import org.fusesource.ide.foundation.ui.util.Selections;

public class MethodSelectionDialog
extends TitleAreaDialog {
    private ILabelProvider labelProvider;
    private Object[] elementArray;
    private String message = "";
    private String title = "";
    private Object selection = null;

    public MethodSelectionDialog(Shell parent, ILabelProvider renderer) {
        super(parent);
        this.labelProvider = renderer;
    }

    public MethodSelectionDialog(Shell parent) {
        this(parent, (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT));
    }

    protected Control createDialogArea(Composite parent) {
        super.setTitle(this.title);
        super.setMessage(this.message);
        Composite area = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        area.setLayout((Layout)gridLayout);
        area.setLayoutData((Object)new GridData(1808));
        FilteredTree elementTable = new FilteredTree(area, 67588, (PatternFilter)new LocalPatternFilter(), true);
        TreeViewer treeViewer = elementTable.getViewer();
        treeViewer.getControl().setLayoutData((Object)new GridData(1808));
        treeViewer.setContentProvider((IContentProvider)new MethodTreeContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        elementTable.getFilterControl().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                MethodSelectionDialog.this.getButton(0).setEnabled(MethodSelectionDialog.this.validate());
            }
        });
        elementTable.getFilterControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                MethodSelectionDialog.this.getButton(0).setEnabled(MethodSelectionDialog.this.validate());
            }
        });
        treeViewer.addPostSelectionChangedListener(input -> {
            this.selection = !elementTable.getViewer().getSelection().isEmpty() ? Selections.getFirstSelection((ISelection)elementTable.getViewer().getSelection()) : null;
            this.getButton(0).setEnabled(this.validate());
        });
        treeViewer.addDoubleClickListener(input -> {
            if (!elementTable.getViewer().getSelection().isEmpty()) {
                this.selection = Selections.getFirstSelection((ISelection)elementTable.getViewer().getSelection());
                this.setReturnCode(0);
            } else {
                this.selection = null;
                this.setReturnCode(1);
            }
            this.close();
        });
        treeViewer.setInput((Object)this.elementArray);
        if (this.elementArray == null || this.elementArray.length == 0) {
            super.setMessage(UIMessages.beanConfigUtilNoMethodsAvailable, 3);
            treeViewer.getTree().setEnabled(false);
            elementTable.getFilterControl().setEnabled(false);
        }
        return area;
    }

    public void setElements(Object[] elements) {
        this.elementArray = elements;
    }

    public Object getFirstResult() {
        return this.selection;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control rtnControl = super.createButtonBar(parent);
        this.getButton(0).setEnabled(this.validate());
        this.setErrorMessage(null);
        return rtnControl;
    }

    private boolean validate() {
        this.setErrorMessage(null);
        if (this.elementArray == null || this.elementArray.length == 0) {
            this.setErrorMessage(UIMessages.beanConfigUtilNoMethodsAvailable);
        } else if (this.getFirstResult() == null) {
            this.setErrorMessage(UIMessages.methodSelectionDialogNoMethodSelectedError);
        }
        return this.getErrorMessage() == null;
    }

    class LocalPatternFilter
    extends PatternFilter {
        LocalPatternFilter() {
        }

        protected boolean isLeafMatch(Viewer viewer, Object element) {
            String labelText = ((ILabelProvider)((StructuredViewer)viewer).getLabelProvider()).getText(element);
            if (labelText == null) {
                return false;
            }
            return this.wordMatches(labelText);
        }
    }

    class MethodTreeContentProvider
    implements ITreeContentProvider {
        MethodTreeContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return MethodSelectionDialog.this.elementArray;
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }
}

