/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.globalconfiguration.dataformat.provider;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.fusesource.ide.camel.editor.globalconfiguration.dataformat.wizards.NewDataFormatWizard;
import org.fusesource.ide.camel.editor.provider.ext.GlobalConfigElementType;
import org.fusesource.ide.camel.editor.provider.ext.GlobalConfigurationTypeWizard;
import org.fusesource.ide.camel.editor.provider.ext.ICustomGlobalConfigElementContribution;
import org.fusesource.ide.camel.model.service.core.catalog.Dependency;
import org.fusesource.ide.camel.model.service.core.catalog.cache.CamelCatalogCacheManager;
import org.fusesource.ide.camel.model.service.core.catalog.cache.CamelModel;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelFile;
import org.fusesource.ide.foundation.core.util.CamelUtils;
import org.w3c.dom.Node;

public class DataFormatContributor
implements ICustomGlobalConfigElementContribution {
    @Override
    public GlobalConfigurationTypeWizard createGlobalElement(CamelFile camelFile) {
        IProject project = camelFile.getResource().getProject();
        CamelModel model = CamelCatalogCacheManager.getInstance().getCamelModelForProject(project);
        return new NewDataFormatWizard(camelFile, model);
    }

    @Override
    public GlobalConfigurationTypeWizard modifyGlobalElement(CamelFile camelFile) {
        return null;
    }

    @Override
    public List<Dependency> getElementDependencies() {
        return Collections.emptyList();
    }

    @Override
    public void onGlobalElementDeleted(AbstractCamelModelElement cme) {
    }

    @Override
    public boolean canHandle(AbstractCamelModelElement camelModelElementToHandle) {
        Node nodeToHandle = camelModelElementToHandle.getXmlNode();
        if ("dataformats".equalsIgnoreCase(CamelUtils.getTagNameWithoutPrefix((Node)nodeToHandle.getParentNode()))) {
            String nodeName = CamelUtils.getTagNameWithoutPrefix((Node)nodeToHandle);
            IProject project = camelModelElementToHandle.getCamelFile().getResource().getProject();
            CamelModel model = CamelCatalogCacheManager.getInstance().getCamelModelForProject(project);
            return !model.getDataFormatsByModelName(nodeName).isEmpty();
        }
        return false;
    }

    @Override
    public GlobalConfigElementType getGlobalConfigElementType() {
        return GlobalConfigElementType.CONTEXT_DATAFORMAT;
    }
}

