/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.fusesource.ide.camel.editor.properties.FusePropertySection;
import org.fusesource.ide.camel.editor.properties.ParameterPriorityComparator;
import org.fusesource.ide.camel.editor.properties.creators.advanced.BooleanParameterPropertyUICreatorForAdvanced;
import org.fusesource.ide.camel.editor.properties.creators.advanced.FileParameterPropertyUICreatorForAdvanced;
import org.fusesource.ide.camel.editor.properties.creators.advanced.NumberParameterPropertyUICreatorForAdvanced;
import org.fusesource.ide.camel.editor.properties.creators.advanced.TextParameterPropertyUICreatorForAdvanced;
import org.fusesource.ide.camel.editor.properties.creators.advanced.UnsupportedParameterPropertyUICreatorForAdvanced;
import org.fusesource.ide.camel.model.service.core.catalog.Parameter;
import org.fusesource.ide.camel.model.service.core.catalog.UriParameterKind;
import org.fusesource.ide.camel.model.service.core.catalog.components.Component;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.util.CamelComponentUtils;
import org.fusesource.ide.camel.model.service.core.util.PropertiesUtils;
import org.fusesource.ide.foundation.core.util.Strings;

public class AdvancedEndpointPropertiesSection
extends FusePropertySection {
    @Override
    protected void createContentTabs(CTabFolder folder) {
        List props = PropertiesUtils.getComponentPropertiesFor((AbstractCamelModelElement)this.selectedEP);
        if (props.isEmpty()) {
            return;
        }
        List<String> tabsToCreate = this.computeTabsToCreate(props);
        props.sort(new ParameterPriorityComparator());
        for (String group : tabsToCreate) {
            CTabItem contentTab = new CTabItem(this.tabFolder, 0);
            contentTab.setText(Strings.humanize((String)group));
            Composite page = this.toolkit.createComposite((Composite)folder);
            page.setLayout((Layout)new GridLayout(4, false));
            if ("Path".equalsIgnoreCase(group)) {
                this.generateTabContents(PropertiesUtils.getPathProperties((AbstractCamelModelElement)this.selectedEP), page, false, group);
            } else {
                this.generateTabContents(props, page, true, group);
            }
            contentTab.setControl((Control)page);
            this.tabs.add(contentTab);
        }
    }

    List<String> computeTabsToCreate(List<Parameter> props) {
        ArrayList<String> tabsToCreate = new ArrayList<String>();
        tabsToCreate.add("Path");
        if (this.shouldCreateTabsForKind(UriParameterKind.BOTH)) {
            tabsToCreate.add("Common");
        }
        if (this.shouldCreateTabsForKind(UriParameterKind.CONSUMER)) {
            tabsToCreate.add("Consumer");
        }
        if (this.shouldCreateTabsForKind(UriParameterKind.PRODUCER)) {
            tabsToCreate.add("Producer");
        }
        for (Parameter p : props) {
            String parameterGroup = p.getGroup();
            if (parameterGroup == null || parameterGroup.trim().length() <= 0 || tabsToCreate.contains(parameterGroup)) continue;
            tabsToCreate.add(parameterGroup);
        }
        return tabsToCreate;
    }

    private boolean shouldCreateTabsForKind(UriParameterKind parameterKind) {
        List commonProps = PropertiesUtils.getPropertiesFor((AbstractCamelModelElement)this.selectedEP, (UriParameterKind)parameterKind);
        return commonProps.parallelStream().filter(p -> p.getGroup() == null || p.getGroup().trim().length() < 1).findFirst().isPresent();
    }

    protected void generateTabContents(List<Parameter> props, Composite page, boolean ignorePathProperties, String group) {
        props.sort(new ParameterPriorityComparator());
        for (final Parameter p : props) {
            Text txtField;
            final Parameter prop = p;
            if (!this.shouldBeDisplayed(prop, group, ignorePathProperties)) continue;
            ISWTObservableValue uiObservable = null;
            Object validator = null;
            this.createPropertyLabel(this.toolkit, page, p);
            Text c = null;
            if (CamelComponentUtils.isBooleanProperty((Parameter)prop)) {
                new BooleanParameterPropertyUICreatorForAdvanced(this.dbc, this.modelMap, this.eip, this.selectedEP, p, page, this.getWidgetFactory()).create();
            } else if (CamelComponentUtils.isTextProperty((Parameter)prop) || CamelComponentUtils.isCharProperty((Parameter)prop)) {
                new TextParameterPropertyUICreatorForAdvanced(this.dbc, this.modelMap, this.eip, this.selectedEP, p, page, this.getWidgetFactory()).create();
            } else if (CamelComponentUtils.isNumberProperty((Parameter)prop)) {
                new NumberParameterPropertyUICreatorForAdvanced(this.dbc, this.modelMap, this.eip, this.selectedEP, prop, page, this.getWidgetFactory()).create();
            } else if (CamelComponentUtils.isChoiceProperty((Parameter)prop)) {
                CCombo choiceCombo = new CCombo(page, 0x80080C);
                this.toolkit.adapt((Control)choiceCombo, true, true);
                choiceCombo.setEditable(false);
                choiceCombo.setItems(CamelComponentUtils.getChoicesWithExtraEmptyEntry((Parameter)prop));
                String selectedValue = PropertiesUtils.getPropertyFromUri((AbstractCamelModelElement)this.selectedEP, (Parameter)prop, (Component)this.component);
                int i = 0;
                while (i < choiceCombo.getItems().length) {
                    if (selectedValue != null && choiceCombo.getItem(i).equalsIgnoreCase(selectedValue)) {
                        choiceCombo.select(i);
                        break;
                    }
                    if (selectedValue == null && p.getDefaultValue() != null && choiceCombo.getItem(i).equalsIgnoreCase(p.getDefaultValue())) {
                        choiceCombo.select(i);
                        break;
                    }
                    ++i;
                }
                choiceCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        CCombo choice = (CCombo)e.getSource();
                        String newValue = choice.getText();
                        PropertiesUtils.updateURIParams((AbstractCamelModelElement)AdvancedEndpointPropertiesSection.this.selectedEP, (Parameter)prop, (Object)newValue, (Component)AdvancedEndpointPropertiesSection.this.component, (IObservableMap)AdvancedEndpointPropertiesSection.this.modelMap);
                        if ("languageName".equalsIgnoreCase(p.getName())) {
                            AdvancedEndpointPropertiesSection.this.updateDependenciesForLanguage(AdvancedEndpointPropertiesSection.this.selectedEP, newValue);
                        }
                    }
                });
                choiceCombo.setLayoutData((Object)this.createPropertyFieldLayoutData());
                c = choiceCombo;
                this.modelMap.put((Object)p.getName(), (Object)choiceCombo.getText());
                uiObservable = WidgetProperties.selection().observe((Widget)choiceCombo);
                if (PropertiesUtils.isRequired((Parameter)p)) {
                    validator = new IValidator(){

                        public IStatus validate(Object value) {
                            if (value != null && value instanceof String && value.toString().trim().length() > 0) {
                                return ValidationStatus.ok();
                            }
                            return ValidationStatus.error((String)("Parameter " + prop.getName() + " is a mandatory field and cannot be empty."));
                        }
                    };
                }
            } else if (CamelComponentUtils.isFileProperty((Parameter)prop)) {
                new FileParameterPropertyUICreatorForAdvanced(this.dbc, this.modelMap, this.eip, this.selectedEP, p, page, this.getWidgetFactory()).create();
            } else if (CamelComponentUtils.isExpressionProperty((Parameter)prop)) {
                txtField = this.toolkit.createText(page, PropertiesUtils.getPropertyFromUri((AbstractCamelModelElement)this.selectedEP, (Parameter)prop, (Component)this.component), 18436);
                txtField.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        Text txt = (Text)e.getSource();
                        PropertiesUtils.updateURIParams((AbstractCamelModelElement)AdvancedEndpointPropertiesSection.this.selectedEP, (Parameter)prop, (Object)txt.getText(), (Component)AdvancedEndpointPropertiesSection.this.component, (IObservableMap)AdvancedEndpointPropertiesSection.this.modelMap);
                    }
                });
                txtField.setLayoutData((Object)this.createPropertyFieldLayoutData());
                c = txtField;
                if (PropertiesUtils.isRequired((Parameter)p)) {
                    validator = new IValidator(){

                        public IStatus validate(Object value) {
                            if (value != null && value instanceof String && value.toString().trim().length() > 0) {
                                return ValidationStatus.ok();
                            }
                            return ValidationStatus.error((String)("Parameter " + prop.getName() + " is a mandatory field and cannot be empty."));
                        }
                    };
                }
                this.modelMap.put((Object)p.getName(), (Object)txtField.getText());
                uiObservable = WidgetProperties.text((int)24).observe((Widget)txtField);
            } else if (CamelComponentUtils.isDataFormatProperty((Parameter)prop)) {
                txtField = this.toolkit.createText(page, PropertiesUtils.getPropertyFromUri((AbstractCamelModelElement)this.selectedEP, (Parameter)prop, (Component)this.component), 18436);
                txtField.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        Text txt = (Text)e.getSource();
                        String newValue = txt.getText();
                        PropertiesUtils.updateURIParams((AbstractCamelModelElement)AdvancedEndpointPropertiesSection.this.selectedEP, (Parameter)prop, (Object)newValue, (Component)AdvancedEndpointPropertiesSection.this.component, (IObservableMap)AdvancedEndpointPropertiesSection.this.modelMap);
                        AdvancedEndpointPropertiesSection.this.updateDependenciesForDataFormat(AdvancedEndpointPropertiesSection.this.selectedEP, newValue);
                    }
                });
                txtField.setLayoutData((Object)this.createPropertyFieldLayoutData());
                c = txtField;
                if (PropertiesUtils.isRequired((Parameter)p)) {
                    validator = new IValidator(){

                        public IStatus validate(Object value) {
                            if (value != null && value instanceof String && value.toString().trim().length() > 0) {
                                return ValidationStatus.ok();
                            }
                            return ValidationStatus.error((String)("Parameter " + prop.getName() + " is a mandatory field and cannot be empty."));
                        }
                    };
                }
                this.modelMap.put((Object)p.getName(), (Object)txtField.getText());
                uiObservable = WidgetProperties.text((int)24).observe((Widget)txtField);
            } else if (CamelComponentUtils.isUnsupportedProperty((Parameter)prop)) {
                new UnsupportedParameterPropertyUICreatorForAdvanced(this.dbc, this.modelMap, this.eip, this.selectedEP, p, page, this.getWidgetFactory()).create();
            } else {
                new TextParameterPropertyUICreatorForAdvanced(this.dbc, this.modelMap, this.eip, this.selectedEP, p, page, this.getWidgetFactory()).create();
            }
            if (uiObservable == null) continue;
            UpdateValueStrategy strategy = new UpdateValueStrategy();
            strategy.setBeforeSetValidator(validator);
            IObservableValue modelObservable = Observables.observeMapEntry((IObservableMap)this.modelMap, (Object)p.getName());
            Binding bindValue = this.dbc.bindValue(uiObservable, modelObservable, strategy, null);
            ControlDecorationSupport.create((ValidationStatusProvider)bindValue, (int)16512);
            if (p.getDescription() == null) continue;
            c.setToolTipText(p.getDescription());
        }
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        super.createControls(parent, aTabbedPropertySheetPage);
        this.createStandardTabLayout("Advanced Properties");
    }

    private boolean shouldBeDisplayed(Parameter prop, String group, boolean ignorePathProperties) {
        if (ignorePathProperties && "path".equalsIgnoreCase(prop.getKind())) {
            return false;
        }
        if (CamelComponentUtils.isClassProperty((Parameter)prop) && "element".equalsIgnoreCase(prop.getKind())) {
            return false;
        }
        if (prop.getGroup() != null && prop.getGroup().trim().length() > 0) {
            if (!group.equalsIgnoreCase(prop.getGroup()) && !"Path".equalsIgnoreCase(prop.getKind())) {
                return false;
            }
        } else if (!"Path".equalsIgnoreCase(prop.getKind()) || !"Path".equalsIgnoreCase(group)) {
            if (prop.getLabel() != null && !PropertiesUtils.containsLabel((String)group, (Parameter)prop)) {
                return false;
            }
            if (prop.getLabel() == null && !"Common".equalsIgnoreCase(group)) {
                return false;
            }
        }
        return true;
    }
}

