/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.properties.bean;

import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.fusesource.ide.camel.editor.globalconfiguration.beans.BeanConfigUtil;
import org.fusesource.ide.camel.editor.internal.CamelEditorUIActivator;
import org.fusesource.ide.camel.editor.internal.UIMessages;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.foundation.core.util.Strings;

public class PropertyMethodValidator
implements IValidator {
    private IObservableMap<?, ?> modelMap;
    private BeanConfigUtil beanConfigUtil = new BeanConfigUtil();
    private IProject project;
    private String factoryBeanTag = null;
    private AbstractCamelModelElement parent = null;
    private IJavaProject jproject;

    public PropertyMethodValidator(IObservableMap<?, ?> modelMap, IProject project) {
        this.modelMap = modelMap;
        this.project = project;
        this.jproject = this.beanConfigUtil.getJavaProject(this.project);
    }

    public PropertyMethodValidator(IObservableMap<?, ?> modelMap, IProject project, AbstractCamelModelElement element) {
        this(modelMap, project);
        this.parent = element;
        this.factoryBeanTag = this.beanConfigUtil.getFactoryBeanTag(element.getXmlNode());
    }

    public IStatus validate(Object value) {
        Object control = this.modelMap.get((Object)"class");
        if (control != null) {
            String methodName;
            String className = (String)control;
            String referencedClassName = null;
            if (Strings.isEmpty((String)className) && !Strings.isEmpty((String)this.factoryBeanTag)) {
                String beanRefId = (String)this.modelMap.get((Object)this.factoryBeanTag);
                referencedClassName = this.beanConfigUtil.getClassNameFromReferencedCamelBean(this.parent, beanRefId);
            }
            if (!(Strings.isEmpty((String)(methodName = (String)value)) || Strings.isEmpty((String)className) && Strings.isEmpty(referencedClassName) || this.jproject == null)) {
                if (!Strings.isEmpty((String)className)) {
                    return this.validateWrapper(className, methodName);
                }
                if (!Strings.isEmpty(referencedClassName)) {
                    return this.validateWrapper(referencedClassName, methodName);
                }
            }
        }
        return ValidationStatus.ok();
    }

    private IStatus validateWrapper(String className, String methodName) {
        try {
            return this.validateMethod(className, methodName);
        }
        catch (JavaModelException e) {
            CamelEditorUIActivator.pluginLog().logError(String.valueOf(UIMessages.propertyMethodValidatorMethodValidationError) + className, (Throwable)e);
            return ValidationStatus.ok();
        }
    }

    private IStatus validateMethod(String className, String methodName) throws JavaModelException {
        IType foundClass = this.jproject.findType(className);
        boolean foundMethod = this.beanConfigUtil.hasMethod(methodName, foundClass);
        if (!foundMethod) {
            return ValidationStatus.error((String)(String.valueOf(UIMessages.propertyMethodValidatorMethodValidatorErrorPt2) + methodName + UIMessages.propertyMethodValidatorMethodValidatorErrorPt3 + className + "."));
        }
        return ValidationStatus.ok();
    }
}

