/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.provider;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.fusesource.ide.camel.editor.features.create.ext.CreateFigureFeature;
import org.fusesource.ide.camel.editor.provider.ImageProvider;
import org.fusesource.ide.camel.editor.utils.CamelUtils;
import org.fusesource.ide.camel.model.service.core.catalog.cache.CamelCatalogCacheManager;
import org.fusesource.ide.camel.model.service.core.catalog.cache.CamelModel;
import org.fusesource.ide.camel.model.service.core.catalog.eips.Eip;

public class ProviderHelper {
    public static final String CATEGORY_CONTROL_FLOW = "Control Flow";
    public static final String CATEGORY_ROUTING = "Routing";
    public static final String CATEGORY_MISC = "Miscellaneous";
    public static final String CATEGORY_COMPONENTS = "Components";
    public static final String CATEGORY_TRANSFORMATION = "Transformation";
    private static final HashMap<String, String> categoryMap = new HashMap();

    static {
        categoryMap.put("aggregate", CATEGORY_ROUTING);
        categoryMap.put("aop", CATEGORY_MISC);
        categoryMap.put("bean", CATEGORY_COMPONENTS);
        categoryMap.put("choice", CATEGORY_ROUTING);
        categoryMap.put("convertBodyTo", CATEGORY_TRANSFORMATION);
        categoryMap.put("delay", CATEGORY_CONTROL_FLOW);
        categoryMap.put("doCatch", CATEGORY_CONTROL_FLOW);
        categoryMap.put("doFinally", CATEGORY_CONTROL_FLOW);
        categoryMap.put("enrich", CATEGORY_TRANSFORMATION);
        categoryMap.put("filter", CATEGORY_ROUTING);
        categoryMap.put("hystrix", CATEGORY_ROUTING);
        categoryMap.put("idempotentConsumer", CATEGORY_ROUTING);
        categoryMap.put("inOnly", CATEGORY_TRANSFORMATION);
        categoryMap.put("inOut", CATEGORY_TRANSFORMATION);
        categoryMap.put("intercept", CATEGORY_CONTROL_FLOW);
        categoryMap.put("interceptFrom", CATEGORY_CONTROL_FLOW);
        categoryMap.put("interceptSendToEndpoint", CATEGORY_CONTROL_FLOW);
        categoryMap.put("loadBalance", CATEGORY_ROUTING);
        categoryMap.put("loop", CATEGORY_CONTROL_FLOW);
        categoryMap.put("log", CATEGORY_COMPONENTS);
        categoryMap.put("marshal", CATEGORY_TRANSFORMATION);
        categoryMap.put("multicast", CATEGORY_ROUTING);
        categoryMap.put("onCompletion", CATEGORY_CONTROL_FLOW);
        categoryMap.put("onException", CATEGORY_CONTROL_FLOW);
        categoryMap.put("onFallback", CATEGORY_CONTROL_FLOW);
        categoryMap.put("otherwise", CATEGORY_ROUTING);
        categoryMap.put("pipeline", CATEGORY_ROUTING);
        categoryMap.put("policy", CATEGORY_MISC);
        categoryMap.put("pollEnrich", CATEGORY_TRANSFORMATION);
        categoryMap.put("process", CATEGORY_COMPONENTS);
        categoryMap.put("recipientList", CATEGORY_ROUTING);
        categoryMap.put("removeHeader", CATEGORY_TRANSFORMATION);
        categoryMap.put("removeHeaders", CATEGORY_TRANSFORMATION);
        categoryMap.put("removeProperty", CATEGORY_TRANSFORMATION);
        categoryMap.put("removeProperties", CATEGORY_TRANSFORMATION);
        categoryMap.put("resequence", CATEGORY_ROUTING);
        categoryMap.put("rollback", CATEGORY_CONTROL_FLOW);
        categoryMap.put("route", CATEGORY_ROUTING);
        categoryMap.put("routingSlip", CATEGORY_ROUTING);
        categoryMap.put("sample", CATEGORY_MISC);
        categoryMap.put("setBody", CATEGORY_TRANSFORMATION);
        categoryMap.put("setExchangePattern", CATEGORY_TRANSFORMATION);
        categoryMap.put("setFaultBody", CATEGORY_TRANSFORMATION);
        categoryMap.put("setHeader", CATEGORY_TRANSFORMATION);
        categoryMap.put("setOutHeader", CATEGORY_TRANSFORMATION);
        categoryMap.put("setProperty", CATEGORY_TRANSFORMATION);
        categoryMap.put("sort", CATEGORY_ROUTING);
        categoryMap.put("split", CATEGORY_ROUTING);
        categoryMap.put("stop", CATEGORY_MISC);
        categoryMap.put("threads", CATEGORY_MISC);
        categoryMap.put("throttle", CATEGORY_CONTROL_FLOW);
        categoryMap.put("throwException", CATEGORY_CONTROL_FLOW);
        categoryMap.put("transacted", CATEGORY_CONTROL_FLOW);
        categoryMap.put("transform", CATEGORY_TRANSFORMATION);
        categoryMap.put("doTry", CATEGORY_CONTROL_FLOW);
        categoryMap.put("unmarshal", CATEGORY_TRANSFORMATION);
        categoryMap.put("validate", CATEGORY_MISC);
        categoryMap.put("when", CATEGORY_ROUTING);
        categoryMap.put("wireTap", CATEGORY_ROUTING);
    }

    private ProviderHelper() {
    }

    protected static String convertCamelCase(String original) {
        String display = original.replaceAll("(\\p{Ll})(\\p{Lu})", "$1 $2");
        return ProviderHelper.capitalizeFirstLetter(display);
    }

    protected static String capitalizeFirstLetter(String input) {
        return String.valueOf(input.substring(0, 1).toUpperCase()) + input.substring(1);
    }

    public static ICreateFeature[] getCreateFeatures(IFeatureProvider fp) {
        CamelModel model = CamelCatalogCacheManager.getInstance().getCamelModelForProject(CamelUtils.project(fp), (IProgressMonitor)new NullProgressMonitor());
        Collection list = model.getEips();
        return (ICreateFeature[])list.stream().map(eip -> new CreateFigureFeature(fp, ProviderHelper.convertCamelCase(eip.getName()), eip.getDescription(), (Eip)eip)).toArray(ICreateFeature[]::new);
    }

    public static void addFigureIcons(ImageProvider imageProvider) {
        CamelModel model = CamelCatalogCacheManager.getInstance().getCamelModelForProject(CamelUtils.project(), (IProgressMonitor)new NullProgressMonitor());
        model.getEips().forEach(imageProvider::addIconsForEIP);
    }

    public static String getCategoryFromTags(List<String> tags) {
        return tags.get(0);
    }

    public static String getCategoryFromEip(Eip eip) {
        if (categoryMap.containsKey(eip.getName())) {
            return categoryMap.get(eip.getName());
        }
        return "NONE";
    }
}

