/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IDoubleClickContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.context.impl.CreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.CustomContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.LineStyle;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.palette.IPaletteCompartmentEntry;
import org.eclipse.graphiti.palette.IPaletteEntry;
import org.eclipse.graphiti.palette.IToolEntry;
import org.eclipse.graphiti.palette.impl.ObjectCreationToolEntry;
import org.eclipse.graphiti.palette.impl.PaletteCompartmentEntry;
import org.eclipse.graphiti.platform.IDiagramContainer;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.tb.ContextButtonEntry;
import org.eclipse.graphiti.tb.ContextMenuEntry;
import org.eclipse.graphiti.tb.DefaultToolBehaviorProvider;
import org.eclipse.graphiti.tb.IContextButtonEntry;
import org.eclipse.graphiti.tb.IContextButtonPadData;
import org.eclipse.graphiti.tb.IContextMenuEntry;
import org.eclipse.graphiti.tb.IDecorator;
import org.eclipse.graphiti.tb.IShapeSelectionInfo;
import org.eclipse.graphiti.tb.ImageDecorator;
import org.eclipse.graphiti.tb.ShapeSelectionInfoImpl;
import org.fusesource.ide.camel.editor.CamelDesignEditor;
import org.fusesource.ide.camel.editor.features.create.ext.CreateConnectorFigureFeature;
import org.fusesource.ide.camel.editor.features.create.ext.CreateFigureFeature;
import org.fusesource.ide.camel.editor.features.custom.CollapseFeature;
import org.fusesource.ide.camel.editor.features.custom.DeleteAllEndpointBreakpointsFeature;
import org.fusesource.ide.camel.editor.features.custom.DoubleClickFeature;
import org.fusesource.ide.camel.editor.features.custom.GoIntoContainerFeature;
import org.fusesource.ide.camel.editor.features.custom.SetEndpointBreakpointFeature;
import org.fusesource.ide.camel.editor.internal.CamelEditorUIActivator;
import org.fusesource.ide.camel.editor.internal.UIMessages;
import org.fusesource.ide.camel.editor.provider.ProviderHelper;
import org.fusesource.ide.camel.editor.provider.ext.ICustomPaletteEntry;
import org.fusesource.ide.camel.editor.provider.ext.PaletteCategoryItemProvider;
import org.fusesource.ide.camel.editor.utils.CamelUtils;
import org.fusesource.ide.camel.editor.utils.StyleUtil;
import org.fusesource.ide.camel.model.service.core.catalog.cache.CamelCatalogCacheManager;
import org.fusesource.ide.camel.model.service.core.catalog.cache.CamelModel;
import org.fusesource.ide.camel.model.service.core.catalog.components.Component;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelElementConnection;
import org.fusesource.ide.camel.model.service.core.model.CamelRouteElement;
import org.fusesource.ide.camel.model.service.core.util.CamelCatalogUtils;
import org.fusesource.ide.camel.validation.ValidationFactory;
import org.fusesource.ide.camel.validation.ValidationResult;
import org.fusesource.ide.foundation.core.util.Objects;
import org.fusesource.ide.foundation.core.util.Strings;
import org.fusesource.ide.launcher.debug.model.CamelConditionalBreakpoint;
import org.fusesource.ide.launcher.debug.model.CamelEndpointBreakpoint;
import org.fusesource.ide.launcher.debug.util.CamelDebugUtils;

public class ToolBehaviourProvider
extends DefaultToolBehaviorProvider {
    public static final String PALETTE_ENTRY_PROVIDER_EXT_POINT_ID = "org.fusesource.ide.editor.paletteContributor";
    public static final String PALETTE_CATEGORY_NAME = "categoryName";
    public static final String PALETTE_ICON_ATTR = "paletteIcon";
    public static final String DIAGRAM_IMAGE_ATTR = "diagramImage";
    public static final String EXT_ID_ATTR = "id";
    static final int OFFSET_X_DECORATOR = 7;
    static final int OFFSET_Y_VALIDATION_DECORATOR = 18;
    static final int OFFSET_Y_BREAKPOINT_DECORATOR = 2;
    private static Map<ICreateFeature, IConfigurationElement> paletteItemExtensions = new HashMap<ICreateFeature, IConfigurationElement>();
    private static final List<String> CONNECTORS_WHITELIST;
    private static final Set<String> COMPONENTS_FROM_EXTENSION_POINTS;

    static {
        COMPONENTS_FROM_EXTENSION_POINTS = new HashSet<String>();
        CONNECTORS_WHITELIST = new ArrayList<String>();
        CONNECTORS_WHITELIST.add("activemq");
        CONNECTORS_WHITELIST.add("atom");
        CONNECTORS_WHITELIST.add("controlbus");
        CONNECTORS_WHITELIST.add("cxf");
        CONNECTORS_WHITELIST.add("cxfrs");
        CONNECTORS_WHITELIST.add("cxfbean");
        CONNECTORS_WHITELIST.add("direct");
        CONNECTORS_WHITELIST.add("direct-vm");
        CONNECTORS_WHITELIST.add("ejb");
        CONNECTORS_WHITELIST.add("file");
        CONNECTORS_WHITELIST.add("ftp");
        CONNECTORS_WHITELIST.add("ftps");
        CONNECTORS_WHITELIST.add("sftp");
        CONNECTORS_WHITELIST.add("imap");
        CONNECTORS_WHITELIST.add("imaps");
        CONNECTORS_WHITELIST.add("jdbc");
        CONNECTORS_WHITELIST.add("jgroups");
        CONNECTORS_WHITELIST.add("jms");
        CONNECTORS_WHITELIST.add("language");
        CONNECTORS_WHITELIST.add("linkedin");
        CONNECTORS_WHITELIST.add("mina2");
        CONNECTORS_WHITELIST.add("mqtt");
        CONNECTORS_WHITELIST.add("mvel");
        CONNECTORS_WHITELIST.add("netty");
        CONNECTORS_WHITELIST.add("netty-http");
        CONNECTORS_WHITELIST.add("netty4");
        CONNECTORS_WHITELIST.add("netty4-http");
        CONNECTORS_WHITELIST.add("pop3");
        CONNECTORS_WHITELIST.add("pop3s");
        CONNECTORS_WHITELIST.add("quartz");
        CONNECTORS_WHITELIST.add("quartz2");
        CONNECTORS_WHITELIST.add("restlet");
        CONNECTORS_WHITELIST.add("rss");
        CONNECTORS_WHITELIST.add("salesforce");
        CONNECTORS_WHITELIST.add("sap-netweaver");
        CONNECTORS_WHITELIST.add("scheduler");
        CONNECTORS_WHITELIST.add("seda");
        CONNECTORS_WHITELIST.add("servlet");
        CONNECTORS_WHITELIST.add("smtp");
        CONNECTORS_WHITELIST.add("smtps");
        CONNECTORS_WHITELIST.add("snmp");
        CONNECTORS_WHITELIST.add("sql");
        CONNECTORS_WHITELIST.add("timer");
        CONNECTORS_WHITELIST.add("vm");
        CONNECTORS_WHITELIST.add("xquery");
        CONNECTORS_WHITELIST.add("xslt");
    }

    public ToolBehaviourProvider(IDiagramTypeProvider dtp) {
        super(dtp);
    }

    public IContextButtonPadData getContextButtonPad(IPictogramElementContext context) {
        ICreateConnectionFeature[] features;
        ICustomFeature f;
        ICustomFeature[] cf;
        IFeatureProvider featureProvider = this.getFeatureProvider();
        IContextButtonPadData data = super.getContextButtonPad(context);
        PictogramElement pe = context.getPictogramElement();
        Object bo = this.getFeatureProvider().getBusinessObjectForPictogramElement(pe);
        this.setGenericContextButtons(data, pe, CONTEXT_BUTTON_DELETE);
        CustomContext cc = new CustomContext(new PictogramElement[]{pe});
        ICustomFeature[] iCustomFeatureArray = cf = this.getFeatureProvider().getCustomFeatures((ICustomContext)cc);
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            f = iCustomFeatureArray[n2];
            if (f instanceof CollapseFeature && f.canExecute((ICustomContext)cc)) {
                AbstractCamelModelElement bo2;
                String image = "org.eclipse.graphiti.edit.collapse";
                String collapseExpand = "Collapse";
                if (Boolean.parseBoolean(Graphiti.getPeService().getPropertyValue((PropertyContainer)pe, "isCollapsed"))) {
                    image = "org.eclipse.graphiti.edit.expand";
                    collapseExpand = "Expand";
                }
                String name = "";
                if (bo instanceof AbstractCamelModelElement && (bo2 = (AbstractCamelModelElement)bo) != null && bo2.getName() != null) {
                    name = bo2.getName();
                }
                ContextButtonEntry collapseButton = new ContextButtonEntry((IFeature)f, (IContext)cc);
                collapseButton.setDescription(String.valueOf(collapseExpand) + " " + name);
                collapseButton.setText(collapseExpand);
                collapseButton.setIconId(image);
                data.setCollapseContextButton((IContextButtonEntry)collapseButton);
            } else if (f instanceof GoIntoContainerFeature && f.canExecute((ICustomContext)cc) && bo instanceof CamelRouteElement) {
                CamelRouteElement route = (CamelRouteElement)bo;
                ContextButtonEntry goIntoButton = new ContextButtonEntry((IFeature)f, (IContext)cc);
                goIntoButton.setDescription(f.getDescription());
                goIntoButton.setText(f.getName());
                goIntoButton.setIconId("org.fusesource.ide.icons.outline.tree");
                CamelDesignEditor editor = CamelUtils.getDiagramEditor();
                if (editor != null && editor.getModel() != null && editor.getModel().getRouteContainer().getChildElements().size() > 1 && editor.getSelectedContainer() == route) {
                    goIntoButton.setDescription("Show the whole Camel Context");
                    goIntoButton.setText("Show Camel Context");
                    goIntoButton.setIconId("org.fusesource.ide.icons.up_nav");
                }
                data.getGenericContextButtons().add(goIntoButton);
            }
            ++n2;
        }
        CreateConnectionContext ccc = new CreateConnectionContext();
        ccc.setSourcePictogramElement(pe);
        Anchor anchor = null;
        if (pe instanceof Anchor) {
            anchor = (Anchor)pe;
        } else if (pe instanceof AnchorContainer) {
            anchor = Graphiti.getPeService().getChopboxAnchor((AnchorContainer)pe);
        }
        ccc.setSourceAnchor(anchor);
        ContextButtonEntry button = new ContextButtonEntry(null, (IContext)context);
        button.setText("Create connection");
        button.setIconId("org.fusesource.ide.icons.flow");
        ICreateConnectionFeature[] iCreateConnectionFeatureArray = features = featureProvider.getCreateConnectionFeatures();
        int n3 = features.length;
        int n4 = 0;
        while (n4 < n3) {
            ICreateConnectionFeature feature = iCreateConnectionFeatureArray[n4];
            if (feature.isAvailable((IContext)ccc) && feature.canStartConnection((ICreateConnectionContext)ccc)) {
                button.addDragAndDropFeature((IFeature)feature);
            }
            ++n4;
        }
        if (!button.getDragAndDropFeatures().isEmpty()) {
            data.getDomainSpecificContextButtons().add(button);
        }
        cc = new CustomContext(new PictogramElement[]{pe});
        iCustomFeatureArray = cf = this.getFeatureProvider().getCustomFeatures((ICustomContext)cc);
        int n5 = cf.length;
        int n6 = 0;
        while (n6 < n5) {
            f = iCustomFeatureArray[n6];
            if (!(f instanceof DeleteAllEndpointBreakpointsFeature) && f instanceof SetEndpointBreakpointFeature && f.isAvailable((IContext)cc)) {
                ContextButtonEntry button2 = new ContextButtonEntry((IFeature)f, (IContext)cc);
                data.getDomainSpecificContextButtons().add(button2);
            }
            ++n6;
        }
        return data;
    }

    public IContextMenuEntry[] getContextMenu(ICustomContext context) {
        LinkedList<ContextMenuEntry> entries = new LinkedList<ContextMenuEntry>();
        IFeatureProvider fp = this.getFeatureProvider();
        ICustomFeature[] customFeatures = fp.getCustomFeatures(context);
        int i = 0;
        while (i < customFeatures.length) {
            ICustomFeature customFeature = customFeatures[i];
            if (customFeature.isAvailable((IContext)context)) {
                ContextMenuEntry menuEntry = new ContextMenuEntry((IFeature)customFeature, (IContext)context);
                entries.add(menuEntry);
            }
            ++i;
        }
        return entries.toArray(new IContextMenuEntry[entries.size()]);
    }

    public IPaletteCompartmentEntry[] getPalette() {
        ArrayList<PaletteCompartmentEntry> ret = new ArrayList<PaletteCompartmentEntry>();
        PaletteCompartmentEntry compartmentEntryComponents = new PaletteCompartmentEntry(UIMessages.connectorsDrawerTitle, null);
        ret.add(compartmentEntryComponents);
        compartmentEntryComponents.setInitiallyOpen(true);
        PaletteCompartmentEntry compartmentEntryEndpoints = new PaletteCompartmentEntry(UIMessages.endpointsDrawerTitle, null);
        ret.add(compartmentEntryEndpoints);
        compartmentEntryEndpoints.setInitiallyOpen(false);
        PaletteCompartmentEntry compartmentEntryRouting = new PaletteCompartmentEntry(UIMessages.routingDrawerTitle, null);
        ret.add(compartmentEntryRouting);
        compartmentEntryRouting.setInitiallyOpen(false);
        PaletteCompartmentEntry compartmentEntryControlFlow = new PaletteCompartmentEntry(UIMessages.controlFlowDrawerTitle, null);
        ret.add(compartmentEntryControlFlow);
        compartmentEntryControlFlow.setInitiallyOpen(false);
        PaletteCompartmentEntry compartmentEntryTransformation = new PaletteCompartmentEntry(UIMessages.transformationDrawerTitle, null);
        ret.add(compartmentEntryTransformation);
        compartmentEntryTransformation.setInitiallyOpen(false);
        PaletteCompartmentEntry compartmentEntryMisc = new PaletteCompartmentEntry(UIMessages.miscellaneousDrawerTitle, null);
        ret.add(compartmentEntryMisc);
        compartmentEntryMisc.setInitiallyOpen(false);
        HashMap<String, PaletteCompartmentEntry> userdefinedEntries = new HashMap<String, PaletteCompartmentEntry>();
        List<IToolEntry> paletteItems = this.getAggregatedToolEntries();
        for (IToolEntry toolEntry : paletteItems) {
            PaletteCategoryItemProvider.CATEGORY_TYPE pcit;
            String catname;
            ObjectCreationToolEntry octe;
            if (!(toolEntry instanceof ObjectCreationToolEntry) || !((octe = (ObjectCreationToolEntry)toolEntry).getCreateFeature() instanceof PaletteCategoryItemProvider)) continue;
            if (paletteItemExtensions.containsKey(octe.getCreateFeature())) {
                catname = paletteItemExtensions.get(octe.getCreateFeature()).getAttribute(PALETTE_CATEGORY_NAME);
                pcit = PaletteCategoryItemProvider.CATEGORY_TYPE.getCategoryType(catname);
            } else {
                pcit = ((PaletteCategoryItemProvider)octe.getCreateFeature()).getCategoryType();
                catname = ProviderHelper.convertCamelCase(((CreateFigureFeature)octe.getCreateFeature()).getCategoryName());
            }
            switch (pcit) {
                case COMPONENTS: {
                    compartmentEntryComponents.addToolEntry(toolEntry);
                    break;
                }
                case ENDPOINTS: {
                    compartmentEntryEndpoints.addToolEntry(toolEntry);
                    break;
                }
                case ROUTING: {
                    compartmentEntryRouting.addToolEntry(toolEntry);
                    break;
                }
                case CONTROL_FLOW: {
                    compartmentEntryControlFlow.addToolEntry(toolEntry);
                    break;
                }
                case TRANSFORMATION: {
                    compartmentEntryTransformation.addToolEntry(toolEntry);
                    break;
                }
                case MISCELLANEOUS: {
                    compartmentEntryMisc.addToolEntry(toolEntry);
                    break;
                }
                case USER_DEFINED: {
                    PaletteCompartmentEntry def;
                    if (catname != null && !userdefinedEntries.containsKey(catname)) {
                        def = new PaletteCompartmentEntry(catname, null);
                        def.setInitiallyOpen(false);
                        userdefinedEntries.put(catname, def);
                    }
                    def = (PaletteCompartmentEntry)userdefinedEntries.get(catname);
                    def.addToolEntry(toolEntry);
                    break;
                }
            }
        }
        for (PaletteCompartmentEntry e : userdefinedEntries.values()) {
            ret.add(e);
        }
        return ret.toArray(new IPaletteCompartmentEntry[ret.size()]);
    }

    public IDecorator[] getDecorators(PictogramElement pe) {
        LinkedList<IDecorator> decorators = new LinkedList<IDecorator>();
        if (pe.isVisible()) {
            IDecorator[] superDecorators;
            IDecorator[] iDecoratorArray = superDecorators = super.getDecorators(pe);
            int n = superDecorators.length;
            int n2 = 0;
            while (n2 < n) {
                IDecorator d = iDecoratorArray[n2];
                decorators.add(d);
                ++n2;
            }
            Object bo = this.getBusinessObject(pe);
            if (bo instanceof AbstractCamelModelElement) {
                AbstractCamelModelElement node = (AbstractCamelModelElement)bo;
                this.addValidationDecorators(ValidationFactory.getInstance(), decorators, node);
                this.addBreakPointDecorator(decorators, node);
                return decorators.toArray(new IDecorator[decorators.size()]);
            }
        }
        return super.getDecorators(pe);
    }

    private Object getBusinessObject(PictogramElement pe) {
        IFeatureProvider featureProvider = this.getFeatureProvider();
        return featureProvider.getBusinessObjectForPictogramElement(pe);
    }

    private void addBreakPointDecorator(List<IDecorator> decorators, AbstractCamelModelElement node) {
        CamelDesignEditor editor;
        IDiagramContainer diagramContainer = this.getDiagramTypeProvider().getDiagramBehavior().getDiagramContainer();
        if (diagramContainer != null && diagramContainer instanceof CamelDesignEditor && (editor = (CamelDesignEditor)diagramContainer).getWorkspaceProject() != null && editor.getModel() != null) {
            CamelEndpointBreakpoint cep;
            IResource file = editor.getModel().getResource();
            String projectName = editor.getWorkspaceProject().getName();
            IBreakpoint bp = CamelDebugUtils.getBreakpointForSelection((String)node.getId(), (String)file.getName(), (String)projectName);
            if (bp != null && bp instanceof CamelEndpointBreakpoint && (cep = (CamelEndpointBreakpoint)bp).getProjectName().equals(projectName)) {
                try {
                    if (cep.isEnabled() && bp instanceof CamelConditionalBreakpoint) {
                        this.addBreakPointValidator(decorators, "org.fusesource.ide.icons.yellowdot");
                    } else if (cep.isEnabled() && bp instanceof CamelEndpointBreakpoint) {
                        this.addBreakPointValidator(decorators, "org.fusesource.ide.icons.reddot");
                    } else {
                        this.addBreakPointValidator(decorators, "org.fusesource.ide.icons.graydot");
                    }
                }
                catch (CoreException e) {
                    CamelEditorUIActivator.pluginLog().logError((Throwable)e);
                }
            }
        }
    }

    private void addBreakPointValidator(List<IDecorator> decorators, String imgYellowdot) {
        ImageDecorator imageRenderingDecorator = new ImageDecorator(imgYellowdot);
        imageRenderingDecorator.setMessage("");
        imageRenderingDecorator.setX(7);
        imageRenderingDecorator.setY(2);
        decorators.add((IDecorator)imageRenderingDecorator);
    }

    void addValidationDecorators(ValidationFactory validationFactoryInstance, List<IDecorator> decorators, AbstractCamelModelElement node) {
        ValidationResult res = validationFactoryInstance.validate(node);
        if (res.getInformationCount() > 0) {
            this.addValidationDecorator(decorators, String.join((CharSequence)"\n", res.getInformations()), "org.eclipse.graphiti.eclipse.information.tsk");
        }
        if (res.getWarningCount() > 0) {
            this.addValidationDecorator(decorators, String.join((CharSequence)"\n", res.getWarnings()), "org.eclipse.graphiti.eclipse.warning.tsk");
        }
        if (res.getErrorCount() > 0) {
            this.addValidationDecorator(decorators, String.join((CharSequence)"\n", res.getErrors()), "org.eclipse.graphiti.eclipse.error.tsk");
        }
    }

    private void addValidationDecorator(List<IDecorator> decorators, String message, String imgEclipseInformationTsk) {
        ImageDecorator imageRenderingDecorator = new ImageDecorator(imgEclipseInformationTsk);
        imageRenderingDecorator.setMessage(message);
        imageRenderingDecorator.setY(18);
        imageRenderingDecorator.setX(7);
        decorators.add((IDecorator)imageRenderingDecorator);
    }

    public String getToolTip(GraphicsAlgorithm ga) {
        String name;
        PictogramElement pe = ga.getPictogramElement();
        Object bo = this.getFeatureProvider().getBusinessObjectForPictogramElement(pe);
        if (bo instanceof AbstractCamelModelElement && (name = ((AbstractCamelModelElement)bo).getDisplayText()) != null && !name.isEmpty()) {
            return name;
        }
        return (String)super.getToolTip(ga);
    }

    public boolean equalsBusinessObjects(Object o1, Object o2) {
        if (o1 instanceof AbstractCamelModelElement || o2 instanceof AbstractCamelModelElement) {
            return Objects.equal((Object)o1, (Object)o2);
        }
        return super.equalsBusinessObjects(o1, o2);
    }

    public GraphicsAlgorithm[] getClickArea(PictogramElement pe) {
        Object bo = this.getBusinessObject(pe);
        if (bo instanceof AbstractCamelModelElement && !(bo instanceof CamelElementConnection)) {
            GraphicsAlgorithm rectangle = pe.getGraphicsAlgorithm();
            return new GraphicsAlgorithm[]{rectangle};
        }
        return super.getClickArea(pe);
    }

    public GraphicsAlgorithm getSelectionBorder(PictogramElement pe) {
        Object bo = this.getBusinessObject(pe);
        if (bo instanceof AbstractCamelModelElement) {
            return pe.getGraphicsAlgorithm();
        }
        return super.getSelectionBorder(pe);
    }

    public IShapeSelectionInfo getSelectionInfoForShape(Shape shape) {
        ShapeSelectionInfoImpl si = new ShapeSelectionInfoImpl();
        si.setPrimarySelectionHandleBackgroundColor(StyleUtil.CONTAINER_FIGURE_BORDER_COLOR);
        si.setPrimarySelectionHandleForegroundColor(StyleUtil.CONTAINER_FIGURE_BORDER_COLOR);
        si.setColor(StyleUtil.CONTAINER_FIGURE_BORDER_COLOR);
        si.setLineStyle(LineStyle.SOLID);
        return si;
    }

    public boolean isMultiSelectionEnabled() {
        return false;
    }

    public ICustomFeature getDoubleClickFeature(IDoubleClickContext context) {
        return new DoubleClickFeature(this.getFeatureProvider());
    }

    public List<IToolEntry> getPredefinedToolEntries() {
        ArrayList<IToolEntry> entries = new ArrayList<IToolEntry>();
        IPaletteCompartmentEntry[] superCompartments = super.getPalette();
        int i = 1;
        while (i < superCompartments.length) {
            IPaletteCompartmentEntry entry = superCompartments[i];
            for (IToolEntry toolEntry : entry.getToolEntries()) {
                ObjectCreationToolEntry octe;
                if (!(toolEntry instanceof ObjectCreationToolEntry) || !((octe = (ObjectCreationToolEntry)toolEntry).getCreateFeature() instanceof PaletteCategoryItemProvider)) continue;
                entries.add((IToolEntry)octe);
            }
            ++i;
        }
        Collections.sort(entries, Comparator.comparing(IPaletteEntry::getLabel));
        return entries;
    }

    public List<IToolEntry> getExtensionPointToolEntries() {
        IConfigurationElement[] extensions;
        ArrayList<IToolEntry> entries = new ArrayList<IToolEntry>();
        String runtimeProvider = this.determineRuntimeProvider();
        IConfigurationElement[] iConfigurationElementArray = extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(PALETTE_ENTRY_PROVIDER_EXT_POINT_ID);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                ICustomPaletteEntry pe;
                Object o = e.createExecutableExtension("class");
                if (o instanceof ICustomPaletteEntry && (pe = (ICustomPaletteEntry)o).isValid(runtimeProvider)) {
                    ICreateFeature cf = pe.newCreateFeature(this.getFeatureProvider());
                    String schemeId = e.getAttribute(EXT_ID_ATTR);
                    String paletteIcon = Strings.isBlank((String)e.getAttribute(PALETTE_ICON_ATTR)) ? cf.getCreateImageId() : "org.fusesource.ide.icons." + schemeId + "_small";
                    String diagramImg = Strings.isBlank((String)e.getAttribute(DIAGRAM_IMAGE_ATTR)) ? cf.getCreateLargeImageId() : "org.fusesource.ide.icons." + schemeId + "_diagram";
                    ObjectCreationToolEntry te = new ObjectCreationToolEntry(cf.getName(), cf.getDescription(), paletteIcon, diagramImg, cf);
                    entries.add((IToolEntry)te);
                    paletteItemExtensions.put(cf, e);
                    COMPONENTS_FROM_EXTENSION_POINTS.add(schemeId);
                }
            }
            catch (CoreException ex) {
                CamelEditorUIActivator.pluginLog().logError((Throwable)ex);
            }
            ++n2;
        }
        Collections.sort(entries, Comparator.comparing(IPaletteEntry::getLabel));
        return entries;
    }

    private String determineRuntimeProvider() {
        CamelDesignEditor editor = CamelUtils.getDiagramEditor(this.getDiagramTypeProvider());
        if (editor != null) {
            return CamelCatalogUtils.getRuntimeprovider((IProject)editor.getWorkspaceProject(), (IProgressMonitor)new NullProgressMonitor());
        }
        return "karaf";
    }

    public List<IToolEntry> getConnectorsToolEntries() {
        ArrayList<IToolEntry> entries = new ArrayList<IToolEntry>();
        CamelDesignEditor editor = CamelUtils.getDiagramEditor(this.getDiagramTypeProvider());
        CamelModel model = CamelCatalogCacheManager.getInstance().getCamelModelForProject(editor.getModel().getResource().getProject());
        for (Component component : model.getComponents()) {
            if (this.shouldBeIgnored(component.getSchemeTitle())) continue;
            CreateConnectorFigureFeature cf = new CreateConnectorFigureFeature(this.getFeatureProvider(), component);
            ObjectCreationToolEntry te = new ObjectCreationToolEntry(cf.getName(), cf.getDescription(), cf.getCreateImageId(), cf.getCreateLargeImageId(), (ICreateFeature)cf);
            entries.add((IToolEntry)te);
        }
        Collections.sort(entries, Comparator.comparing(IPaletteEntry::getLabel));
        return entries;
    }

    public List<IToolEntry> getAggregatedToolEntries() {
        ArrayList<IToolEntry> entries = new ArrayList<IToolEntry>();
        entries.addAll(this.getPredefinedToolEntries());
        entries.addAll(this.getConnectorsToolEntries());
        entries.addAll(this.getExtensionPointToolEntries());
        Collections.sort(entries, Comparator.comparing(IPaletteEntry::getLabel));
        return entries;
    }

    public boolean shouldBeIgnored(String connectorId) {
        return !CONNECTORS_WHITELIST.contains(connectorId) && !COMPONENTS_FROM_EXTENSION_POINTS.contains(connectorId);
    }
}

