/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.validation.diagram;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.fusesource.ide.camel.model.service.core.catalog.Parameter;
import org.fusesource.ide.camel.model.service.core.catalog.components.Component;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelFile;
import org.fusesource.ide.camel.model.service.core.util.PropertiesUtils;
import org.fusesource.ide.camel.validation.CamelValidationActivator;
import org.fusesource.ide.camel.validation.ValidationResult;
import org.fusesource.ide.camel.validation.ValidationSupport;
import org.fusesource.ide.camel.validation.model.EIPMandatoryChildValidator;
import org.fusesource.ide.camel.validation.model.NumberValidator;
import org.fusesource.ide.camel.validation.model.RefOrDataFormatUnicityChoiceValidator;
import org.fusesource.ide.camel.validation.model.RequiredPropertyValidator;
import org.fusesource.ide.camel.validation.model.TextParameterValidator;
import org.jboss.tools.foundation.core.plugin.log.StatusFactory;

public class BasicNodeValidator
implements ValidationSupport {
    private static Map<IMarker, AbstractCamelModelElement> markers = new HashMap<IMarker, AbstractCamelModelElement>();

    @Override
    public ValidationResult validate(AbstractCamelModelElement camelModelElement) {
        ValidationResult result = new ValidationResult();
        if (camelModelElement != null) {
            if (camelModelElement.getRouteContainer() != null) {
                this.validateDetailProperties(camelModelElement, result);
                Component component = PropertiesUtils.getComponentFor((AbstractCamelModelElement)camelModelElement);
                for (Parameter prop : new ArrayList(PropertiesUtils.getComponentPropertiesFor((AbstractCamelModelElement)camelModelElement))) {
                    String value = PropertiesUtils.getPropertyFromUri((AbstractCamelModelElement)camelModelElement, (Parameter)prop, (Component)component);
                    this.checkFor(result, value, new RequiredPropertyValidator(prop));
                    this.checkFor(result, value, new NumberValidator(prop));
                }
                this.checkFor(result, camelModelElement, new EIPMandatoryChildValidator());
            }
            Set<IMarker> markersRelatedToElement = this.getMarkersFor(camelModelElement);
            this.createOrReuseMarkers(camelModelElement, result, markersRelatedToElement);
            for (IMarker markerToDelete : markersRelatedToElement) {
                try {
                    markerToDelete.delete();
                }
                catch (CoreException e) {
                    CamelValidationActivator.getDefault().getLog().log(StatusFactory.errorStatus((String)"org.fusesource.ide.camel.validation", (String)"Error while clearing validation marker.", (Throwable)e));
                }
            }
        }
        return result;
    }

    private void createOrReuseMarkers(AbstractCamelModelElement camelModelElement, ValidationResult result, Set<IMarker> markersRelatedToElement) {
        CamelFile camelFile = camelModelElement.getCamelFile();
        if (camelFile != null) {
            IResource resource = camelFile.getResource();
            for (String error : result.getErrors()) {
                this.createOrReuseMarker(resource, camelModelElement, error, 2, markersRelatedToElement);
            }
            for (String warning : result.getWarnings()) {
                this.createOrReuseMarker(resource, camelModelElement, warning, 1, markersRelatedToElement);
            }
            for (String info : result.getInformations()) {
                this.createOrReuseMarker(resource, camelModelElement, info, 0, markersRelatedToElement);
            }
        }
    }

    public Set<IMarker> getMarkersFor(AbstractCamelModelElement camelModelElement) {
        try {
            IResource resource;
            CamelFile camelFile = camelModelElement.getCamelFile();
            if (camelFile != null && (resource = camelFile.getResource()) != null && resource.exists()) {
                return this.getMarkersFor(camelModelElement, resource);
            }
        }
        catch (CoreException e) {
            CamelValidationActivator.getDefault().getLog().log(StatusFactory.errorStatus((String)"org.fusesource.ide.camel.validation", (String)"Error while retrieving validation markers.", (Throwable)e));
        }
        return new HashSet<IMarker>();
    }

    protected Set<IMarker> getMarkersFor(AbstractCamelModelElement camelModelElement, IResource resource) throws CoreException {
        HashSet<IMarker> res = new HashSet<IMarker>();
        IMarker[] iMarkerArray = resource.findMarkers("org.fusesource.ide.camel.validation.JBossFuseToolingValidationProblem", true, 2);
        int n = iMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            if (camelModelElement.getId() != null && camelModelElement.getId().equals(marker.getAttribute("IFuseMarker_CAMEL_ID"))) {
                res.add(marker);
            } else {
                AbstractCamelModelElement cmeWithMarker = markers.get(marker);
                if (camelModelElement.equals(cmeWithMarker)) {
                    res.add(marker);
                }
            }
            ++n2;
        }
        return res;
    }

    private void checkFor(ValidationResult result, Object value, IValidator validator) {
        IStatus status = validator.validate(value);
        switch (status.getSeverity()) {
            case 4: {
                result.addError(status.getMessage());
                break;
            }
            case 2: {
                result.addWarning(status.getMessage());
                break;
            }
            case 1: {
                result.addInfo(status.getMessage());
                break;
            }
        }
    }

    private void validateDetailProperties(AbstractCamelModelElement selectedEP, ValidationResult result) {
        for (Parameter prop : PropertiesUtils.getPropertiesFor((AbstractCamelModelElement)selectedEP)) {
            String property = prop.getName();
            if ("element".equalsIgnoreCase(prop.getKind()) && "array".equalsIgnoreCase(prop.getType()) || "org.apache.camel.model.OtherwiseDefinition".equals(prop.getJavaType())) continue;
            Object value = selectedEP.getParameter(property);
            if (PropertiesUtils.isRequired((Parameter)prop) || "id".equals(prop.getName())) {
                this.checkFor(result, value, new TextParameterValidator(selectedEP, prop));
            }
            this.checkFor(result, value, new RefOrDataFormatUnicityChoiceValidator(selectedEP, prop));
        }
    }

    private IMarker createOrReuseMarker(IResource resource, AbstractCamelModelElement cme, String message, int severity, Set<IMarker> markersRelatedToElement) {
        IMarker res = null;
        try {
            Map<String, Object> attributesForPosition = this.managePosition(cme);
            res = this.searchForExistingSimilarMarker(message, severity, markersRelatedToElement, res, attributesForPosition);
            if (res == null) {
                res = this.createMarker(resource, message, severity, attributesForPosition);
            }
            markers.put(res, cme);
        }
        catch (CoreException e) {
            CamelValidationActivator.getDefault().getLog().log(StatusFactory.errorStatus((String)"org.fusesource.ide.camel.validation", (String)"Error creating validation marker.", (Throwable)e));
        }
        markersRelatedToElement.remove(res);
        return res;
    }

    private IMarker createMarker(IResource resource, String message, int severity, Map<String, Object> attributesForPosition) throws CoreException {
        IMarker marker = resource.createMarker("org.fusesource.ide.camel.validation.JBossFuseToolingValidationProblem");
        marker.setAttribute("severity", severity);
        marker.setAttribute("message", (Object)message);
        marker.setAttribute("priority", 2);
        for (Map.Entry<String, Object> attributeForPosition : attributesForPosition.entrySet()) {
            marker.setAttribute(attributeForPosition.getKey(), attributeForPosition.getValue());
        }
        return marker;
    }

    private IMarker searchForExistingSimilarMarker(String message, int severity, Set<IMarker> markersRelatedToElement, IMarker res, Map<String, Object> attributesForPosition) throws CoreException {
        for (IMarker existingMarker : markersRelatedToElement) {
            if (severity != existingMarker.getAttribute("severity", -1) || !message.equals(existingMarker.getAttribute("message"))) continue;
            boolean hasSamePositionAttributes = true;
            for (Map.Entry<String, Object> attributeForPosition : attributesForPosition.entrySet()) {
                if (attributeForPosition.getValue().equals(existingMarker.getAttribute(attributeForPosition.getKey()))) continue;
                hasSamePositionAttributes = false;
                break;
            }
            if (!hasSamePositionAttributes) continue;
            res = existingMarker;
            break;
        }
        return res;
    }

    private Map<String, Object> managePosition(AbstractCamelModelElement cme) {
        List<Integer> foundIds;
        HashMap<String, Object> attributesForPosition = new HashMap<String, Object>();
        Integer lineNumber = -1;
        if (cme.getId() != null && (foundIds = this.findLineNumbers("id=\"" + cme.getId() + "\"", cme.getCamelFile().getDocumentAsXML())).size() == 1) {
            lineNumber = foundIds.get(0);
            attributesForPosition.put("lineNumber", lineNumber);
        }
        if (lineNumber == -1) {
            attributesForPosition.put("location", "/" + this.getCamelPath(cme));
        } else {
            attributesForPosition.put("IFuseMarker_PATH", "/" + this.getCamelPath(cme));
        }
        attributesForPosition.put("IFuseMarker_CAMEL_ID", cme.getId());
        return attributesForPosition;
    }

    public List<Integer> findLineNumbers(String word, String text) {
        ArrayList<Integer> results = new ArrayList<Integer>();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (LineNumberReader rdr = new LineNumberReader(new StringReader(text));){
                String line;
                while ((line = rdr.readLine()) != null) {
                    if (line.indexOf(word) < 0) continue;
                    results.add(rdr.getLineNumber());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            CamelValidationActivator.getDefault().getLog().log(StatusFactory.errorStatus((String)"org.fusesource.ide.camel.validation", (String)"Error while searching for line of validation marker.", (Throwable)e));
        }
        return results;
    }

    private String getCamelPath(AbstractCamelModelElement cme) {
        String res = cme.getDisplayText();
        AbstractCamelModelElement parent = cme.getParent();
        if (parent != null && !(parent instanceof CamelFile)) {
            res = String.valueOf(this.getCamelPath(parent)) + "/" + res;
        }
        return res;
    }

    public void clearMarkers(AbstractCamelModelElement cme) {
        for (IMarker marker : this.getMarkersFor(cme)) {
            try {
                marker.delete();
            }
            catch (CoreException e) {
                CamelValidationActivator.getDefault().getLog().log(StatusFactory.errorStatus((String)"org.fusesource.ide.camel.validation", (String)"Error while deleting validation marker.", (Throwable)e));
            }
        }
    }
}

