/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.imports.sap;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.core.util.IConstantPoolEntry;
import org.eclipse.jdt.core.util.IConstantValueAttribute;
import org.eclipse.jdt.core.util.IFieldInfo;
import org.fusesource.ide.imports.sap.IDoc3ImportSettings;
import org.fusesource.ide.imports.sap.ImportUtils;
import org.fusesource.ide.imports.sap.Messages;
import org.fusesource.ide.imports.sap.SAPArchive;

public class IDoc3Archive
extends SAPArchive {
    private static final String JCOIDOC_VERSION_STRING_DELIMITER = " ";
    private static final String JCOIDOC_CLASSFILE_ENTRY = "com/sap/conn/idoc/jco/JCoIDoc.class";
    public static final String PLUGIN_IDOC = "com.sap.conn.idoc";
    public static final String BUNDLE_CLASS_PATH_VALUE = "bin/,\n sapidoc3.jar";
    public static final String EXPORT_PACKAGE_VALUE = "com.sap.conn.idoc, com.sap.conn.idoc.jco, com.sap.conn.idoc.jco.rt, com.sap.conn.idoc.monitory, com.sap.conn.idoc.rt, com.sap.conn.idoc.rt.cp, com.sap.conn.idoc.rt.record, com.sap.conn.idoc.rt.record.impl, com.sap.conn.idoc.rt.trace, com.sap.conn.idoc.rt.util, com.sap.conn.idoc.rt.xml";
    public static final String IMPORT_PACKAGE_VALUE = "com.sap.conn.jco, com.sap.conn.jco.ext, com.sap.conn.jco.monitor, com.sap.conn.jco.rt, com.sap.conn.jco.rt.json,  com.sap.conn.jco.server, com.sap.conn.jco.session, com.sap.conn.jco.support, com.sap.conn.jco.util";
    public static final String SAPIDOC3_JAR = "sapidoc3.jar";
    private static final char[] VERSION_NAME = new char[]{'V', 'E', 'R', 'S', 'I', 'O', 'N'};
    protected byte[] buf = new byte[32768];
    protected String name;
    protected Map<String, String> manifest = new HashMap<String, String>();
    protected long lastModified;
    private String version = "";
    private byte[] sapidoc3jar;
    private boolean isValid;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IDoc3Archive(String filename) throws IOException {
        this.name = filename;
        File file = new File(filename);
        this.lastModified = file.lastModified();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                FileInputStream is = new FileInputStream(file);
                try {
                    try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                        int numRead;
                        while ((numRead = ((InputStream)is).read(this.buf, 0, this.buf.length)) != -1) {
                            os.write(this.buf, 0, numRead);
                        }
                        this.readArchiveFile(filename, os.toByteArray());
                        this.readIDoc3JarFile();
                        this.readVersion();
                        this.isValid = true;
                    }
                    if (is == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (is == null) throw throwable;
                    ((InputStream)is).close();
                    throw throwable;
                }
                ((InputStream)is).close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.isValid = false;
            throw e;
        }
    }

    public boolean isValid() {
        return this.isValid;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, byte[]> getContents() {
        return this.contents;
    }

    public Map<String, String> getManifest() {
        return this.manifest;
    }

    public byte[] getIDoc3JarFile() {
        return this.sapidoc3jar;
    }

    public String getVersion() {
        return this.version;
    }

    public String getBundleName() {
        return PLUGIN_IDOC;
    }

    public byte[] getSapidoc3jar() {
        return this.sapidoc3jar;
    }

    public void buildIDoc3Plugin(IDoc3ImportSettings settings) throws IOException {
        String bundleFilename = settings.getBundleFilename();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JarOutputStream target = new JarOutputStream(new FileOutputStream(bundleFilename));){
                byte[] bManifest = this.createBundleManifestFile(settings);
                this.addJarEntry(target, "META-INF/MANIFEST.MF", bManifest, this.lastModified);
                this.addJarEntry(target, settings.getBundleIDoc3JarEntry(), this.sapidoc3jar, this.lastModified);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new IOException(Messages.IDoc3Archive_FailedToBuildIDoc3Plugin, e);
        }
    }

    private void readIDoc3JarFile() throws IOException {
        byte[] sapidoc3jar = (byte[])this.contents.get(SAPIDOC3_JAR);
        if (sapidoc3jar == null) {
            throw new IOException(MessageFormat.format(Messages.IDoc3Archive_FileIsMissingFromArchive, SAPIDOC3_JAR));
        }
        this.sapidoc3jar = sapidoc3jar;
    }

    private void readVersion() throws IOException {
        HashMap<String, byte[]> idoc3Contents = new HashMap<String, byte[]>();
        this.readJARFile(this.sapidoc3jar, idoc3Contents);
        byte[] jco3IdocContents = (byte[])idoc3Contents.get(JCOIDOC_CLASSFILE_ENTRY);
        ByteArrayInputStream bais = new ByteArrayInputStream(jco3IdocContents);
        IClassFileReader classfileReader = ToolFactory.createDefaultClassFileReader((InputStream)bais, (int)65535);
        IFieldInfo[] fieldInfos = classfileReader.getFieldInfos();
        int i = 0;
        while (i < fieldInfos.length) {
            IConstantPoolEntry constantPoolEntry;
            IConstantValueAttribute constantValueAttribute;
            if (Arrays.equals(fieldInfos[i].getName(), VERSION_NAME) && (constantValueAttribute = fieldInfos[i].getConstantValueAttribute()) != null && (constantPoolEntry = constantValueAttribute.getConstantValue()).getKind() == 8) {
                this.version = constantPoolEntry.getStringValue();
                if (this.version == null) break;
                this.version = this.version.split(JCOIDOC_VERSION_STRING_DELIMITER)[0];
                break;
            }
            ++i;
        }
    }

    private byte[] createBundleManifestFile(IDoc3ImportSettings settings) throws IOException {
        StringBuilder manifest = new StringBuilder();
        this.writeAttribute(manifest, Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
        this.writeAttribute(manifest, "Bundle-ManifestVersion", "2");
        this.writeAttribute(manifest, "Bundle-Name", settings.getBundleName());
        this.writeAttribute(manifest, "Bundle-SymbolicName", settings.getBundleSymbolicName());
        this.writeAttribute(manifest, "Bundle-Version", settings.getBundleVersion());
        this.writeAttribute(manifest, "Bundle-ClassPath", BUNDLE_CLASS_PATH_VALUE);
        this.writeAttribute(manifest, "Bundle-Vendor", settings.getBundleVendor());
        this.writeAttribute(manifest, "Bundle-RequiredExecutionEnvironment", ImportUtils.getExecutionEnvironment(settings.getRequiredExecutionEnvironmentIndex()));
        this.writeAttribute(manifest, "Export-Package", EXPORT_PACKAGE_VALUE);
        this.writeAttribute(manifest, "Import-Package", IMPORT_PACKAGE_VALUE);
        this.writeAttribute(manifest, "Bundle-ActivationPolicy", "lazy");
        return manifest.toString().getBytes(MANIFEST_ENCODING);
    }
}

