/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.imports.sap;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.fusesource.ide.imports.sap.ArchivesSelectionPage;
import org.fusesource.ide.imports.sap.IDoc3ImportSettings;
import org.fusesource.ide.imports.sap.ImportUtils;
import org.fusesource.ide.imports.sap.InstallOverviewPage;
import org.fusesource.ide.imports.sap.JCo3ImportSettings;
import org.fusesource.ide.imports.sap.Messages;
import org.fusesource.ide.imports.sap.SapLibrariesFeatureArchive;
import org.fusesource.ide.imports.sap.SapToolSuiteInstaller;

public class SAPToolSuiteImportWizard
extends Wizard
implements IImportWizard {
    private static final String SAP_I_DOC_LIBRARY_VERSION_3 = "SAP IDoc Library version 3";
    private static final String SAP_JAVA_CONNECTOR_VERSION_3 = "SAP Java Connector version 3";
    private static final String RED_HAT_INC = "Red Hat, Inc.";
    private DataBindingContext context;
    private JCo3ImportSettings jco3ImportSettings;
    private IDoc3ImportSettings idoc3ImportSettings;
    private static SapLibrariesFeatureArchive sapLibrariesFeatureArchive;
    private InstallOverviewPage downloadPage;
    private ArchivesSelectionPage archivesSelectionPage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(Messages.SAPToolSuiteImportWizard_WindowTitle);
        this.setNeedsProgressMonitor(true);
        int executionEnvironmentIndex = ImportUtils.getExecutionEnvironmentIndex("JavaSE-1.6");
        this.jco3ImportSettings = new JCo3ImportSettings();
        this.jco3ImportSettings.setBundleDeployLocation(ImportUtils.getPluginsFolder());
        this.jco3ImportSettings.setBundleName(SAP_JAVA_CONNECTOR_VERSION_3);
        this.jco3ImportSettings.setBundleVendor(RED_HAT_INC);
        this.jco3ImportSettings.setRequiredExecutionEnvironmentIndex(executionEnvironmentIndex);
        this.idoc3ImportSettings = new IDoc3ImportSettings();
        this.idoc3ImportSettings.setBundleDeployLocation(ImportUtils.getPluginsFolder());
        this.idoc3ImportSettings.setBundleName(SAP_I_DOC_LIBRARY_VERSION_3);
        this.idoc3ImportSettings.setBundleVendor(RED_HAT_INC);
        this.idoc3ImportSettings.setRequiredExecutionEnvironmentIndex(executionEnvironmentIndex);
        sapLibrariesFeatureArchive = new SapLibrariesFeatureArchive();
        sapLibrariesFeatureArchive.setJco3ImportSettings(this.jco3ImportSettings);
        sapLibrariesFeatureArchive.setIdoc3ImportSettings(this.idoc3ImportSettings);
        this.context = new DataBindingContext();
        this.downloadPage = new InstallOverviewPage();
        this.archivesSelectionPage = new ArchivesSelectionPage(this.context, this.jco3ImportSettings, this.idoc3ImportSettings);
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.downloadPage);
        this.addPage((IWizardPage)this.archivesSelectionPage);
    }

    public boolean performFinish() {
        this.context.updateModels();
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)new SapToolSuiteInstaller(sapLibrariesFeatureArchive, this.jco3ImportSettings, this.idoc3ImportSettings));
            return true;
        }
        catch (InvocationTargetException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.SAPToolSuiteImportWizard_SAPImportErrorTitle, (String)e.getLocalizedMessage(), (IStatus)new Status(4, "org.fusesource.ide.imports", Messages.SAPToolSuiteImportWizard_SAPImportErrorMessage, (Throwable)e));
            return false;
        }
        catch (InterruptedException interruptedException) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.SAPToolSuiteImportWizard_SAPImportCancelledTitle, (String)Messages.SAPToolSuiteImportWizard_SAPImportCancelledMessage);
            return false;
        }
    }

    public boolean performCancel() {
        ImportUtils.deleteTemporarySapLibrariesRepository();
        return true;
    }
}

