/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.activemq.navigator;

import com.google.common.base.Objects;
import org.eclipse.swt.graphics.Image;
import org.fusesource.ide.foundation.ui.tree.NodeSupport;
import org.fusesource.ide.foundation.ui.tree.Refreshable;
import org.fusesource.ide.jmx.activemq.ActiveMQJMXPlugin;
import org.fusesource.ide.jmx.activemq.internal.BrokerFacade;
import org.fusesource.ide.jmx.activemq.navigator.ConnectionsNode;
import org.fusesource.ide.jmx.activemq.navigator.QueuesNode;
import org.fusesource.ide.jmx.activemq.navigator.TopicsNode;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;

public class BrokerNode
extends NodeSupport
implements ImageProvider,
Refreshable {
    private final BrokerFacade facade;
    private final String brokerName;
    private String userName;
    private String password;

    public BrokerNode(Node parent, BrokerFacade facade, String brokerName) {
        super(parent);
        this.facade = facade;
        this.brokerName = brokerName;
        this.addChild((Node)new QueuesNode(this));
        this.addChild((Node)new TopicsNode(this));
        this.addChild((Node)new ConnectionsNode(this));
        try {
            this.setPropertyBean(facade.getBrokerAdmin());
        }
        catch (Exception e) {
            ActiveMQJMXPlugin.getLogger().warning("Failed to get broker admin: " + e, (Throwable)e);
        }
    }

    public String toString() {
        return this.brokerName;
    }

    public BrokerFacade getFacade() {
        return this.facade;
    }

    public void refresh() {
        if (this.getParent() instanceof Refreshable) {
            Refreshable refreshable = (Refreshable)this.getParent();
            refreshable.refresh();
        }
    }

    public void handleException(Node node, Exception e) {
        ActiveMQJMXPlugin.getLogger().warning("Failed to load node " + node + " due to: " + e, (Throwable)e);
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public Image getImage() {
        return ActiveMQJMXPlugin.getDefault().getImage("message_broker.png");
    }

    public boolean equals(Object obj) {
        return obj instanceof BrokerNode && obj.hashCode() == this.hashCode();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getConnection(), this.brokerName, this.userName, this.password});
    }
}

