/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.activemq.navigator;

import java.util.Collection;
import java.util.Objects;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.graphics.Image;
import org.fusesource.ide.foundation.ui.tree.RefreshableCollectionNode;
import org.fusesource.ide.foundation.ui.util.ContextMenuProvider;
import org.fusesource.ide.jmx.activemq.ActiveMQJMXPlugin;
import org.fusesource.ide.jmx.activemq.internal.BrokerFacade;
import org.fusesource.ide.jmx.activemq.internal.ConnectionViewFacade;
import org.fusesource.ide.jmx.activemq.navigator.BrokerNode;
import org.fusesource.ide.jmx.activemq.navigator.ConnectionNode;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;

public class ConnectionsNode
extends RefreshableCollectionNode
implements ImageProvider,
ContextMenuProvider {
    private final BrokerNode brokerNode;
    private final BrokerFacade facade;

    public ConnectionsNode(BrokerNode brokerNode) {
        super((Node)brokerNode);
        this.brokerNode = brokerNode;
        this.facade = brokerNode.getFacade();
    }

    public String toString() {
        return "Connections";
    }

    protected void loadChildren() {
        try {
            Collection<ConnectionViewFacade> list = this.facade.getConnections();
            if (list != null) {
                for (ConnectionViewFacade mbean : list) {
                    this.addChild((Node)new ConnectionNode((Node)this, mbean));
                }
            }
        }
        catch (Exception e) {
            this.brokerNode.handleException((Node)this, e);
        }
    }

    public void refresh() {
        this.getBrokerNode().refresh();
    }

    public BrokerNode getBrokerNode() {
        return this.brokerNode;
    }

    public Image getImage() {
        return ActiveMQJMXPlugin.getDefault().getImage("connection_folder.png");
    }

    public void provideContextMenu(IMenuManager menu) {
    }

    protected BrokerFacade getFacade() {
        return this.getBrokerNode().getFacade();
    }

    public boolean equals(Object obj) {
        return obj instanceof ConnectionsNode && obj.hashCode() == this.hashCode();
    }

    public int hashCode() {
        return Objects.hash(this.getConnection(), "AMQConnectionsNode");
    }
}

