/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.activemq.navigator;

import java.util.Objects;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.graphics.Image;
import org.fusesource.ide.foundation.core.util.Strings;
import org.fusesource.ide.foundation.ui.tree.RefreshableCollectionNode;
import org.fusesource.ide.foundation.ui.util.ContextMenuProvider;
import org.fusesource.ide.foundation.ui.util.Shells;
import org.fusesource.ide.jmx.activemq.ActiveMQJMXPlugin;
import org.fusesource.ide.jmx.activemq.Messages;
import org.fusesource.ide.jmx.activemq.internal.BrokerFacade;
import org.fusesource.ide.jmx.activemq.navigator.BrokerNode;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;

public class ConsumersNode
extends RefreshableCollectionNode
implements ImageProvider,
ContextMenuProvider {
    private final BrokerNode brokerNode;

    public ConsumersNode(BrokerNode brokerNode) {
        super((Node)brokerNode);
        this.brokerNode = brokerNode;
    }

    public String toString() {
        return "Consumers";
    }

    protected void loadChildren() {
    }

    public void refresh() {
        this.getBrokerNode().refresh();
    }

    public BrokerNode getBrokerNode() {
        return this.brokerNode;
    }

    public Image getImage() {
        return ActiveMQJMXPlugin.getDefault().getImage("queue_folder.png");
    }

    public void provideContextMenu(IMenuManager menu) {
        Action createQueueAction = new Action(Messages.CreateQueueAction, 32){

            public void run() {
                ConsumersNode.this.showCreateQueueDialog();
            }
        };
        createQueueAction.setToolTipText(Messages.CreateQueueActionToolTip);
        createQueueAction.setImageDescriptor(ActiveMQJMXPlugin.getDefault().getImageDescriptor("new_queue.png"));
        menu.add((IAction)createQueueAction);
    }

    protected void showCreateQueueDialog() {
        InputDialog dialog = new InputDialog(Shells.getShell(), Messages.CreateQueueDialogTitle, Messages.CreateQueueDialogMessage, "", null);
        int result = dialog.open();
        if (result == 0) {
            String queue = dialog.getValue();
            this.createQueue(queue);
        }
    }

    protected void createQueue(String queue) {
        if (!Strings.isBlank((String)queue)) {
            try {
                this.getFacade().getBrokerAdmin().addQueue(queue);
                this.refresh();
            }
            catch (Exception e) {
                ActiveMQJMXPlugin.showUserError("Failed to create Queue", "Failed to create queue: " + queue, e);
            }
        }
    }

    protected BrokerFacade getFacade() {
        return this.getBrokerNode().getFacade();
    }

    public boolean equals(Object obj) {
        return obj instanceof ConsumersNode && obj.hashCode() == this.hashCode();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getConnection(), this.brokerNode});
    }
}

