/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.activemq.navigator;

import java.util.Collection;
import java.util.Objects;
import org.eclipse.swt.graphics.Image;
import org.fusesource.ide.foundation.ui.tree.RefreshableCollectionNode;
import org.fusesource.ide.jmx.activemq.ActiveMQJMXPlugin;
import org.fusesource.ide.jmx.activemq.internal.BrokerFacade;
import org.fusesource.ide.jmx.activemq.internal.ProducerViewFacade;
import org.fusesource.ide.jmx.activemq.navigator.BrokerNode;
import org.fusesource.ide.jmx.activemq.navigator.ProducerNode;
import org.fusesource.ide.jmx.activemq.navigator.QueueNode;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;

public class QueueProducersNode
extends RefreshableCollectionNode
implements ImageProvider {
    private final BrokerNode brokerNode;
    private final QueueNode queueNode;

    public QueueProducersNode(QueueNode queueNode) {
        super((Node)queueNode);
        this.queueNode = queueNode;
        this.brokerNode = queueNode.getBrokerNode();
    }

    public String toString() {
        return "Producers";
    }

    protected void loadChildren() {
        try {
            String name = this.queueNode.getName();
            Collection<ProducerViewFacade> list = this.getFacade().getQueueProducers(name);
            if (list != null) {
                for (ProducerViewFacade mbean : list) {
                    this.addChild((Node)new ProducerNode((Node)this, (Node)this.queueNode, mbean));
                }
            }
        }
        catch (Exception e) {
            this.brokerNode.handleException((Node)this, e);
        }
    }

    public void refresh() {
        this.getBrokerNode().refresh();
    }

    public BrokerNode getBrokerNode() {
        return this.brokerNode;
    }

    public Image getImage() {
        return ActiveMQJMXPlugin.getDefault().getImage("listeners.gif");
    }

    protected BrokerFacade getFacade() {
        return this.getBrokerNode().getFacade();
    }

    public boolean equals(Object obj) {
        return obj instanceof QueueProducersNode && obj.hashCode() == this.hashCode();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getConnection(), this.brokerNode, this.queueNode, "Producer"});
    }
}

