/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.activemq.navigator;

import java.util.Collection;
import java.util.Objects;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.graphics.Image;
import org.fusesource.ide.foundation.core.util.Strings;
import org.fusesource.ide.foundation.ui.tree.RefreshableCollectionNode;
import org.fusesource.ide.foundation.ui.util.ContextMenuProvider;
import org.fusesource.ide.foundation.ui.util.Shells;
import org.fusesource.ide.jmx.activemq.ActiveMQJMXPlugin;
import org.fusesource.ide.jmx.activemq.Messages;
import org.fusesource.ide.jmx.activemq.internal.BrokerFacade;
import org.fusesource.ide.jmx.activemq.internal.TopicViewFacade;
import org.fusesource.ide.jmx.activemq.navigator.BrokerNode;
import org.fusesource.ide.jmx.activemq.navigator.TopicNode;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;

public class TopicsNode
extends RefreshableCollectionNode
implements ImageProvider,
ContextMenuProvider {
    private final BrokerNode brokerNode;
    private final BrokerFacade facade;

    public TopicsNode(BrokerNode brokerNode) {
        super((Node)brokerNode);
        this.brokerNode = brokerNode;
        this.facade = brokerNode.getFacade();
    }

    public String toString() {
        return "Topics";
    }

    protected void loadChildren() {
        try {
            Collection<TopicViewFacade> topics = this.facade.getTopics();
            if (topics != null) {
                for (TopicViewFacade topic : topics) {
                    this.addChild((Node)new TopicNode(this, topic));
                }
            }
        }
        catch (Exception e) {
            this.brokerNode.handleException((Node)this, e);
        }
    }

    public BrokerNode getBrokerNode() {
        return this.brokerNode;
    }

    public Image getImage() {
        return ActiveMQJMXPlugin.getDefault().getImage("topic.png");
    }

    public void provideContextMenu(IMenuManager menu) {
        Action createTopicAction = new Action(Messages.CreateTopicAction, 32){

            public void run() {
                TopicsNode.this.showCreateTopicDialog();
            }
        };
        createTopicAction.setToolTipText(Messages.CreateTopicActionToolTip);
        createTopicAction.setImageDescriptor(ActiveMQJMXPlugin.getDefault().getImageDescriptor("new_topic.png"));
        menu.add((IAction)createTopicAction);
    }

    protected void showCreateTopicDialog() {
        InputDialog dialog = new InputDialog(Shells.getShell(), Messages.CreateTopicDialogTitle, Messages.CreateTopicDialogMessage, "", null);
        int result = dialog.open();
        if (result == 0) {
            String topic = dialog.getValue();
            this.createTopic(topic);
        }
    }

    protected void createTopic(String topic) {
        if (!Strings.isBlank((String)topic)) {
            try {
                this.getFacade().getBrokerAdmin().addTopic(topic);
                this.refresh();
            }
            catch (Exception e) {
                ActiveMQJMXPlugin.showUserError("Failed to create Topic", "Failed to create topic: " + topic, e);
            }
        }
    }

    protected BrokerFacade getFacade() {
        return this.getBrokerNode().getFacade();
    }

    public boolean equals(Object obj) {
        return obj instanceof TopicsNode && obj.hashCode() == this.hashCode();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getConnection(), this.brokerNode, "Topics"});
    }
}

