/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.camel.navigator;

import java.io.File;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.fusesource.ide.camel.editor.CamelEditor;
import org.fusesource.ide.camel.model.service.core.io.CamelIOHandler;
import org.fusesource.ide.camel.model.service.core.jmx.camel.CamelBacklogTracerMBean;
import org.fusesource.ide.camel.model.service.core.jmx.camel.CamelContextMBean;
import org.fusesource.ide.camel.model.service.core.jmx.camel.CamelFabricTracerMBean;
import org.fusesource.ide.camel.model.service.core.jmx.camel.CamelJMXFacade;
import org.fusesource.ide.camel.model.service.core.jmx.camel.CamelProcessorMBean;
import org.fusesource.ide.camel.model.service.core.model.CamelFile;
import org.fusesource.ide.camel.model.service.core.model.CamelRouteContainerElement;
import org.fusesource.ide.foundation.core.functions.Function1;
import org.fusesource.ide.foundation.core.util.IOUtils;
import org.fusesource.ide.foundation.ui.tree.NodeSupport;
import org.fusesource.ide.foundation.ui.tree.RefreshNodeRunnable;
import org.fusesource.ide.foundation.ui.tree.Refreshable;
import org.fusesource.ide.foundation.ui.util.ContextMenuProvider;
import org.fusesource.ide.foundation.ui.util.Nodes;
import org.fusesource.ide.foundation.ui.util.Workbenches;
import org.fusesource.ide.jmx.camel.CamelJMXPlugin;
import org.fusesource.ide.jmx.camel.Messages;
import org.fusesource.ide.jmx.camel.editor.CamelContextNodeEditorInput;
import org.fusesource.ide.jmx.camel.navigator.CachingCamelContextNodeStatisticsContainer;
import org.fusesource.ide.jmx.camel.navigator.CamelContextsNode;
import org.fusesource.ide.jmx.camel.navigator.CamelFacades;
import org.fusesource.ide.jmx.camel.navigator.EndpointsNode;
import org.fusesource.ide.jmx.camel.navigator.ProcessorBeanView;
import org.fusesource.ide.jmx.camel.navigator.RoutesNode;
import org.fusesource.ide.jmx.camel.navigator.TraceExchangeList;
import org.fusesource.ide.jmx.commons.backlogtracermessage.BacklogTracerEventMessage;
import org.fusesource.ide.jmx.commons.backlogtracermessage.BacklogTracerEventMessageParser;
import org.fusesource.ide.jmx.commons.backlogtracermessage.BacklogTracerEventMessages;
import org.fusesource.ide.jmx.commons.messages.IExchange;
import org.fusesource.ide.jmx.commons.messages.IMessage;
import org.fusesource.ide.jmx.commons.messages.ITraceExchangeBrowser;
import org.fusesource.ide.jmx.commons.messages.ITraceExchangeList;
import org.fusesource.ide.jmx.commons.messages.NodeStatisticsContainer;
import org.jboss.tools.jmx.core.IConnectionProvider;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class CamelContextNode
extends NodeSupport
implements Refreshable,
ContextMenuProvider,
ITraceExchangeBrowser,
ImageProvider {
    public static final String CAMEL_EDITOR_ID = "org.fusesource.ide.camel.editor";
    private final CamelContextsNode camelContextsNode;
    private final CamelJMXFacade facade;
    private final CamelContextMBean camelContextMBean;
    private CamelRouteContainerElement camelContext;
    private final RoutesNode routes;
    private static Map<String, TraceExchangeList> traceMessageMap = new ConcurrentHashMap<String, TraceExchangeList>();
    private NodeStatisticsContainer runtimeNodeStatisticsContainer;
    private File tempContextFile = null;
    private ILaunch launch = null;
    private IEditorPart camelEditor;

    public CamelContextNode(CamelContextsNode camelContextsNode, CamelJMXFacade facade, CamelContextMBean camelContext) {
        super((Node)camelContextsNode);
        this.camelContextsNode = camelContextsNode;
        this.facade = facade;
        this.camelContextMBean = camelContext;
        this.routes = new RoutesNode(this);
        this.addChild((Node)this.routes);
        this.addChild((Node)new EndpointsNode(this));
        this.setPropertyBean(camelContext);
    }

    public CamelRouteContainerElement getRouteContainer() {
        IFile camelContextFile = this.createTempContextFile();
        if (camelContextFile != null) {
            CamelIOHandler handler = new CamelIOHandler();
            try {
                camelContextFile.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                CamelFile cf = handler.loadCamelModel((IResource)camelContextFile, (IProgressMonitor)new NullProgressMonitor());
                this.camelContext = cf.getRouteContainer();
            }
            catch (Exception ex) {
                CamelJMXPlugin.getLogger().error((Throwable)ex);
            }
        } else {
            CamelJMXPlugin.getLogger().error("Unable to store the remote camel context " + this.getContextId() + " locally");
        }
        return this.camelContext;
    }

    public String toString() {
        return this.getContextId();
    }

    public void refresh() {
        Nodes.refreshParent((Node)this);
        Display.getDefault().syncExec((Runnable)new RefreshNodeRunnable((NodeSupport)this));
    }

    public CamelContextsNode getCamelContextsNode() {
        return this.camelContextsNode;
    }

    public String getContextId() {
        try {
            return this.camelContextMBean.getCamelId();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getManagementName() {
        try {
            return this.camelContextMBean.getManagementName();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public CamelJMXFacade getFacade() {
        return this.facade;
    }

    public CamelContextMBean getCamelContextMBean() {
        return this.camelContextMBean;
    }

    public String getXmlString() {
        try {
            return this.camelContextMBean.dumpRoutesAsXml();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getXmlText() {
        String routeElement;
        String xml = this.getXmlString();
        if (!xml.contains("<camelContext") && xml.contains(routeElement = "<routes")) {
            xml = xml.replace(routeElement, "<camelContext").replace("</routes>", "</camelContext>");
        }
        return xml;
    }

    public void updateXml(String xml) {
        this.camelContextMBean.addOrUpdateRoutesFromXml(xml);
        this.refresh();
    }

    public RoutesNode getRoutes() {
        return this.routes;
    }

    public boolean isTracing() {
        Object tracer = this.getTracer();
        if (tracer == null) {
            return false;
        }
        if (tracer instanceof CamelBacklogTracerMBean) {
            return ((CamelBacklogTracerMBean)tracer).isEnabled();
        }
        return ((CamelFabricTracerMBean)tracer).isEnabled();
    }

    public void send(String endpointUri, IMessage message) {
        Object body = message.getBody();
        Map headers = message.getHeaders();
        this.getCamelContextMBean().sendBodyAndHeaders(endpointUri, body, headers);
        this.reloadRoutes();
    }

    public void startTracing() {
        try {
            Object tracer = this.getTracer();
            if (tracer instanceof CamelBacklogTracerMBean) {
                ((CamelBacklogTracerMBean)tracer).setEnabled(true);
            } else {
                ((CamelFabricTracerMBean)tracer).setEnabled(true);
            }
            this.reloadRoutes();
            this.refresh();
        }
        catch (Exception e) {
            CamelJMXPlugin.showUserError("Failed to start tracing", "Failed to start tracing context " + (Object)((Object)this), e);
        }
    }

    protected void reloadRoutes() {
        this.routes.refresh();
    }

    public void stopTracing() {
        Object tracer = this.getTracer();
        if (tracer instanceof CamelBacklogTracerMBean) {
            ((CamelBacklogTracerMBean)tracer).setEnabled(false);
        } else {
            ((CamelFabricTracerMBean)tracer).setEnabled(false);
        }
        traceMessageMap.remove(this.getContextId());
        this.reloadRoutes();
        this.refresh();
    }

    public ILaunch editRoutes() {
        IWorkbenchPage page = Workbenches.getActiveWorkbenchPage();
        if (page == null) {
            CamelJMXPlugin.getLogger().warning("No active page!");
        } else {
            IFile camelContextFile = this.createTempContextFile();
            if (camelContextFile != null) {
                this.openEditor(page, camelContextFile);
                this.launch = this.bindRemoteCamelDebug(camelContextFile);
                return this.launch;
            }
            CamelJMXPlugin.getLogger().error("Unable to store the remote camel context " + this.getContextId() + " locally");
        }
        return null;
    }

    private ILaunch bindRemoteCamelDebug(IFile camelContextFile) {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigurationType = manager.getLaunchConfigurationType("org.fusesource.ide.launcher.camelcontext.remote");
        try {
            ILaunchConfigurationWorkingCopy configurationWorkingCopy = launchConfigurationType.newInstance(null, "Remote Camel Debug - " + camelContextFile.getName());
            this.configureJMXParameter(configurationWorkingCopy);
            configurationWorkingCopy.setAttribute("rider.file", camelContextFile.getLocation().toOSString());
            ILaunchConfiguration launchConfiguration = configurationWorkingCopy.doSave();
            return launchConfiguration.launch("debug", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            CamelJMXPlugin.getLogger().warning("Cannot bind Camel Remote Debug", (Throwable)e);
            return null;
        }
    }

    private void configureJMXParameter(ILaunchConfigurationWorkingCopy configurationWorkingCopy) {
        IConnectionWrapper connection = this.getConnection();
        IConnectionProvider provider = connection.getProvider();
        String providerId = provider.getId();
        String connectionName = provider.getName(connection);
        configurationWorkingCopy.setAttribute("org.fusesource.ide.launcher.debug.wrapper.provider.id", providerId);
        configurationWorkingCopy.setAttribute("org.fusesource.ide.launcher.debug.wrapper.connection.name", connectionName);
    }

    private void openEditor(IWorkbenchPage page, IFile camelContextFile) {
        CamelContextNodeEditorInput input = new CamelContextNodeEditorInput(this, camelContextFile);
        try {
            this.camelEditor = page.openEditor((IEditorInput)input, CAMEL_EDITOR_ID, true);
        }
        catch (PartInitException e) {
            CamelJMXPlugin.getLogger().warning("Could not open editor: org.fusesource.ide.camel.editor. Reason: " + (Object)((Object)e), (Throwable)e);
        }
    }

    protected IFile createTempContextFile() {
        try {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(".FuseRemoteCamelContextData");
            if (!project.exists()) {
                project.create((IProgressMonitor)new NullProgressMonitor());
            }
            if (!project.isOpen()) {
                project.open((IProgressMonitor)new NullProgressMonitor());
            }
            if (this.tempContextFile == null) {
                this.tempContextFile = File.createTempFile("camelContext--" + this.getContextId() + "--", ".xml", project.getLocation().toFile());
                this.tempContextFile.deleteOnExit();
            }
            String xml = this.getXmlString();
            IOUtils.writeText((File)this.tempContextFile, (String)xml);
            IFile camelContextFile = project.getFile(this.tempContextFile.getName());
            camelContextFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            return camelContextFile;
        }
        catch (Exception e) {
            CamelJMXPlugin.getLogger().warning("Failed to create temporary file: " + e, (Throwable)e);
            return null;
        }
    }

    public void provideContextMenu(IMenuManager menu) {
        this.provideContextMenu(menu, null);
    }

    public void provideContextMenu(IMenuManager menu, Function1<IMenuManager, Void> fn) {
        Action editAction = new Action(Messages.EditRoutesAction, 32){

            public void run() {
                CamelContextNode.this.editRoutes();
            }

            public boolean isEnabled() {
                return CamelContextNode.this.routes.getChildCount() > 0;
            }
        };
        editAction.setToolTipText(Messages.EditRoutesActionToolTip);
        editAction.setImageDescriptor(CamelJMXPlugin.getDefault().getImageDescriptor("edit_camel_route.png"));
        menu.add((IAction)editAction);
        if (fn != null) {
            fn.apply((Object)menu);
        } else if (this.isMbeanSuspended()) {
            Action resumeContextAction = new Action(Messages.ResumeCamelContextAction, 32){

                public void run() {
                    CamelContextNode.this.resumeMBean();
                }
            };
            resumeContextAction.setToolTipText(Messages.ResumeCamelContextActionToolTip);
            resumeContextAction.setImageDescriptor(CamelJMXPlugin.getDefault().getImageDescriptor("start_camel.png"));
            menu.add((IAction)resumeContextAction);
        } else {
            Action suspendContextAction = new Action(Messages.SuspendCamelContextAction, 32){

                public void run() {
                    CamelContextNode.this.suspendMBean();
                }
            };
            suspendContextAction.setToolTipText(Messages.SuspendCamelContextActionToolTip);
            suspendContextAction.setImageDescriptor(CamelJMXPlugin.getDefault().getImageDescriptor("pause_camel.png"));
            menu.add((IAction)suspendContextAction);
        }
        if (this.canTrace()) {
            Action traceAction;
            menu.add((IContributionItem)new Separator());
            boolean tracing = this.isTracing();
            if (tracing) {
                traceAction = new Action(Messages.StopTraceAction, 32){

                    public void run() {
                        CamelContextNode.this.stopTracing();
                    }

                    public boolean isEnabled() {
                        return CamelContextNode.this.routes.getChildCount() > 0;
                    }
                };
                traceAction.setToolTipText(Messages.StopTraceActionToolTip);
                traceAction.setImageDescriptor(CamelJMXPlugin.getDefault().getImageDescriptor("stop_tracing.png"));
            } else {
                traceAction = new Action(Messages.TraceAction, 32){

                    public void run() {
                        CamelContextNode.this.startTracing();
                    }

                    public boolean isEnabled() {
                        return CamelContextNode.this.routes.getChildCount() > 0;
                    }
                };
                traceAction.setToolTipText(Messages.TraceActionToolTip);
                traceAction.setImageDescriptor(CamelJMXPlugin.getDefault().getImageDescriptor("start_tracing.png"));
            }
            menu.add((IAction)traceAction);
        }
    }

    protected boolean canTrace() {
        return this.getTracer() != null;
    }

    protected void startMBean() {
        this.camelContextMBean.start();
        this.refresh();
    }

    protected void stopMBean() {
        this.camelContextMBean.stop();
        this.camelContextsNode.removeChild((Node)this);
    }

    protected void suspendMBean() {
        this.camelContextMBean.suspend();
        this.refresh();
    }

    protected void resumeMBean() {
        this.camelContextMBean.resume();
        this.refresh();
    }

    public boolean isMbeanSuspended() {
        String state = this.camelContextMBean.getState();
        return org.fusesource.ide.foundation.core.util.Objects.equal((Object)"Suspended", (Object)state);
    }

    public List<IExchange> browseExchanges() {
        String nodeId = null;
        return this.getTraceExchanges(nodeId);
    }

    public NodeStatisticsContainer getNodeStatisticsContainer() {
        if (this.runtimeNodeStatisticsContainer == null) {
            this.runtimeNodeStatisticsContainer = new CachingCamelContextNodeStatisticsContainer(this);
        }
        return this.runtimeNodeStatisticsContainer;
    }

    public NodeStatisticsContainer getNodeStatisticsContainer(String routeId) {
        return this.getNodeStatisticsContainer();
    }

    public ITraceExchangeList getTraceExchangeList(String id) {
        if (id != null) {
            return this.getTraceExchangeList(null);
        }
        String key = this.getContextId();
        TraceExchangeList traceList = traceMessageMap.get(key);
        if (traceList == null) {
            traceList = new TraceExchangeList();
            traceMessageMap.put(key, traceList);
        }
        try {
            Object tracer = this.getTracer();
            if (tracer instanceof CamelBacklogTracerMBean) {
                CamelBacklogTracerMBean camelTracer = (CamelBacklogTracerMBean)tracer;
                String traceXml = camelTracer.dumpAllTracedMessagesAsXml();
                List<BacklogTracerEventMessage> traceMessages = this.getTraceMessagesFromXml(traceXml);
                traceList.addBackLogTraceMessages(traceMessages);
            } else if (tracer instanceof CamelFabricTracerMBean) {
                CamelFabricTracerMBean fabricTracer = (CamelFabricTracerMBean)tracer;
                String traceXml = fabricTracer.dumpAllTracedMessagesAsXml();
                List<BacklogTracerEventMessage> traceMessages = this.getTraceMessagesFromXml(traceXml);
                traceList.addFabricTraceMessages(traceMessages);
            }
        }
        catch (Exception e) {
            CamelJMXPlugin.showUserError("Failed to get tracing messages", "Failed to get tracing messages on CamelContext " + (Object)((Object)this), e);
        }
        return traceList;
    }

    private List<BacklogTracerEventMessage> getTraceMessagesFromXml(String xmlDump) {
        BacklogTracerEventMessages backlogTracerEventMessages = new BacklogTracerEventMessageParser().getBacklogTracerEventMessages(xmlDump);
        return backlogTracerEventMessages.getBacklogTracerEventMessages();
    }

    public static Document loadXMLFromString(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputSource is = new InputSource(new StringReader(xml));
        return builder.parse(is);
    }

    public Image getImage() {
        if (this.isTracing()) {
            return CamelJMXPlugin.getDefault().getImage("camel_tracing.png");
        }
        return CamelJMXPlugin.getDefault().getImage("camel.png");
    }

    public List<IExchange> getTraceExchanges(String id) {
        return this.getTraceExchangeList(id).getExchangeList();
    }

    public Object getTracer() {
        if (!this.isConnectionAvailable()) {
            return null;
        }
        try {
            CamelBacklogTracerMBean mbean = this.getFacade().getCamelTracer(this.getManagementName());
            if (mbean != null) {
                return mbean;
            }
            return this.getFacade().getFabricTracer(this.getManagementName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public CamelProcessorMBean getProcessorMBean(String nodeId) {
        return CamelFacades.getProcessorMBean(this.getFacade(), this.getManagementName(), nodeId);
    }

    public Object createProcessorBeanView(String routeId, String nodeId) {
        return new ProcessorBeanView(this, routeId, nodeId);
    }

    public boolean equals(Object obj) {
        return obj instanceof CamelContextNode && obj.hashCode() == this.hashCode();
    }

    public int hashCode() {
        return Objects.hash(this.getConnection(), this.camelContextMBean);
    }

    public void dispose() {
        if (this.launch != null) {
            try {
                this.launch.terminate();
            }
            catch (DebugException e) {
                CamelJMXPlugin.getLogger().warning("Camel Debug launch cannot be terminated although corresponding JMX connection has been stopped.", (Throwable)e);
            }
        }
        if (this.camelEditor instanceof CamelEditor) {
            ((CamelEditor)this.camelEditor).updatePartName();
        }
    }
}

