/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.karaf.connection.ui;

import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Image;
import org.fusesource.ide.jmx.karaf.KarafJMXPlugin;
import org.jboss.tools.common.jdt.debug.tools.ToolsCore;
import org.jboss.tools.common.jdt.debug.tools.ToolsCoreException;
import org.jboss.tools.jmx.jvmmonitor.core.IActiveJvm;
import org.jboss.tools.jmx.local.ui.JVMLabelProviderDelegate;

public class AutodetectedKarafLabelProvider
implements JVMLabelProviderDelegate {
    private static final String KARAF_HOME_PREFIX = " -Dkaraf.home=";
    private static final String KARAF_HOME_POSTFIX = " ";
    private static final String KARAF_TYPE_KARAF = "Apache Karaf";
    private static final String KARAF_TYPE_FUSE = "JBoss Fuse";
    private static final String KARAF_TYPE_FABRIC8 = "Fabric8";
    private static final String KARAF_TYPE_AMQ = "JBoss A-MQ";
    protected static final Map<String, String> karafSubTypeMap = new HashMap<String, String>();

    static {
        karafSubTypeMap.put("default", KARAF_TYPE_KARAF);
        karafSubTypeMap.put("esb-version.jar", KARAF_TYPE_FUSE);
        karafSubTypeMap.put("fabric-version.jar", KARAF_TYPE_FABRIC8);
        karafSubTypeMap.put("mq-version.jar", KARAF_TYPE_AMQ);
    }

    public boolean accepts(IActiveJvm jvm) {
        return AutodetectedKarafLabelProvider.isKaraf(jvm);
    }

    public Image getImage(IActiveJvm jvm) {
        String karafHomeFolder = AutodetectedKarafLabelProvider.getKarafHomeFolder(jvm);
        String karafSubType = AutodetectedKarafLabelProvider.getKarafSubtype(karafHomeFolder);
        Image i = null;
        if (karafSubType != null) {
            i = karafSubType.equalsIgnoreCase(KARAF_TYPE_FUSE) ? KarafJMXPlugin.getDefault().getSharedImages().image("icons/fuse_server.png") : (karafSubType.equalsIgnoreCase(KARAF_TYPE_FABRIC8) ? KarafJMXPlugin.getDefault().getSharedImages().image("icons/fabric.png") : (karafSubType.equalsIgnoreCase(KARAF_TYPE_AMQ) ? KarafJMXPlugin.getDefault().getSharedImages().image("icons/mq_server.png") : (karafSubType.equalsIgnoreCase(KARAF_TYPE_KARAF) ? KarafJMXPlugin.getDefault().getSharedImages().image("icons/karaf.png") : KarafJMXPlugin.getDefault().getSharedImages().image("icons/container.png"))));
        }
        return i;
    }

    public String getDisplayString(IActiveJvm jvm) {
        String karafHomeFolder = AutodetectedKarafLabelProvider.getKarafHomeFolder(jvm);
        String karafSubType = AutodetectedKarafLabelProvider.getKarafSubtype(karafHomeFolder);
        String displayName = jvm.getMainClass();
        if (karafSubType != null) {
            displayName = karafSubType;
        }
        return displayName;
    }

    static boolean isKaraf(IActiveJvm jvm) {
        String displayName = jvm.getMainClass();
        return AutodetectedKarafLabelProvider.equal("org.apache.karaf.main.Main", displayName);
    }

    private static boolean equal(Object a, Object b) {
        if (a == b) {
            return true;
        }
        return a != null && a.equals(b);
    }

    static String getKarafHomeFolder(IActiveJvm jvm) {
        String karafHomeFolder = null;
        if (!jvm.isRemote()) {
            int start;
            int end;
            String vmArgs = null;
            try {
                vmArgs = ToolsCore.getJvmArgs((String)jvm.getHost().getName(), (int)jvm.getPid());
            }
            catch (ToolsCoreException toolsCoreException) {}
            if (vmArgs != null && (end = vmArgs.indexOf(KARAF_HOME_POSTFIX, (start = vmArgs.indexOf(KARAF_HOME_PREFIX)) + KARAF_HOME_PREFIX.length() + 1)) != -1) {
                karafHomeFolder = vmArgs.substring(start + KARAF_HOME_PREFIX.length(), end);
            }
        }
        return karafHomeFolder;
    }

    static String getKarafSubtype(String karafHomeFolder) {
        File libFolder;
        String karafSubType = null;
        if (karafHomeFolder != null && (libFolder = new File(String.format("%s%slib%s", karafHomeFolder, File.separator, File.separator))).exists() && libFolder.isDirectory()) {
            File[] jars = libFolder.listFiles(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isFile() && f.getName().toLowerCase().endsWith("-version.jar");
                }
            });
            if (jars != null && jars.length == 1) {
                File f = jars[0];
                if (karafSubTypeMap.containsKey(f.getName())) {
                    karafSubType = karafSubTypeMap.get(f.getName());
                }
            } else {
                karafSubType = karafSubTypeMap.get("default");
            }
        }
        return karafSubType;
    }
}

