/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.ui.launch;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.debug.ui.RefreshTab;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.m2e.actions.MavenLaunchConstants;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;
import org.fusesource.ide.foundation.core.util.CamelUtils;
import org.fusesource.ide.foundation.core.util.Strings;
import org.fusesource.ide.foundation.ui.io.CamelXMLEditorInput;
import org.fusesource.ide.launcher.run.util.MavenLaunchUtils;
import org.fusesource.ide.launcher.ui.Activator;
import org.fusesource.ide.launcher.ui.Messages;
import org.fusesource.ide.launcher.ui.launch.CustomLaunchConfigurationLabelProvider;
import org.fusesource.ide.launcher.ui.launch.ExecutePomActionPostProcessor;
import org.fusesource.ide.launcher.ui.launch.InvalidConfigurationException;

public abstract class ExecutePomActionSupport
implements ILaunchShortcut,
IExecutableExtension {
    private final String launchConfigurationId;
    private final String launchConfigTypeId;
    private final String defaultMavenGoals;
    private String goalName;
    private boolean showDialog = false;
    private ExecutePomActionPostProcessor postProcessor;
    private ILaunch launch;

    public ExecutePomActionSupport(String launchConfigurationId, String launchConfigTypeId, String defaultMavenGoals) {
        this.launchConfigurationId = launchConfigurationId;
        this.launchConfigTypeId = launchConfigTypeId;
        this.defaultMavenGoals = defaultMavenGoals;
        this.goalName = defaultMavenGoals;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        if ("WITH_DIALOG".equals(data)) {
            this.showDialog = true;
        } else {
            this.goalName = (String)data;
        }
    }

    public void launch(IEditorPart editor, String mode) {
        if (editor != null) {
            IEditorInput editorInput = editor.getEditorInput();
            if (editorInput instanceof IFileEditorInput) {
                this.launchCamelContext(((IFileEditorInput)editorInput).getFile(), mode);
            } else if (editorInput instanceof CamelXMLEditorInput) {
                this.launchCamelContext(((CamelXMLEditorInput)editorInput).getCamelContextFile(), mode);
            } else {
                IFile targetedFile = (IFile)editorInput.getAdapter(IFile.class);
                if (this.isCamelContentType(targetedFile)) {
                    this.launchCamelContext(targetedFile, mode);
                }
            }
        }
    }

    boolean isCamelContentType(IFile file) {
        if (file != null) {
            try {
                IContentDescription contentDescription = file.getContentDescription();
                return contentDescription != null && "org.fusesource.ide.camel.editor.camelContentType".equals(contentDescription.getContentType().getId());
            }
            catch (CoreException e) {
                Activator.getLogger().error((Throwable)e);
            }
        }
        return false;
    }

    public void setPostProcessor(ExecutePomActionPostProcessor postProcessor) {
        this.postProcessor = postProcessor;
    }

    public ExecutePomActionPostProcessor getPostProcessor() {
        return this.postProcessor;
    }

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object object = structuredSelection.getFirstElement();
            if (object instanceof IFile) {
                this.launch = this.launchCamelContext((IFile)object, mode);
            } else if (object instanceof IProject) {
                this.launch = this.launchCamelContextOnProject((IProject)object, mode);
            }
        }
    }

    ILaunch launchCamelContext(IFile camelFile, String mode) {
        ILaunchConfiguration launchConfiguration;
        if (camelFile == null) {
            return null;
        }
        IContainer basedir = this.findPomXmlBasedir(camelFile.getParent());
        try {
            launchConfiguration = this.getLaunchConfiguration(camelFile, basedir, mode);
            if (launchConfiguration == null && (launchConfiguration = this.createLaunchConfiguration(basedir, this.defaultMavenGoals, camelFile)) == null) {
                return null;
            }
        }
        catch (InvalidConfigurationException invalidConfigurationException) {
            return null;
        }
        boolean isWARPackaging = false;
        try {
            isWARPackaging = MavenLaunchUtils.isPackagingTypeWAR((IFile)basedir.getFile(Path.fromOSString((String)"pom.xml")));
        }
        catch (CoreException ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        ILaunchConfigurationWorkingCopy lc = null;
        try {
            lc = launchConfiguration.getWorkingCopy();
        }
        catch (CoreException ex) {
            Activator.getLogger().error((Throwable)ex);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.ExecutePomActionSupport_UnableToLaunchTitle, (String)(String.valueOf(Messages.ExecutePomActionSupport_UnableToLaunchMessage) + ex.getMessage()));
            return null;
        }
        boolean openDialog = this.showDialog;
        if (!openDialog) {
            try {
                String goals = this.setGoals(isWARPackaging, lc);
                if (Strings.isBlank((String)lc.getAttribute("rider.file", ""))) {
                    lc.setAttribute("rider.file", this.getAttributeURIFormatStorage(camelFile));
                }
                openDialog = Strings.isBlank((String)goals) || Strings.isBlank((String)lc.getAttribute("rider.file", ""));
            }
            catch (CoreException ex) {
                Activator.getLogger().error("Error getting the maven goals from the configuration.", (Throwable)ex);
            }
        }
        if (openDialog) {
            String category = "org.fusesource.ide.launcher.ui.runCamelLaunchGroup";
            if (mode == "debug") {
                category = "org.fusesource.ide.launcher.ui.debugCamelLaunchGroup";
            }
            if (DebugUITools.openLaunchConfigurationPropertiesDialog((Shell)this.getShell(), (ILaunchConfiguration)lc, (String)category, null) == 1) {
                return null;
            }
        }
        try {
            ILaunch launch = lc.doSave().launch(mode, (IProgressMonitor)new NullProgressMonitor());
            this.handlePostLaunch(launch);
            return launch;
        }
        catch (CoreException coreException) {
            DebugUITools.launch((ILaunchConfiguration)lc, (String)mode);
            return null;
        }
    }

    protected String setGoals(boolean isWARPackaging, ILaunchConfigurationWorkingCopy lc) throws CoreException {
        String goals = lc.getAttribute("M2_GOALS", null);
        if (Strings.isBlank((String)goals)) {
            goals = isWARPackaging ? "clean package org.eclipse.jetty:jetty-maven-plugin:run" : "clean package org.apache.camel:camel-maven-plugin:run";
        } else if (goals.contains("clean package")) {
            if (isWARPackaging) {
                if (!(goals = goals.replaceAll("org.apache.camel:camel-maven-plugin:run", "org.eclipse.jetty:jetty-maven-plugin:run")).contains("org.eclipse.jetty:jetty-maven-plugin:run")) {
                    goals = String.valueOf(goals) + " org.eclipse.jetty:jetty-maven-plugin:run";
                }
            } else if (!(goals = goals.replaceAll("org.eclipse.jetty:jetty-maven-plugin:run", "org.apache.camel:camel-maven-plugin:run")).contains("org.apache.camel:camel-maven-plugin:run")) {
                goals = String.valueOf(goals) + " org.apache.camel:camel-maven-plugin:run";
            }
        } else {
            goals = isWARPackaging ? "clean package org.eclipse.jetty:jetty-maven-plugin:run" : "clean package org.apache.camel:camel-maven-plugin:run";
        }
        lc.setAttribute("M2_GOALS", goals);
        return goals;
    }

    private void handlePostLaunch(final ILaunch launch) {
        if (this.postProcessor != null) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (!launch.isTerminated()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    IProcess[] processes = launch.getProcesses();
                    boolean failed = false;
                    IProcess[] iProcessArray = processes;
                    int n = processes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProcess process = iProcessArray[n2];
                        try {
                            if (process.getExitValue() != 0) {
                                failed = true;
                                break;
                            }
                        }
                        catch (DebugException e) {
                            Activator.getLogger().error("Failed to get exit code of build process", (Throwable)e);
                        }
                        ++n2;
                    }
                    if (!failed) {
                        ExecutePomActionSupport.this.postProcessor.executeOnSuccess();
                    } else {
                        ExecutePomActionSupport.this.postProcessor.executeOnFailure();
                    }
                }
            });
            t.setDaemon(false);
            t.start();
        }
    }

    private Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    /*
     * Exception decompiling
     */
    private IContainer findPomXmlBasedir(IContainer dir) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ILaunchConfiguration createLaunchConfiguration(IContainer basedir, String goal, IFile camelFile) {
        try {
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType(this.launchConfigTypeId);
            String launchConfigName = launchManager.generateLaunchConfigurationName(this.getBasicLaunchConfigurationName(camelFile));
            ILaunchConfigurationWorkingCopy workingCopy = launchConfigurationType.newInstance(null, launchConfigName);
            workingCopy.setAttribute(MavenLaunchConstants.ATTR_POM_DIR, basedir.getLocation().toOSString());
            workingCopy.setAttribute("M2_GOALS", goal);
            workingCopy.setAttribute(RefreshTab.ATTR_REFRESH_SCOPE, "${project}");
            workingCopy.setAttribute(RefreshTab.ATTR_REFRESH_RECURSIVE, true);
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, basedir.getProject().getName());
            this.appendAttributes(basedir, workingCopy, goal);
            this.setProjectConfiguration(workingCopy, basedir);
            IPath path = this.getJREContainerPath(basedir);
            if (path != null) {
                workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, path.toPortableString());
            }
            workingCopy.setMappedResources(new IResource[]{basedir, camelFile});
            return workingCopy.doSave();
        }
        catch (CoreException ex) {
            Activator.getLogger().error("Unable to create launch configuration", (Throwable)ex);
            return null;
        }
    }

    protected String getBasicLaunchConfigurationName(IFile camelFile) {
        return NLS.bind((String)Messages.launchConfigurationName, (Object)camelFile.getProject().getName(), (Object)camelFile.getName());
    }

    protected abstract void appendAttributes(IContainer var1, ILaunchConfigurationWorkingCopy var2, String var3);

    private void setProjectConfiguration(ILaunchConfigurationWorkingCopy workingCopy, IContainer basedir) {
        ResolverConfiguration configuration;
        String activeProfiles;
        IFile pomFile;
        IMavenProjectRegistry projectRegistry = MavenPlugin.getMavenProjectRegistry();
        IMavenProjectFacade projectFacade = projectRegistry.create(pomFile = basedir.getFile((IPath)new Path("pom.xml")), false, (IProgressMonitor)new NullProgressMonitor());
        if (projectFacade != null && (activeProfiles = (configuration = projectFacade.getResolverConfiguration()).getSelectedProfiles()) != null && activeProfiles.length() > 0) {
            workingCopy.setAttribute("M2_PROFILES", activeProfiles);
        }
    }

    private IPath getJREContainerPath(IContainer basedir) throws CoreException {
        IProject project = basedir.getProject();
        if (project != null && project.hasNature("org.eclipse.jdt.core.javanature")) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IClasspathEntry[] entries = javaProject.getRawClasspath();
            int i = 0;
            while (i < entries.length) {
                IClasspathEntry entry = entries[i];
                if (JavaRuntime.JRE_CONTAINER.equals(entry.getPath().segment(0))) {
                    return entry.getPath();
                }
                ++i;
            }
        }
        return null;
    }

    private ILaunchConfiguration getLaunchConfiguration(IFile camelFile, IContainer basedir, String mode) {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType(this.launchConfigTypeId);
        IPath basedirLocation = basedir.getLocation();
        if (!this.showDialog) {
            try {
                List<ILaunchConfiguration> matchingConfigs = this.findMatchingLaunchConfiguration(camelFile, launchManager, launchConfigurationType, basedirLocation);
                if (matchingConfigs.size() == 1) {
                    Activator.getLogger().info("Using existing launch configuration");
                    return matchingConfigs.get(0);
                }
                if (matchingConfigs.size() > 1) {
                    IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
                    ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new CustomLaunchConfigurationLabelProvider(labelProvider));
                    dialog.setElements((Object[])matchingConfigs.toArray(new ILaunchConfiguration[matchingConfigs.size()]));
                    dialog.setTitle(Messages.ExecutePomActionSupport_SelectConfigurationDialogTitle);
                    if (mode.equals("debug")) {
                        dialog.setMessage(Messages.ExecutePomActionSupport_SelectDebugConfigurationmessage);
                    } else {
                        dialog.setMessage(Messages.ExecutePomActionSupport_SelectRunConfigurationmessage);
                    }
                    dialog.setMultipleSelection(false);
                    int result = dialog.open();
                    labelProvider.dispose();
                    return result == 0 ? (ILaunchConfiguration)dialog.getFirstResult() : null;
                }
            }
            catch (CoreException ex) {
                Activator.getLogger().error("Unable to get the launch configuration.", (Throwable)ex);
            }
        }
        Activator.getLogger().info("Creating new launch configuration");
        return this.createLaunchConfiguration(basedir, this.goalName, camelFile);
    }

    private List<ILaunchConfiguration> findMatchingLaunchConfiguration(IFile camelFile, ILaunchManager launchManager, ILaunchConfigurationType launchConfigurationType, IPath basedirLocation) throws CoreException {
        ILaunchConfiguration[] launchConfigurations = launchManager.getLaunchConfigurations(launchConfigurationType);
        return Stream.of(launchConfigurations).filter(configuration -> this.isLaunchConfigurationMatching(camelFile, basedirLocation, (ILaunchConfiguration)configuration)).collect(Collectors.toList());
    }

    private boolean isLaunchConfigurationMatching(IFile camelFile, IPath basedirLocation, ILaunchConfiguration configuration) {
        return this.isSameBaseDir(basedirLocation, configuration) && this.isSameCamelFile(camelFile, configuration) && this.isTestStrategyMatching(configuration);
    }

    protected abstract boolean isTestStrategyMatching(ILaunchConfiguration var1);

    protected boolean isSkipTest(ILaunchConfiguration configuration) {
        try {
            return configuration.getAttribute("M2_SKIP_TESTS", false);
        }
        catch (CoreException e) {
            Activator.getLogger().error((Throwable)e);
            return false;
        }
    }

    private boolean isSameBaseDir(IPath basedirLocation, ILaunchConfiguration configuration) {
        String workDir;
        block3: {
            try {
                workDir = MavenLaunchUtils.substituteVar((String)configuration.getAttribute(MavenLaunchConstants.ATTR_POM_DIR, null));
                if (workDir != null) break block3;
                return false;
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        Path workPath = new Path(workDir);
        return basedirLocation.equals((Object)workPath);
    }

    private boolean isSameCamelFile(IFile camelFile, ILaunchConfiguration configuration) {
        try {
            String camelFileFromLaunchConfig = configuration.getAttribute("rider.file", null);
            return camelFile.getLocationURI().compareTo(new URI(camelFileFromLaunchConfig)) == 0;
        }
        catch (URISyntaxException | CoreException e) {
            Activator.getLogger().warning(e);
            return false;
        }
    }

    protected String getSelectedFilePath() {
        StructuredSelection ssel;
        Object elem;
        ISelectionService selService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        ISelection isel = selService.getSelection();
        if (isel != null && isel instanceof StructuredSelection && (elem = (ssel = (StructuredSelection)isel).getFirstElement()) != null && elem instanceof IFile) {
            return this.getAttributeURIFormatStorage((IFile)elem);
        }
        return null;
    }

    private String getAttributeURIFormatStorage(IFile file) {
        return file.getLocationURI().toString();
    }

    protected IFile getPomFile(IContainer basedir) {
        return basedir.getFile(Path.fromOSString((String)"pom.xml"));
    }

    private ILaunch launchCamelContextOnProject(IProject project, String mode) {
        List files;
        block6: {
            files = CamelUtils.getFilesWithCamelContentType((IProject)project);
            if (!files.isEmpty()) break block6;
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.ExecutePomActionSupport_NoCamelXMLFileFoundTitle, (String)Messages.ExecutePomActionSupport_NoCamelXMLFileFoundMessage);
            return null;
        }
        try {
            if (files.size() == 1) {
                return this.launchCamelContext((IFile)files.get(0), mode);
            }
            if (files.size() > 1) {
                Object[] resultArray;
                FilteredResourcesSelectionDialog selector = new FilteredResourcesSelectionDialog(this.getShell(), false, (IContainer)project, 1){

                    protected void fillContentProvider(final FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
                        super.fillContentProvider(new FilteredItemsSelectionDialog.AbstractContentProvider((FilteredItemsSelectionDialog)this){

                            public void add(Object item, FilteredItemsSelectionDialog.ItemsFilter itemsFilter) {
                                if (files.contains(item)) {
                                    contentProvider.add(item, itemsFilter);
                                }
                            }
                        }, itemsFilter, progressMonitor);
                    }
                };
                selector.setTitle(Messages.xmlSelectionDialogOnRunAndDebugTitle);
                selector.setInitialPattern("*.xml");
                if (selector.open() == 0 && (resultArray = selector.getResult()) != null && resultArray.length > 0 && resultArray[0] instanceof IFile) {
                    return this.launchCamelContext((IFile)resultArray[0], mode);
                }
            }
        }
        catch (CoreException e) {
            Activator.getLogger().error("Failed to launch camel context: " + (Object)((Object)e), (Throwable)e);
        }
        return null;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }
}

