/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.debug.model;

import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.core.model.IWatchExpressionDelegate;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.fusesource.ide.launcher.debug.model.CamelStackFrame;
import org.fusesource.ide.launcher.debug.model.values.BaseCamelValue;

public class WatchExpressionDelegate
implements IWatchExpressionDelegate {
    public void evaluateExpression(String expression, IDebugElement context, IWatchExpressionListener listener) {
        IStackFrame frame = null;
        if (context instanceof IStackFrame) {
            frame = (IStackFrame)context;
        } else if (context instanceof IThread) {
            try {
                frame = ((IThread)context).getTopStackFrame();
            }
            catch (DebugException debugException) {}
        }
        if (frame == null) {
            listener.watchEvaluationFinished(null);
        } else {
            CamelStackFrame stackFrame = (CamelStackFrame)frame.getAdapter(CamelStackFrame.class);
            if (stackFrame != null) {
                this.doEvaluation(stackFrame, expression, listener);
            } else {
                listener.watchEvaluationFinished(null);
            }
        }
    }

    protected void doEvaluation(CamelStackFrame stackFrame, String expression, IWatchExpressionListener listener) {
        try {
            new EvaluationRunnable(stackFrame, expression, listener).run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            listener.watchEvaluationFinished(null);
        }
    }

    private final class EvaluationRunnable
    implements IWorkspaceRunnable {
        private final CamelStackFrame fStackFrame;
        private final IWatchExpressionListener fListener;
        private final String fExpression;

        private EvaluationRunnable(CamelStackFrame frame, String expression, IWatchExpressionListener listener) {
            this.fStackFrame = frame;
            this.fExpression = expression;
            this.fListener = listener;
        }

        protected IVariable findVariableForName(Object element, String variableName) throws DebugException {
            IVariable[] vars;
            IVariable[] iVariableArray = vars = this.getVariables(element);
            int n = vars.length;
            int n2 = 0;
            while (n2 < n) {
                IVariable v;
                IVariable var = iVariableArray[n2];
                if (var.getName().equals(variableName)) {
                    return var;
                }
                if (var.getValue().hasVariables() && (v = this.findVariableForName(var.getValue(), variableName)) != null) {
                    return v;
                }
                ++n2;
            }
            return null;
        }

        protected IVariable[] getVariables(Object element) throws DebugException {
            if (element instanceof CamelStackFrame) {
                return ((CamelStackFrame)element).getVariables();
            }
            if (element instanceof BaseCamelValue) {
                return ((BaseCamelValue)element).getVariables();
            }
            return null;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            try {
                final IVariable var = this.findVariableForName(this.fStackFrame, this.fExpression);
                if (var != null) {
                    IWatchExpressionResult watchResult = new IWatchExpressionResult(){

                        public IValue getValue() {
                            try {
                                return var.getValue();
                            }
                            catch (DebugException debugException) {
                                return null;
                            }
                        }

                        public boolean hasErrors() {
                            return false;
                        }

                        public String[] getErrorMessages() {
                            return new String[0];
                        }

                        public String getExpressionText() {
                            try {
                                return var.getName();
                            }
                            catch (DebugException debugException) {
                                return EvaluationRunnable.this.fExpression;
                            }
                        }

                        public DebugException getException() {
                            return null;
                        }
                    };
                    this.fListener.watchEvaluationFinished(watchResult);
                } else {
                    this.fListener.watchEvaluationFinished(null);
                }
            }
            catch (DebugException debugException) {
                this.fListener.watchEvaluationFinished(null);
            }
        }
    }
}

