/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.preferences;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.swt.widgets.Composite;
import org.fusesource.ide.preferences.StagingRepositoryDialog;

public class StagingRepositoryListEditor
extends ListEditor {
    protected StagingRepositoryListEditor() {
    }

    public StagingRepositoryListEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.createControl(parent);
    }

    protected String createList(String[] items) {
        StringBuilder repositories = new StringBuilder("");
        int i = 0;
        while (i < items.length) {
            repositories.append(items[i]);
            repositories.append(";");
            ++i;
        }
        return repositories.toString();
    }

    public String getItemList() {
        return this.createList(super.getList().getItems());
    }

    public boolean isListEnabled() {
        return this.getList().isEnabled();
    }

    protected String getNewInputObject() {
        StagingRepositoryDialog dialog = new StagingRepositoryDialog(this.getShell());
        dialog.setUniquenessList(this.getItemList());
        int rtn = dialog.open();
        if (rtn == 0 && dialog.getURL() != null && dialog.getName() != null) {
            String outUrl = dialog.getURL().trim();
            String outName = dialog.getName().trim();
            if (outUrl.isEmpty() || outName.isEmpty()) {
                return null;
            }
            return String.valueOf(outName) + "," + outUrl;
        }
        return null;
    }

    protected String[] parseString(String stringList) {
        StringTokenizer st = new StringTokenizer(stringList, ";\n\r");
        ArrayList<String> v = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            v.add(st.nextToken());
        }
        return v.toArray(new String[v.size()]);
    }
}

