/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.project.decorator;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.ui.PlatformUI;
import org.fusesource.ide.camel.editor.navigator.CamelCtxNavRouteNode;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelRouteElement;
import org.fusesource.ide.project.Activator;
import org.fusesource.ide.project.providers.CamelVirtualFolder;

public class CamelProblemDecorator
implements ILightweightLabelDecorator {
    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof CamelVirtualFolder) {
            this.decorationForCamelVirtualFolder(element, decoration);
        } else if (element instanceof CamelRouteElement) {
            this.decorationForCamelRoute((CamelRouteElement)element, decoration);
        } else if (element instanceof CamelCtxNavRouteNode) {
            this.decorationForCamelRoute(((CamelCtxNavRouteNode)element).getCamelRoute(), decoration);
        } else if (element instanceof AbstractCamelModelElement) {
            this.decorationForCamelModelElement((AbstractCamelModelElement)element, decoration);
        }
    }

    private void decorationForCamelModelElement(AbstractCamelModelElement cme, IDecoration decoration) {
        try {
            IMarker[] iMarkerArray = this.getFuseMarkers(cme);
            int n = iMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                String id = (String)marker.getAttribute("IFuseMarker_CAMEL_ID");
                if (id != null && id.equals(cme.getId())) {
                    decoration.addOverlay(this.getOverlay((Integer)marker.getAttribute("severity")));
                    return;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Activator.getLogger().error((Throwable)e);
        }
    }

    private IMarker[] getFuseMarkers(AbstractCamelModelElement cme) throws CoreException {
        IResource resource = cme.getCamelFile().getResource();
        if (resource.exists()) {
            return resource.findMarkers("org.fusesource.ide.camel.validation.JBossFuseToolingValidationProblem", true, 2);
        }
        return new IMarker[0];
    }

    private void decorationForCamelVirtualFolder(Object element, IDecoration decoration) {
        for (IResource resource : ((CamelVirtualFolder)element).getCamelFiles()) {
            try {
                int maxProblemSeverity = resource.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 0);
                decoration.addOverlay(this.getOverlay(maxProblemSeverity));
            }
            catch (CoreException e) {
                Activator.getLogger().error((Throwable)e);
            }
        }
    }

    private void decorationForCamelRoute(CamelRouteElement camelRoute, IDecoration decoration) {
        try {
            IMarker[] iMarkerArray = this.getFuseMarkers((AbstractCamelModelElement)camelRoute);
            int n = iMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                String id = (String)marker.getAttribute("IFuseMarker_CAMEL_ID");
                if (id != null && this.isInsideRoute(camelRoute, id)) {
                    decoration.addOverlay(this.getOverlay((Integer)marker.getAttribute("severity")));
                    return;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Activator.getLogger().error((Throwable)e);
        }
    }

    private boolean isInsideRoute(CamelRouteElement camelRoute, String id) {
        AbstractCamelModelElement current = camelRoute.getCamelFile().findNode(id);
        while (current != null) {
            if (camelRoute.equals(current)) {
                return true;
            }
            current = current.getParent();
        }
        return false;
    }

    private ImageDescriptor getOverlay(int problemSeverity) {
        if (problemSeverity == 2) {
            return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_DEC_FIELD_ERROR");
        }
        if (problemSeverity == 1) {
            return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_DEC_FIELD_WARNING");
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

