/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.project.providers;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.IWizardDescriptor;
import org.fusesource.ide.camel.model.service.core.util.CamelFilesFinder;
import org.fusesource.ide.foundation.ui.util.ContextMenuProvider;
import org.fusesource.ide.project.Activator;

public class CamelVirtualFolder
implements ContextMenuProvider {
    private static final String NEW_CAMEL_XML_FILE_WIZARD_ID = "org.fusesource.ide.camel.editor.wizards.NewCamelXmlWizard";
    private IProject project;
    private Set<IResource> camelFiles = new HashSet<IResource>();

    public CamelVirtualFolder(IProject prj) {
        this.project = prj;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new CamelVirtualFolderListener(this.project), 1);
    }

    public IProject getProject() {
        return this.project;
    }

    public String getName() {
        return "Camel Contexts";
    }

    public Set<IResource> getCamelFiles() {
        return this.camelFiles;
    }

    public void populateChildren() {
        if (this.project != null) {
            this.camelFiles.addAll(new CamelFilesFinder().findFiles((IResource)this.project));
        }
    }

    private IResource getAncestorDirectChildOfProject(IProject project, IResource resource) {
        IContainer parent = resource.getParent();
        if (project.equals((Object)parent) || parent == null) {
            return resource;
        }
        return this.getAncestorDirectChildOfProject(project, (IResource)parent);
    }

    public void provideContextMenu(IMenuManager menu) {
        final IWizardDescriptor wiz = PlatformUI.getWorkbench().getNewWizardRegistry().findWizard(NEW_CAMEL_XML_FILE_WIZARD_ID);
        Action action = new Action(){

            public String getText() {
                return "New " + wiz.getLabel();
            }

            public String getToolTipText() {
                return wiz.getDescription();
            }

            public void run() {
                block5: {
                    try {
                        if (wiz == null) break block5;
                        IWorkbenchWizard wizard = wiz.createWizard();
                        WizardDialog wd = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
                        wd.setTitle(wizard.getWindowTitle());
                        try {
                            Field selection = wizard.getClass().getDeclaredField("selection");
                            if (selection != null) {
                                selection.setAccessible(true);
                                StructuredSelection sel = !CamelVirtualFolder.this.getCamelFiles().isEmpty() ? new StructuredSelection((Object)CamelVirtualFolder.this.getCamelFiles().iterator().next().getParent()) : new StructuredSelection((Object)CamelVirtualFolder.this.getProject());
                                selection.set(wizard, sel);
                            }
                        }
                        catch (Exception ex) {
                            Activator.getLogger().error((Throwable)ex);
                        }
                        wd.open();
                    }
                    catch (CoreException e) {
                        Activator.getLogger().error((Throwable)e);
                    }
                }
            }
        };
        menu.add((IAction)action);
    }

    class CamelVirtualFolderListener
    implements IResourceChangeListener {
        private IProject project;

        public CamelVirtualFolderListener(IProject project) {
            this.project = project;
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getType() == 1) {
                try {
                    event.getDelta().accept((IResourceDeltaVisitor)new DeltaPrinter(this.project));
                }
                catch (CoreException ex) {
                    Activator.getLogger().error((Throwable)ex);
                }
            }
        }
    }

    class DeltaPrinter
    implements IResourceDeltaVisitor {
        private IProject project;
        private CamelFilesFinder camelFilesFinder = new CamelFilesFinder();

        public DeltaPrinter(IProject project) {
            this.project = project;
        }

        public boolean visit(IResourceDelta delta) {
            IResource resource = delta.getResource();
            if (resource.getProject() != null && !resource.getProject().equals((Object)this.project)) {
                return false;
            }
            int deltaKind = delta.getKind();
            if (deltaKind == 1) {
                this.visitAddedFile(resource);
            } else if (deltaKind == 2) {
                CamelVirtualFolder.this.camelFiles.remove(resource);
            }
            return true;
        }

        private void visitAddedFile(IResource resource) {
            if (!this.camelFilesFinder.isWorkProjectFolder(this.project, CamelVirtualFolder.this.getAncestorDirectChildOfProject(this.project, resource))) {
                try {
                    if (resource instanceof IFile && new CamelFilesFinder().isFuseCamelContentType((IFile)resource)) {
                        CamelVirtualFolder.this.camelFiles.add(resource);
                    }
                }
                catch (CoreException coreException) {}
            }
        }
    }
}

