/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.projecttemplates.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.fusesource.ide.camel.model.service.core.util.CamelMavenUtils;
import org.fusesource.ide.foundation.ui.io.CamelXMLEditorInput;
import org.fusesource.ide.projecttemplates.internal.Messages;
import org.fusesource.ide.projecttemplates.internal.ProjectTemplatesActivator;
import org.fusesource.ide.projecttemplates.util.maven.MavenUtils;

public class ChangeCamelVersionJob
extends WorkspaceJob {
    private IProject project;
    private String newVersion;

    public ChangeCamelVersionJob(IProject project, String newVersion) {
        super(Messages.switchCamelVersionDialogName);
        this.project = project;
        this.newVersion = newVersion;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        if (!MavenUtils.configureCamelVersionForProject(this.project, this.newVersion, monitor)) {
            return Status.CANCEL_STATUS;
        }
        this.project.setSessionProperty(CamelMavenUtils.CAMEL_VERSION_QNAME, (Object)this.newVersion);
        Display.getDefault().asyncExec(() -> {
            try {
                this.notifyOpenEditors();
            }
            catch (PartInitException ex) {
                ProjectTemplatesActivator.pluginLog().logError((Throwable)ex);
            }
        });
        return Status.OK_STATUS;
    }

    private void notifyOpenEditors() throws PartInitException {
        List<IEditorReference> openCamelEditors = this.findOpenCamelEditors();
        for (IEditorReference eRef : openCamelEditors) {
            CamelXMLEditorInput input = this.getCamelEditorInput(eRef);
            if (input == null || !input.getCamelContextFile().getProject().equals((Object)this.project)) continue;
            IEditorPart editor = eRef.getEditor(true);
            if (!editor.isDirty()) {
                editor.getEditorSite().getPage().closeEditor(editor, false);
                IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)input.getCamelContextFile());
                continue;
            }
            IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IEditorInput)input, (String)"org.fusesource.ide.camel.editor");
            MessageDialog.openWarning((Shell)editor.getEditorSite().getShell(), (String)Messages.reOpenCamelEditorAfterVersionVersionChangeDialogTitle, (String)Messages.reOpenCamelEditorAfterVersionVersionChangeDialogText);
        }
    }

    private CamelXMLEditorInput getCamelEditorInput(IEditorReference eRef) throws PartInitException {
        IEditorInput einput = eRef.getEditorInput();
        if (einput instanceof CamelXMLEditorInput) {
            return (CamelXMLEditorInput)einput;
        }
        return null;
    }

    private List<IEditorReference> findOpenCamelEditors() {
        ArrayList<IEditorReference> openCamelEditors = new ArrayList<IEditorReference>();
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null) {
            IEditorReference[] iEditorReferenceArray = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference eRef = iEditorReferenceArray[n2];
                if ("org.fusesource.ide.camel.editor".equals(eRef.getId())) {
                    openCamelEditors.add(eRef);
                }
                ++n2;
            }
        }
        return openCamelEditors;
    }
}

