/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.projecttemplates.actions.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.fusesource.ide.projecttemplates.actions.ui.SwitchCamelVersionRunnableWithProgress;
import org.fusesource.ide.projecttemplates.actions.ui.SwitchCamelVersionWizardPage;
import org.fusesource.ide.projecttemplates.internal.Messages;
import org.fusesource.ide.projecttemplates.internal.ProjectTemplatesActivator;

public class SwitchCamelVersionWizard
extends Wizard {
    private String initialCamelVersion;
    private SwitchCamelVersionWizardPage page;
    private boolean hasValidCamelVersion = false;

    public SwitchCamelVersionWizard(String currentVersion) {
        this.initialCamelVersion = currentVersion;
        this.setWindowTitle(Messages.switchCamelVersionDialogName);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        super.addPages();
        this.page = new SwitchCamelVersionWizardPage(this.initialCamelVersion);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        String selectedCamelVersion = this.page.getSelectedCamelVersion();
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)new SwitchCamelVersionRunnableWithProgress(this, selectedCamelVersion));
        }
        catch (InterruptedException | InvocationTargetException e) {
            ProjectTemplatesActivator.pluginLog().logError((Throwable)e);
        }
        if (!this.hasValidCamelVersion) {
            this.page.setErrorMessage(NLS.bind((String)Messages.invalidCamelVersionMessage, (Object)selectedCamelVersion));
        }
        return this.hasValidCamelVersion;
    }

    public String getSelectedCamelVersion() {
        return this.page.getSelectedCamelVersion();
    }

    public void setHasValidCamelVersion(boolean hasValidCamelVersion) {
        this.hasValidCamelVersion = hasValidCamelVersion;
    }
}

