/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.projecttemplates.actions.ui;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.fusesource.ide.camel.model.service.core.util.CamelCatalogUtils;
import org.fusesource.ide.foundation.core.util.Strings;
import org.fusesource.ide.projecttemplates.internal.Messages;

public class SwitchCamelVersionWizardPage
extends WizardPage {
    private String initialCamelVersion;
    private String currentSelectedVersion;

    protected SwitchCamelVersionWizardPage(String initialCamelVersion) {
        super(Messages.switchCamelVersionDialogName);
        this.setTitle(Messages.switchCamelVersionDialogName);
        this.setDescription(Messages.switchCamelVersionDialogTitle);
        this.initialCamelVersion = initialCamelVersion;
    }

    public void createControl(Composite container) {
        Composite parent = new Composite(container, 0);
        parent.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        Label lbtVersion = new Label(parent, 0);
        lbtVersion.setText(Messages.switchCamelVersionDialogVersionsLabel);
        Combo versionCombo = new Combo(parent, 131076);
        versionCombo.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        versionCombo.setItems((String[])CamelCatalogUtils.getAllCamelCatalogVersions().stream().sorted((o1, o2) -> o2.compareToIgnoreCase((String)o1)).filter(camelVersion -> !this.initialCamelVersion.equals(camelVersion)).toArray(String[]::new));
        versionCombo.addModifyListener(event -> {
            String string = this.currentSelectedVersion = versionCombo.getText();
        });
        versionCombo.select(0);
        versionCombo.addModifyListener(event -> this.getWizard().getContainer().updateButtons());
        this.setControl((Control)parent);
    }

    public String getSelectedCamelVersion() {
        return this.currentSelectedVersion;
    }

    public boolean isPageComplete() {
        boolean isDifferentVersion;
        boolean bl = isDifferentVersion = !this.initialCamelVersion.equals(this.getSelectedCamelVersion());
        if (!isDifferentVersion) {
            this.setErrorMessage(Messages.switchCamelVersionDialogSameVersionErrorMessage);
        } else if (Strings.isBlank((String)this.getSelectedCamelVersion())) {
            this.setErrorMessage(Messages.switchCamelVersionDialogTitle);
        } else {
            this.setErrorMessage(null);
        }
        return isDifferentVersion && !Strings.isBlank((String)this.getSelectedCamelVersion());
    }
}

