/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.projecttemplates.adopters.creators;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.fusesource.ide.projecttemplates.adopters.creators.InputStreamCreator;
import org.fusesource.ide.projecttemplates.adopters.util.InvalidProjectMetaDataException;
import org.fusesource.ide.projecttemplates.internal.Messages;
import org.fusesource.ide.projecttemplates.internal.ProjectTemplatesActivator;
import org.fusesource.ide.projecttemplates.util.CommonNewProjectMetaData;
import org.osgi.framework.Bundle;

public abstract class UnzipStreamCreator
extends InputStreamCreator {
    @Override
    public boolean create(IProject project, CommonNewProjectMetaData metadata, IProgressMonitor monitor) {
        return this.unzipStream(project, metadata, monitor);
    }

    protected boolean unzipStream(IProject project, CommonNewProjectMetaData metadata, IProgressMonitor monitor) {
        block7: {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.unzipStreamCreatorUnzippingTemplateFileMonitorMessage, (int)2);
            try {
                File folder = new File(project.getLocation().toOSString());
                if (!folder.exists()) {
                    folder.mkdir();
                }
                InputStream is = this.getTemplateStream(metadata);
                subMonitor.worked(1);
                if (is instanceof ZipInputStream) {
                    ZipInputStream zis = (ZipInputStream)this.getTemplateStream(metadata);
                    ZipEntry ze = zis.getNextEntry();
                    while (ze != null) {
                        String fileName = ze.getName();
                        File newFile = new File(folder + File.separator + fileName);
                        if (ze.isDirectory()) {
                            newFile.mkdirs();
                        } else {
                            Path newFilePath = newFile.toPath();
                            Files.createDirectories(newFilePath.getParent(), new FileAttribute[0]);
                            Files.copy(zis, newFilePath, StandardCopyOption.REPLACE_EXISTING);
                        }
                        ze = zis.getNextEntry();
                    }
                    zis.closeEntry();
                    zis.close();
                    subMonitor.worked(1);
                    break block7;
                }
                ProjectTemplatesActivator.pluginLog().logError("Unable to unzip stream of type " + is.getClass().getName());
                return false;
            }
            catch (IOException | InvalidProjectMetaDataException ex) {
                ProjectTemplatesActivator.pluginLog().logError((Throwable)ex);
                return false;
            }
        }
        return true;
    }

    protected InputStream getTemplateStream(String bundleEntry) {
        return this.getTemplateStream(ProjectTemplatesActivator.getBundleContext().getBundle(), bundleEntry);
    }

    protected InputStream getTemplateStream(Bundle bundle, String bundleEntry) {
        URL archiveUrl = bundle.getEntry(bundleEntry);
        if (archiveUrl != null) {
            try {
                return new ZipInputStream(archiveUrl.openStream(), StandardCharsets.UTF_8);
            }
            catch (IOException ex) {
                ProjectTemplatesActivator.pluginLog().logError((Throwable)ex);
            }
        }
        return null;
    }
}

