/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.projecttemplates.util;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.fusesource.ide.projecttemplates.internal.Messages;
import org.fusesource.ide.projecttemplates.internal.ProjectTemplatesActivator;
import org.fusesource.ide.projecttemplates.util.CommonNewProjectMetaData;

public class BasicProjectCreator {
    private IProject project;
    private CommonNewProjectMetaData metadata;

    public BasicProjectCreator(CommonNewProjectMetaData metadata) {
        this.metadata = metadata;
    }

    public boolean create(IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.basicProjectCreatorCreatingProjectMonitorMessage, (int)2);
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            this.project = root.getProject(this.metadata.getProjectName());
            IPath specificLocationPath = this.metadata.getLocationPath();
            if (specificLocationPath != null) {
                IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(this.metadata.getProjectName());
                description.setLocation(specificLocationPath);
                this.project.create(description, (IProgressMonitor)subMonitor.split(1));
            } else {
                this.project.create((IProgressMonitor)subMonitor.split(1));
            }
            this.project.open((IProgressMonitor)subMonitor.split(1));
        }
        catch (CoreException ex) {
            ProjectTemplatesActivator.pluginLog().logError((Throwable)ex);
            return false;
        }
        return true;
    }

    public IProject getProject() {
        return this.project;
    }
}

