/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.projecttemplates.util;

import java.util.Set;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.fusesource.ide.camel.editor.utils.BuildAndRefreshJobWaiterUtil;
import org.fusesource.ide.camel.model.service.core.util.CamelFilesFinder;
import org.fusesource.ide.camel.model.service.core.util.JavaCamelFilesFinder;
import org.fusesource.ide.projecttemplates.internal.ProjectTemplatesActivator;

public class BasicProjectCreatorRunnableUtils {
    private BasicProjectCreatorRunnableUtils() {
    }

    public static void searchCamelContextJavaFile(IProject project, IProgressMonitor monitor, IFile[] holder) {
        IFile f = new JavaCamelFilesFinder().findJavaDSLRouteBuilderClass(project, monitor);
        if (f != null) {
            holder[0] = f;
        }
    }

    public static void searchCamelContextXMLFile(IProject project, IFile[] holder) {
        Set camelFiles = new CamelFilesFinder().findFiles((IResource)project);
        if (!camelFiles.isEmpty()) {
            holder[0] = (IFile)camelFiles.iterator().next();
        }
    }

    public static String getBundleSymbolicNameForProjectName(String projectName) {
        return projectName.replaceAll("[^a-zA-Z0-9-_]", "");
    }

    public static void openCamelFile(IFile file, IProgressMonitor monitor, boolean isJavaEditorToOpen) {
        Display.getDefault().asyncExec(() -> {
            try {
                if (!file.exists()) {
                    new BuildAndRefreshJobWaiterUtil().waitJob(monitor);
                }
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (isJavaEditorToOpen) {
                    IDE.openEditor((IWorkbenchPage)activePage, (IFile)file, (boolean)OpenStrategy.activateOnOpen());
                } else {
                    IDE.setDefaultEditor((IFile)file, (String)"org.fusesource.ide.camel.editor");
                    IDE.openEditor((IWorkbenchPage)activePage, (IFile)file, (String)"org.fusesource.ide.camel.editor", (boolean)OpenStrategy.activateOnOpen());
                }
            }
            catch (PartInitException e) {
                ProjectTemplatesActivator.pluginLog().logError("Cannot open camel context file in editor", (Throwable)e);
            }
        });
    }

    public static boolean isCamelVersionBiggerThan220(String camelVersion) {
        return new ComparableVersion("2.20.0").compareTo(new ComparableVersion(camelVersion)) <= 0;
    }
}

